package com.elitesland.scp.application.service.template;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.domain.entity.template.QScpTemplateSetDO;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrderDO;
import com.elitesland.scp.domain.entity.template.ScpTemplateSetDO;
import com.elitesland.scp.dto.template.DemandOrderDetailRpcParamDTO;
import com.elitesland.scp.dto.template.DemandOrderDetailRpcRespDTO;
import com.elitesland.scp.dto.template.DemandOrderListRpcParamDTO;
import com.elitesland.scp.dto.template.DemandOrderListRpcRespDTO;
import com.elitesland.scp.enums.DayOfWeekEnumHelper;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepo;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepoProc;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.service.template.DemandTemplateRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/5/14 10:42
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class DemandTemplateRpcServiceImpl implements DemandTemplateRpcService {
    private final ScpDemandTemplateSetRepoProc scpDemandTemplateSetRepoProc;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final ScpDemandTemplateSetRepo scpDemandTemplateSetRepo;
    private static final QScpTemplateSetDO scpTemplateSetDO = QScpTemplateSetDO.scpTemplateSetDO;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    public ApiResult<List<DemandOrderListRpcRespDTO>> list(DemandOrderListRpcParamDTO dto) {
        log.info("选择模板列表入参:{}", JSONUtil.toJsonStr(dto));
        List<DemandOrderListRpcRespDTO> templateSetList = scpDemandTemplateSetRepoProc.findTemplateSetList(dto);
        log.info("选择模板列表结果,过滤前:{}", JSONUtil.toJsonStr(templateSetList));
        templateSetList =
                templateSetList.stream().filter(e -> detailedTimeContainsDay(e.getDetailedTime())).collect(Collectors.toList());
        log.info("选择模板列表结果,过滤详细日期后:{}", JSONUtil.toJsonStr(templateSetList));

        String demandWhStCode = dto.getDemandWhStCode();
        String type = dto.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        String region = "";
        if (isStore) {
            OrgStoreDetailRpcDTO storeDetailRpcDTO = rmiOrgStoreRpcService.findOrgStoreByStoreCode(demandWhStCode);
            if (storeDetailRpcDTO != null) {
                region = storeDetailRpcDTO.getRegion();
            }
        }
        List<Long> templateIds =
                templateSetList.stream().map(DemandOrderListRpcRespDTO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        List<Long> tempIdsByType =
                orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(demandWhStCode)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        List<Long> tempIdsByRegion = new ArrayList<>();
        if (StrUtil.isNotBlank(region) && isStore) {
            String finalRegion = region;
            tempIdsByRegion =
                    orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(finalRegion)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        }
        List<Long> expected = new ArrayList<>();
        expected.addAll(tempIdsByType);
        expected.addAll(tempIdsByRegion);
        expected = expected.stream().distinct().collect(Collectors.toList());
        List<Long> finalExpected = expected;
        List<DemandOrderListRpcRespDTO> filterData =
                templateSetList.stream().filter(e -> finalExpected.contains(e.getId())).collect(Collectors.toList());
        log.info("加载模板查询结果,过滤后:{}", JSONUtil.toJsonStr(filterData));
        if (CollUtil.isEmpty(filterData)) {
            return ApiResult.ok();
        }
        List<Long> templateIdsFiltered =
                filterData.stream().map(DemandOrderListRpcRespDTO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderListFiltered = scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIdsFiltered);
        Map<Long, BigDecimal> itemTypeMap = sumItemCodes(orderListFiltered);
        filterData.forEach(
                item -> {
                    item.setTypeNumber(itemTypeMap.get(item.getId()));
                }
        );
        return ApiResult.ok(filterData);
    }

    @Override
    public ApiResult<DemandOrderDetailRpcRespDTO> detail(DemandOrderDetailRpcParamDTO dto) {
        log.info("rpc详情查询入参{}", JSONUtil.toJsonStr(dto));
        DemandOrderDetailRpcRespDTO respVO = new DemandOrderDetailRpcRespDTO();
        Long id = dto.getId();
        String demandTemCode = dto.getDemandTemCode();
        if (id == null && StrUtil.isBlank(demandTemCode)) {
            return ApiResult.ok();
        }

        Optional<ScpTemplateSetDO> templateSetRepoById;
        //优先按id查询
        if (id != null) {
            templateSetRepoById = scpDemandTemplateSetRepo.findById(id);
        } else {
            templateSetRepoById = scpDemandTemplateSetRepo.findOne(scpTemplateSetDO.demandTemCode.eq(demandTemCode));
        }
        //主表数据
        if (templateSetRepoById.isEmpty()) {
            return ApiResult.ok();
        }
        ScpTemplateSetDO templateSetDO = templateSetRepoById.get();
        respVO.setRemark(templateSetDO.getRemark());
        respVO.setDemandTemCode(templateSetDO.getDemandTemCode());
        respVO.setDemandTemName(templateSetDO.getDemandTemName());
        respVO.setDetailedTime(templateSetDO.getDetailedTime());
        respVO.setStartDate(templateSetDO.getStartDate());
        respVO.setEndDate(templateSetDO.getEndDate());
        respVO.setDemandTemStatus(templateSetDO.getDemandTemStatus());
        respVO.setId(templateSetDO.getId());
        //明细行数据 包括门店 商品信息
        List<ScpTemplateOrderDO> orderData = scpDemandOrderTemplateRepoProc.findByMasId(templateSetDO.getId());
        if (CollUtil.isEmpty(orderData)) {
            return ApiResult.ok(respVO);
        }

        List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode = removeDuplicatesByWhStZoCode(orderData);
        List<DemandOrderDetailRpcRespDTO.WhStZoObject> whStZoObjects = removeDuplicatesByWhStZoCode.stream().map(
                order -> {
                    DemandOrderDetailRpcRespDTO.WhStZoObject whStZoObject =
                            new DemandOrderDetailRpcRespDTO.WhStZoObject();
                    if (order.getType() != null) {
                        whStZoObject.setType(order.getType().toString());
                    }
                    if (order.getType() != null) {
                        whStZoObject.setTypeName(getTypeName(whStZoObject.getType()));
                    }
                    whStZoObject.setWhStZoId(order.getWhStZoId());
                    whStZoObject.setWhStZoCode(order.getWhStZoCode());
                    whStZoObject.setWhStZoName(order.getWhStZoName());
                    whStZoObject.setDetailedAddress(order.getDetailedAddress());
                    whStZoObject.setBelongOrgCode(order.getBelongOrgCode());
                    whStZoObject.setBelongOrgName(order.getBelongOrgName());
                    whStZoObject.setBelongOuCode(order.getBelongOuCode());
                    whStZoObject.setBelongOuName(order.getBelongOuName());
                    whStZoObject.setStoreType(order.getStoreType());
                    if (StrUtil.isNotBlank(order.getStoreType())) {
                        whStZoObject.setStoreTypeName(getStoreTypeName(order.getStoreType()));
                    }
                    return whStZoObject;
                }
        ).collect(Collectors.toList());
        respVO.setWhStZoObjects(whStZoObjects);

        List<ScpTemplateOrderDO> removeDuplicatesByItemCode = removeDuplicatesByItemCode(orderData);
        List<DemandOrderDetailRpcRespDTO.ItemObject> itemObjects = removeDuplicatesByItemCode.stream().map(order -> {
            DemandOrderDetailRpcRespDTO.ItemObject itemObject = new DemandOrderDetailRpcRespDTO.ItemObject();
            itemObject.setItemId(order.getItemId());
            itemObject.setItemCode(order.getItemCode());
            itemObject.setItemName(order.getItemName());
            itemObject.setItemCateCode(order.getItemCateCode());  // 注意这里使用的是getItemCateCode()方法
            itemObject.setItemCateName(order.getItemCateName());
            itemObject.setItemSpec(order.getItemSpec());
            itemObject.setBasicUnitMeasure(order.getBasicUnitMeasure());
            itemObject.setWeight(SysUtils.processQtyScale(order.getWeight()));
            itemObject.setDemandQuantity(SysUtils.processQtyScale(order.getDemandQuantity()));
            itemObject.setTotalWeight(SysUtils.processQtyScale(order.getTotalWeight()));  //
            itemObject.setWeightUom(order.getWeightUom());
            itemObject.setWeightUomName(order.getWeightUomName());
            return itemObject;
        }).collect(Collectors.toList());

        respVO.setItemObjects(itemObjects);
        return ApiResult.ok(respVO);
    }


    public Map<Long, BigDecimal> sumItemCodes(List<ScpTemplateOrderDO> orderData) {
        List<ScpTemplateOrderDO> filteredList =
                orderData.stream().filter(e -> StrUtil.isNotBlank(e.getItemCode())).collect(Collectors.toList());
        Map<Long, Set<String>> itemCodesMap = new HashMap<>();
        Map<Long, BigDecimal> sumItemCodesMap = new HashMap<>();

        for (ScpTemplateOrderDO order : filteredList) {
            Long masId = order.getMasId();
            String itemCode = order.getItemCode();

            // 如果itemCodesMap中不包含masId，或者itemCodesMap中包含masId但不包含itemCode，我们就需要计算itemCode
            if (!itemCodesMap.containsKey(masId) || !itemCodesMap.get(masId).contains(itemCode)) {
                BigDecimal sum = sumItemCodesMap.getOrDefault(masId, BigDecimal.ZERO);
                sum = sum.add(BigDecimal.ONE);
                sumItemCodesMap.put(masId, sum);

                // 更新itemCodesMap
                Set<String> itemCodes = itemCodesMap.getOrDefault(masId, new HashSet<>());
                itemCodes.add(itemCode);
                itemCodesMap.put(masId, itemCodes);
            }
        }

        return sumItemCodesMap;
    }

    private boolean detailedTimeContainsDay(String detailedTimeStr) {
        DayOfWeek dayOfWeek = LocalDate.now().getDayOfWeek();
        String dayOfWeekStr = dayOfWeek.toString();
        List<String> list = DayOfWeekEnumHelper.splitAndList(detailedTimeStr);
        return list.contains(dayOfWeekStr);
    }

    private String getTypeName(String type) {
        Map<String, String> templateOrderType = rmiSysUDCService.getCodeMap("yst-suplan", "TEMPLATE_ORDER_TYPE");
        return templateOrderType.get(type);
    }

    private String getStoreTypeName(String storeType) {
        Map<String, String> storeType2 = rmiSysUDCService.getCodeMap("yst-supp", "STORE_TYPE2");
        return storeType2.get(storeType);
    }

    public List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode(List<ScpTemplateOrderDO> orderData) {
        // 使用Java 8的Stream API和Collectors工具类来去重

        return orderData.stream().filter(e -> StrUtil.isNotBlank(e.getWhStZoCode()))
                .collect(Collectors.collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(ScpTemplateOrderDO::getWhStZoCode))),
                        ArrayList::new
                ));
    }

    public List<ScpTemplateOrderDO> removeDuplicatesByItemCode(List<ScpTemplateOrderDO> orderData) {
        // 使用Java 8的Stream API和Collectors工具类来去重

        return orderData.stream().filter(e -> StrUtil.isNotBlank(e.getItemCode()))
                .collect(Collectors.collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(ScpTemplateOrderDO::getItemCode))),
                        ArrayList::new
                ));
    }
}
