package com.elitesland.scp.domain.service.feedback;

import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2025-09-23 18:08:00
 */
public interface ScpStoreFeedbackDomainService {
 /**
     * 检索 
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO queryParam);

    void exportZip(ScpStoreFeedbackQueryParamVO param, HttpServletRequest request, HttpServletResponse response);

    /**
     * 根据关键字段，返回对应的vo
     * @param Code  code
     * @return  对象
     */
    Optional<ScpStoreFeedbackRespVO> findCodeOne(String Code);
    /**
     * 根据关键字段，返回对应的
     * @param Id ID
     * @return 对象
     */
    Optional<ScpStoreFeedbackRespVO> findIdOne(Long Id);
    /**
     * 根据关键字段，返回对应的
     * @param idList ID集合
     * @return 对象
     */
   List<ScpStoreFeedbackRespVO>  findIdBatch(List<Long> idList);
    /**
     * 创建
     *
     * @param  creatParam 对象
     */
    Long createOne(ScpStoreFeedbackSaveVO creatParam);
    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<ScpStoreFeedbackRespVO> createBatch(List<ScpStoreFeedbackSaveVO> List);


    Map<String, String> statusChangeByProcess(long id, ProcInstStatus procInstStatus, String approveComment);

    void updateById(ScpStoreFeedbackRespVO param);

    /**
     * 更新
     *
     * @param  updateParam 对象
     */
    void update(ScpStoreFeedbackSaveVO updateParam) ;

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);
    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);
}


