package com.elitesland.scp.job.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.job.service.ScpDemandSetJobService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "订货集定时任务接口")
@RestController
@RequestMapping(value = "/job/orderSet", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpDemandSetJobController {

    private final ScpDemandSetJobService scpDemandSetJobService;

    @ApiOperation("自动生成订货集")
    @PostMapping("/auto")
    public ApiResult<String> autoCreateDemandSet() {
        scpDemandSetJobService.autoCreateDemandSet();
        return ApiResult.ok();
    }
}
