package com.elitesland.scp.application.facade.vo.boh;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.scp.common.PartitionQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "门店收/退货分页查询")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class StoreReceivePageParam extends PartitionQueryParam {

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发-采购收货单")
    private String docType;

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发-采购收货单")
    private List<String> docTypeList;

    @ApiModelProperty("单号模糊查询")
    private String docNo;

    @ApiModelProperty("状态，DR：待出库，CE：已收货、CF：已收货")
    private List<String> statusList;

    @ApiModelProperty("收/退类型，R：收货，T：退货")
    private String rtType;

    @ApiModelProperty("订货集id")
    private Long orderSetId;

    @ApiModelProperty("订货单id")
    private Long orderId;

    @ApiModelProperty("订货单id")
    private List<Long> orderIds;

    @ApiModelProperty("门店id")
    private List<Long> storeIds;

    @ApiModelProperty("订货单单号")
    private String orderNo;

    @ApiModelProperty("商品关键字")
    private String itemKeyword;

    @ApiModelProperty("商品编码 模糊查询")
    private String itemCode;

    @ApiModelProperty("商品名称 模糊查询")
    private String itemName;

    @ApiModelProperty("类别id集合")
    private List<Long> cateIds;

    @ApiModelProperty("商品id集合")
    private List<Long> itemIds;

    @ApiModelProperty("创建日期开始")
    private LocalDateTime createDateFrom;

    @ApiModelProperty("创建日期结束")
    private LocalDateTime createDateTo;

    @ApiModelProperty("id集合")
    private List<Long> ids;
}
