package com.elitesland.scp.application.facade.vo.calendar;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 04月 02日 10:54
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpCalendarStoreQueryParamVO", description = "日历门店查询条件")
public class ScpCalendarStoreQueryParamVO implements Serializable {

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "时间不能为空")
    private LocalDate findDate;


    @ApiModelProperty(value = "工作状态：W 工作；E:休息")
    private String workStatus;
}
