package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingStoreSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingStoreConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingStoreDO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpAllocSettingStoreDomainServiceImpl implements ScpAllocSettingStoreDomainService {
    private final EntityManager entityManager;
    private final ScpAllocSettingStoreRepo scpAllocSettingStoreRepo;
    private final ScpAllocSettingStoreRepoProc scpAllocSettingStoreRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpAllocSettingStoreRespVO> page(ScpAllocSettingStorePageParamVO paramVO) {
        long count = scpAllocSettingStoreRepoProc.countAllocSettingStore(paramVO);
        if (count > 0) {
            List<ScpAllocSettingStoreRespVO> storeRespVOList = scpAllocSettingStoreRepoProc.queryAllocSettingStore(paramVO);
            return new PagingVO<>(count, storeRespVOList);
        }
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveAllocSettingStore(List<ScpAllocSettingStoreSaveVO> saveVOS, int batchSize) {
        this.batchInsert(ScpAllocSettingStoreConvert.INSTANCE.saveVosDOS(saveVOS), batchSize);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpAllocSettingStoreRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpAllocSettingStoreRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByStoreCode(String storeCode) {
        return scpAllocSettingStoreRepoProc.findMasIdByStoreCode(storeCode);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateAllocNumByParam(List<Long> masIds, String storeCode) {
        scpAllocSettingStoreRepo.updateAllocNumByParam(masIds, storeCode);
    }

    @Override
    public List<ScpAllocSettingStoreRespVO> findByParam(ScpAllocSettingStoreParamVO paramVO) {
        return scpAllocSettingStoreRepoProc.findByParam(paramVO);
    }

    @Override
    public Long updateAllocSettingStore(ScpAllocSettingStoreSaveVO saveVO) {
        Optional<ScpAllocSettingStoreDO> option = scpAllocSettingStoreRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("订货强配门店ID：" + saveVO.getId() + "不存在");
        }
        ScpAllocSettingStoreDO scpAllocSettingDO = option.get();
        ScpAllocSettingStoreConvert.INSTANCE.copySaveParamToDo(saveVO, scpAllocSettingDO);
        return scpAllocSettingStoreRepo.save(scpAllocSettingDO).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpAllocSettingStoreRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingStoreDO> settingStoreDOS = scpAllocSettingStoreRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingStoreDOS)) {
            return ScpAllocSettingStoreConvert.INSTANCE.dosToRespVOS(settingStoreDOS);
        }
        return new ArrayList<>();
    }

    @Override
    public List<ScpAllocSettingStoreRespVO> findEnabledByParam(ScpAllocSettingStoreParamVO paramVO) {
        return scpAllocSettingStoreRepoProc.findEnabledByParam(paramVO);
    }

    public void batchInsert(List<ScpAllocSettingStoreDO> dataList, int batchSize) {
        int index = 0;
        for (ScpAllocSettingStoreDO data : dataList) {
            entityManager.persist(data);
            if (batchSize > 1) {
                // 开启批量
                index++;
                if (index % batchSize == 0) {
                    entityManager.flush();
                    entityManager.clear();
                }
            }
        }
        if (!dataList.isEmpty()) {
            entityManager.flush();
        }
    }
}
