package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreDemandCalendarRespVO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;

import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;

import java.time.LocalDate;
import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
public interface ScpStoreDemandCalendarDomainService {


    PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO createParam);


    void createBatch(List<ScpStoreDemandCalendarDO> createList);

    void deleteBatch(List<Long> ids);

    /**
     * 根据年月门店查询
     * @param concatKey
     * @return
     */
    List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey);

    /**
     * 根据门店、年、月、日查询
     * @param concatKey
     * @return
     */
    List<ScpStoreDemandCalendarDO> findByStoreDayCalendar(List<String> concatKey);


    List<ScpStoreDemandCalendarDTO> listCalendarDTOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam);

    List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param);

    /**
     * 根据条件查询日历门店信息
     * @param param
     * @return
     */
    List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param);

    void batchInsert(List<ScpStoreDemandCalendarDO> createList,int batchSize);

    void deleteByStoreAndYear(List<String> storeCodes,String year);

}