package com.elitesland.scp.infr.repo.authority;


import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ScpDemandAuthorityRepo extends JpaRepository<ScpsmanAuthorityDO, Long>, QuerydslPredicateExecutor<ScpsmanAuthorityDO>
{


    boolean existsByscpsmanNo(String scpsmanNo);

    ScpsmanAuthorityDO findByScpsmanId(Long scpsmanId);

    @Transactional//事务的注解
    @Modifying
//增删改必须有这个注解
    void deleteByScpsmanId(Long scpsmanId);
}
