/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurSuppProvider;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocatioSaveVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationExportRespVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationImportVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageParamVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationParamVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationRespVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationResultVO;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.domain.convert.ScpSupplyAllocationConvert;
import com.elitesland.scp.domain.entity.supalloc.ScpSupplyAllocationDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.supalloc.ScpSupplyAllocationDomainService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.supalloc.ScpSupplyAllocationDTO;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathDRpcDTO;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpSupplyAllocationServiceImpl
implements ScpSupplyAllocationService {
    private static final Logger log = LoggerFactory.getLogger(ScpSupplyAllocationServiceImpl.class);
    private final ScpSupplyAllocationDomainService scpSupplyAllocationDomainService;
    private final UdcProvider udcProvider;
    private final ItmItemRpcService itmItemRpcService;
    private final ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc;
    private final PurSuppProvider purSuppProvider;
    private final ItmItemRpcService itemRpcService;
    private final InvWhProvider whProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final UdcProvider systemService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiInvStkRpcService rmiInvStkService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final RmiItemService rmiItemService;

    @Override
    public PagingVO<ScpSupplyAllocationPageVO> page(ScpSupplyAllocationPageParamVO param) {
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> userAuthority = this.scpDemandAuthorityService.getCurrentUserAuthority();
            if (userAuthority.isEmpty()) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            this.extractedAuthorityParam(param, userAuthority);
        }
        return this.scpSupplyAllocationDomainService.page(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult saveSupplyAllocation(ScpSupplyAllocatioSaveVO createParam) {
        List<ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio> allocatioList = createParam.getScpSupplyAllocatios();
        Map<String, List<ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio>> groupMap = allocatioList.stream().collect(Collectors.groupingBy(d -> d.getStoreWhCode() + d.getItemCode()));
        Set<String> businessKeys = groupMap.keySet();
        List<ScpSupplyAllocationDO> existList = this.scpSupplyAllocationDomainService.findByConcatKeys(businessKeys);
        Map<String, List<ScpSupplyAllocationDO>> existMap = existList.stream().collect(Collectors.groupingBy(d -> d.getStoreWhCode() + d.getItemCode()));
        HashSet<String> updateList = new HashSet<String>();
        ArrayList<ScpSupplyAllocationResultVO.ResultVO> failList = new ArrayList<ScpSupplyAllocationResultVO.ResultVO>();
        ArrayList<ScpSupplyAllocationResultVO.ResultVO> successList = new ArrayList<ScpSupplyAllocationResultVO.ResultVO>();
        ScpSupplyAllocationResultVO result = new ScpSupplyAllocationResultVO();
        this.checkTransactionPath(allocatioList);
        for (Map.Entry<String, List<ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio>> allocatio : groupMap.entrySet()) {
            long count2;
            String allocatioKey = allocatio.getKey();
            List<ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio> allocatios = allocatio.getValue();
            List activateList = allocatios.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).collect(Collectors.toList());
            long count1 = activateList.stream().map(d -> d.getSuppCode() + d.getStoreWhCode() + d.getType() + d.getItemCode()).count();
            if (count1 != (count2 = activateList.stream().map(d -> d.getSuppCode() + d.getStoreWhCode() + d.getType() + d.getItemCode()).distinct().count())) {
                throw new BusinessException(ApiCode.FAIL, String.format("\u6570\u636e\u91cd\u590d,\u4ed3\u5e93\u7f16\u7801/\u95e8\u5e97\u7f16\u7801-\u5546\u54c1\u3010%s-%s\u3011\u5b58\u5728\u76f8\u540c\u3010\u4f9b\u5e94\u5546-\u7c7b\u578b\u3011\u7ec4\u5408\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", allocatios.get(0).getStoreWhCode(), allocatios.get(0).getItemCode()));
            }
            long existCount = allocatios.stream().map(BaseViewModel::getId).filter(Objects::nonNull).count();
            if (!CollUtil.isNotEmpty(activateList)) continue;
            if (existCount == 0L && existMap.containsKey(allocatioKey)) {
                String errorMsg = String.format("\u6570\u636e\u91cd\u590d\uff0c\u4ed3\u5e93\u7f16\u7801/\u95e8\u5e97\u7f16\u7801-\u5546\u54c1\u3010%s-%s\u3011\u914d\u7f6e\u5df2\u5b58\u5728,\u8bf7\u4fee\u6539", allocatios.get(0).getStoreWhCode(), allocatios.get(0).getItemCode());
                throw new BusinessException(ApiCode.FAIL, errorMsg);
            }
            if (existCount > 0L && existMap.containsKey(allocatioKey)) {
                updateList.add(allocatioKey);
            }
            BigDecimal sumAllocation = activateList.stream().map(ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio::getAllocation).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<ScpSupplyAllocationResultVO.ResultVO> resultVOS = this.getResultVOS(allocatios);
            successList.addAll(resultVOS);
        }
        result.setFailList(failList);
        result.setSuccessList(successList);
        if (CollUtil.isEmpty(failList)) {
            if (CollUtil.isNotEmpty(updateList)) {
                List<ScpSupplyAllocationDO> scpSupplyAllocationDOS = this.scpSupplyAllocationDomainService.findByConcatKeys(updateList);
                List<Long> updateIds = scpSupplyAllocationDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
                this.scpSupplyAllocationDomainService.deleteBatch(updateIds);
            }
            List<ScpSupplyAllocationDTO> allocationDOList = createParam.getScpSupplyAllocatios().stream().map(ScpSupplyAllocationConvert.INSTANCE::saveVoToDto).collect(Collectors.toList());
            this.scpSupplyAllocationDomainService.createBatch(allocationDOList);
            return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(true)).code(200)).data((Object)result)).msg("\u64cd\u4f5c\u6210\u529f")).build();
        }
        return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(false)).code(0)).data((Object)result)).msg("\u64cd\u4f5c\u5931\u8d25")).build();
    }

    private void checkTransactionPath(List<ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio> allocatioList) {
        List<String> demandWhCodes = allocatioList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType())).map(ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio::getStoreWhCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> demandWhMap = this.buildInvWhMap(demandWhCodes);
        List<String> demandStoreCodes = allocatioList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).map(ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio::getStoreWhCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> fStoreMap = this.getStoreMap(demandStoreCodes);
        ArrayList<SupportTransactionPathRpcParam> rpcParams = new ArrayList<SupportTransactionPathRpcParam>();
        allocatioList.forEach(row -> {
            Long whOuId;
            String demandWhStCode = row.getStoreWhCode();
            Long ouId = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuId() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuId();
            if (!ouId.equals(whOuId = row.getOuId())) {
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
        });
        Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = this.checkTransactionPathAndBuild(rpcParams);
        allocatioList.forEach(row -> {
            String demandWhStCode = row.getStoreWhCode();
            Long ouId = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuId() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuId();
            String ouCode = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuCode() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuCode();
            Long whOuId = row.getOuId();
            String whOuCode = row.getOuCode();
            if (!ouId.equals(whOuId)) {
                List pathList = (List)suppTransactionPathMap.get(whOuId + "@" + ouId);
                if (CollUtil.isEmpty((Collection)pathList) || StrUtil.isBlank((CharSequence)((SupportTransactionPathRpcDTO)pathList.get(0)).getPathCode())) {
                    log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)whOuId, (Object)ouId);
                    throw new BusinessException("\u4ece\u516c\u53f8\u3010" + whOuCode + "\u3011\u81f3\u516c\u53f8\u3010" + ouCode + "\u3011\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                }
                List detailList = ((SupportTransactionPathRpcDTO)pathList.get(0)).getDetailList();
                int size = detailList.size();
                SupportTransactionPathDRpcDTO dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                row.setSaleOuCode(dto.getCompanyCodeStart());
                row.setSaleOuName(dto.getCompanyNameStart());
                row.setSaleCustCode(dto.getCustCodeEnd());
            }
        });
    }

    private Map<String, InvWhRpcSimpleDTO> buildInvWhMap(List<String> demandWhCodes) {
        if (CollUtil.isEmpty(demandWhCodes)) {
            return new HashMap<String, InvWhRpcSimpleDTO>();
        }
        return this.rmiInvStkService.findInvWhBaseMapByCode(demandWhCodes);
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreMap(List<String> demandStoreCodes) {
        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOS = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStoreCodes);
        if (CollUtil.isEmpty(orgStoreBaseRpcDTOS)) {
            return new HashMap<String, OrgStoreBaseRpcDTO>();
        }
        return orgStoreBaseRpcDTOS.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, List<SupportTransactionPathRpcDTO>> checkTransactionPathAndBuild(List<SupportTransactionPathRpcParam> rpcParams) {
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84,\u53c2\u6570:{}", (Object)JSONObject.toJSONString(rpcParams));
        List data = (List)this.supportTransactionPathRpcService.queryListByParam(rpcParams).getData();
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
        if (CollUtil.isEmpty((Collection)data)) {
            return new HashMap<String, List<SupportTransactionPathRpcDTO>>();
        }
        return data.stream().collect(Collectors.groupingBy(row -> row.getCompanyIdStart() + "@" + row.getCompanyIdEnd()));
    }

    @Override
    public List<ScpSupplyAllocationRespVO> findSupplyAllocationList(ScpSupplyAllocationParamVO param) {
        String bussinessKey = param.getStoreWhCode() + param.getItemCode();
        List<ScpSupplyAllocationDO> allocationDOS = this.scpSupplyAllocationDomainService.findAllByConcatKey(List.of(bussinessKey));
        List<ScpSupplyAllocationRespVO> voList = allocationDOS.stream().map(ScpSupplyAllocationConvert.INSTANCE::doToRespVo).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(voList)) {
            Map typeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", Set.of("DEMAND_SET_TYPE"));
            voList.forEach(d -> {
                d.setTypeName((String)((Map)typeMap.getOrDefault("DEMAND_SET_TYPE", new HashMap())).get(d.getType()));
                if (StringUtils.isNotEmpty((String)d.getItemCateCode())) {
                    List itemCatePath = this.itmItemRpcService.findItemCatePath(d.getItemCateCode());
                    d.setItemCatePath(itemCatePath);
                }
            });
        }
        List suppCodes = voList.stream().map(ScpSupplyAllocationRespVO::getSuppCode).distinct().collect(Collectors.toList());
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(suppCodes);
        List suppList = (List)this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam).getData();
        log.info("\u4f9b\u5e94\u5546\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)suppList));
        if (CollUtil.isEmpty((Collection)suppList)) {
            return voList;
        }
        Map suppMap = suppList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, Function.identity(), (t1, t2) -> t2));
        voList.forEach(item -> {
            if (suppMap.containsKey(item.getSuppCode()) && CollUtil.isNotEmpty((Collection)((PurSuppBaseRpcDTO)suppMap.get(item.getSuppCode())).getSuppOuRespVOList())) {
                item.setSuppOuRespVOList(ScpSupplyAllocationConvert.INSTANCE.dtosToPurSuppOuRespVOs(((PurSuppBaseRpcDTO)suppMap.get(item.getSuppCode())).getSuppOuRespVOList()));
            }
        });
        return voList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteWhNetRelation(List<Long> ids) {
        this.scpSupplyAllocationDomainService.deleteBatch(ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpSupplyAllocationExportRespVO> exportSearch(ScpSupplyAllocationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> userAuthority = this.scpDemandAuthorityService.getCurrentUserAuthority();
            if (userAuthority.isEmpty()) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            this.extractedAuthorityParam(queryParam, userAuthority);
        }
        return this.scpSupplyAllocationDomainService.exportSearch(queryParam);
    }

    @Override
    public List<ScpSupplyAllocationRpcDTO> findSupplyAllocationRpcByParam(ScpSupplyAllocationRpcDtoParam supplyAllocationRpcDtoParam) {
        return this.scpSupplyAllocationRepoProc.findSupplyAllocationRpcByParam(supplyAllocationRpcDtoParam);
    }

    @Override
    public List<String> importSupplyAllocation(List<ScpSupplyAllocationImportVO> dataList, int startRowIndex) {
        SupportTransactionPathRpcDTO data;
        this.checkImportData(dataList, startRowIndex);
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        this.checkImportParam(dataList, errorList);
        List<String> result = this.validResult(errorList);
        List<String> successDocGroup = this.getSuccessDocGroup(result, dataList);
        if (successDocGroup.isEmpty()) {
            return result;
        }
        List<String> ouCodeList = dataList.stream().map(ScpSupplyAllocationImportVO::getOuCode).distinct().collect(Collectors.toList());
        Map ouDataMap = this.rmiOrgOuService.findOuDtoListByOuCodes(ouCodeList).stream().collect(Collectors.toMap(OrgOuRpcDTO::getOuCode, Function.identity()));
        List suppCodes = dataList.stream().map(ScpSupplyAllocationImportVO::getSuppCode).distinct().collect(Collectors.toList());
        List itemCodes = dataList.stream().map(ScpSupplyAllocationImportVO::getItemCode).distinct().collect(Collectors.toList());
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(suppCodes);
        ApiResult suppList = this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
        List suppBaseRpcDTOS = (List)suppList.getData();
        Map<String, PurSuppBaseRpcDTO> suppMap = suppBaseRpcDTOS.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, i -> i, (o, n) -> n));
        ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
        itemRpcDtoParam.setItemCodes(itemCodes);
        List itemInfos = this.itemRpcService.findItemRpcDtoByParam(itemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itemMap = itemInfos.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, i -> i, (o, n) -> n));
        List storeCodes = dataList.stream().filter(d -> UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(d.getType())).map(ScpSupplyAllocationImportVO::getStoreWhCode).distinct().collect(Collectors.toList());
        Map<Object, Object> storeMap = new HashMap();
        if (CollUtil.isNotEmpty(storeCodes)) {
            List storeList = this.orgStoreRpcService.queryByStoreCodes(storeCodes);
            storeMap = storeList.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, i -> i, (o, n) -> n));
        }
        List whCodes = dataList.stream().filter(d -> UdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(d.getType())).map(ScpSupplyAllocationImportVO::getStoreWhCode).distinct().collect(Collectors.toList());
        Map<Object, Object> whMap = new HashMap();
        if (CollUtil.isNotEmpty(whCodes)) {
            InvWhRpcDtoParam whRpcDtoParam = new InvWhRpcDtoParam();
            whRpcDtoParam.setWhCodes(whCodes);
            ApiResult whList = this.whProvider.findWhDTOByParam(whRpcDtoParam);
            whMap = ((List)whList.getData()).stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));
        }
        HashMap errorMap = new HashMap();
        HashMap supplyAllocationMap = new HashMap();
        for (ScpSupplyAllocationImportVO importEntity : dataList) {
            if (!successDocGroup.contains(importEntity.getImportBillNum())) continue;
            errorMap.put(importEntity.getLine(), new ArrayList());
            ArrayList allocationDOS = (ArrayList)supplyAllocationMap.get(importEntity.getImportBillNum());
            if (CollUtil.isEmpty((Collection)allocationDOS)) {
                allocationDOS = new ArrayList();
                supplyAllocationMap.put(importEntity.getImportBillNum(), allocationDOS);
            }
            Iterator allocationDO = new ScpSupplyAllocationDTO();
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSuppCode(importEntity.getSuppCode());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setOuCode(importEntity.getOuCode());
            ItmItemRpcDTO itmItemRpcDTO = itemMap.get(importEntity.getItemCode());
            if (itmItemRpcDTO == null) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5546\u54c1 " + importEntity.getItemCode() + " \u4e0d\u5b58\u5728");
            } else {
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setItemCode(itmItemRpcDTO.getItemCode());
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setItemId(itmItemRpcDTO.getId());
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setItemName(itmItemRpcDTO.getItemName());
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setItemCateName(itmItemRpcDTO.getItemCateFullName());
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setItemCateCode(itmItemRpcDTO.getItemCateCode());
            }
            OrgOuRpcDTO orgOuRpcDTO = (OrgOuRpcDTO)ouDataMap.get(importEntity.getOuCode());
            if (orgOuRpcDTO == null) {
                ((List)errorMap.get(importEntity.getLine())).add("\u91c7\u8d2d\u516c\u53f8\u7f16\u7801" + importEntity.getOuCode() + " \u4e0d\u5b58\u5728");
            } else {
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setOuId(orgOuRpcDTO.getId());
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setOuName(orgOuRpcDTO.getOuName());
            }
            if (UdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(importEntity.getType())) {
                InvWhRpcDTO invWhRpcDTO = (InvWhRpcDTO)whMap.get(importEntity.getStoreWhCode());
                if (invWhRpcDTO == null) {
                    ((List)errorMap.get(importEntity.getLine())).add("\u4ed3\u5e93 " + importEntity.getStoreWhCode() + " \u4e0d\u5b58\u5728");
                } else {
                    ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStoreWhId(invWhRpcDTO.getId());
                    ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStoreWhName(invWhRpcDTO.getWhName());
                    ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStoreWhCode(importEntity.getStoreWhCode());
                }
                if (!invWhRpcDTO.getOuId().equals(orgOuRpcDTO.getId())) {
                    pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(orgOuRpcDTO.getId());
                    pathRpcParam.setCompanyIdEnd(invWhRpcDTO.getOuId());
                    data = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
                    if (data == null || StrUtil.isBlank((CharSequence)data.getPathCode())) {
                        log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)orgOuRpcDTO.getId(), (Object)invWhRpcDTO.getOuId());
                        ((List)errorMap.get(importEntity.getLine())).add("\u4ece\u516c\u53f8:" + orgOuRpcDTO.getOuCode() + "\u5230\u516c\u53f8:" + invWhRpcDTO.getOuCode() + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                    } else {
                        detailList = data.getDetailList();
                        size = detailList.size();
                        dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                        ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSaleOuCode(dto.getCompanyCodeStart());
                        ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSaleOuName(dto.getCompanyNameStart());
                        ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSaleCustCode(dto.getCustCodeEnd());
                    }
                }
            } else {
                OrgStoreDetailRpcDTO orgStoreWhDTO = (OrgStoreDetailRpcDTO)storeMap.get(importEntity.getStoreWhCode());
                if (orgStoreWhDTO == null) {
                    ((List)errorMap.get(importEntity.getLine())).add("\u95e8\u5e97 " + importEntity.getStoreWhCode() + " \u4e0d\u5b58\u5728");
                } else {
                    ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStoreWhId(orgStoreWhDTO.getId());
                    ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStoreWhName(orgStoreWhDTO.getStoreName());
                    ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStoreWhCode(importEntity.getStoreWhCode());
                }
                if (!orgStoreWhDTO.getOuId().equals(orgOuRpcDTO.getId())) {
                    pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(orgOuRpcDTO.getId());
                    pathRpcParam.setCompanyIdEnd(orgStoreWhDTO.getOuId());
                    data = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
                    if (data == null || StrUtil.isBlank((CharSequence)data.getPathCode())) {
                        log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)orgOuRpcDTO.getId(), (Object)orgStoreWhDTO.getOuId());
                        ((List)errorMap.get(importEntity.getLine())).add("\u4ece\u516c\u53f8:" + orgOuRpcDTO.getOuCode() + "\u5230\u516c\u53f8:" + orgStoreWhDTO.getOuCode() + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                    } else {
                        detailList = data.getDetailList();
                        size = detailList.size();
                        dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                        ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSaleOuCode(dto.getCompanyCodeStart());
                        ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSaleOuName(dto.getCompanyNameStart());
                        ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSaleCustCode(dto.getCustCodeEnd());
                    }
                }
            }
            PurSuppBaseRpcDTO suppBaseRpcDTO = suppMap.get(importEntity.getSuppCode());
            if (suppBaseRpcDTO == null) {
                ((List)errorMap.get(importEntity.getLine())).add("\u4f9b\u5e94\u5546\u7f16\u7801" + importEntity.getSuppCode() + " \u4e0d\u5b58\u5728");
            } else {
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSuppId(suppBaseRpcDTO.getId());
                ((ScpSupplyAllocationDTO)((Object)allocationDO)).setSuppName(suppBaseRpcDTO.getSuppName());
            }
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setType(importEntity.getType());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setTypeName(importEntity.getTypeName());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setAllocation(importEntity.getAllocation());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setMinimumOrderQuantity(importEntity.getMinimumOrderQuantity());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setPurchaseLeadTime(importEntity.getPurchaseLeadTime());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStartTime(importEntity.getStartTime());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setEndTime(importEntity.getEndTime());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setEs1(importEntity.getImportBillNum());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setLineNo(importEntity.getLine());
            ((ScpSupplyAllocationDTO)((Object)allocationDO)).setStatus(Boolean.TRUE);
            allocationDOS.add(allocationDO);
        }
        Map<String, List<ScpSupplyAllocationImportVO>> storeListMap = dataList.stream().filter(d -> UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(d.getType())).collect(Collectors.groupingBy(a -> a.getStoreWhCode() + "-" + a.getItemCode()));
        storeListMap.forEach((k, v) -> {
            if (v.size() > 1) {
                v.forEach(a -> ((List)errorMap.get(a.getLine())).add("\u95e8\u5e97\u7c7b\u578b\u7684\u95e8\u5e97\u7f16\u7801" + a.getStoreWhCode() + "\u7269\u6599\u7f16\u7801" + a.getItemCode() + "\u5df2\u5b58\u5728"));
            }
        });
        Set<String> existsList = dataList.stream().map(d -> d.getStoreWhCode() + d.getItemCode()).collect(Collectors.toSet());
        List<ScpSupplyAllocationDO> existList = this.scpSupplyAllocationDomainService.findByConcatKeys(existsList);
        dataList.forEach(d -> {
            if (!UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(d.getType())) {
                return;
            }
            if (existList.stream().anyMatch(e -> UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(e.getType()) && e.getStoreWhCode().equals(d.getStoreWhCode()) && e.getItemCode().equals(d.getItemCode()))) {
                this.deleteWhNetRelation(existList.stream().map(e -> e.getId()).collect(Collectors.toList()));
            }
        });
        for (String key : supplyAllocationMap.keySet()) {
            List supplyAllocationDOS = (List)supplyAllocationMap.get(key);
            long count = supplyAllocationDOS.stream().map(d -> d.getStoreWhCode() + d.getType() + d.getItemCode()).distinct().count();
            if (UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(((ScpSupplyAllocationDTO)supplyAllocationDOS.get(0)).getType())) {
                ((ScpSupplyAllocationDTO)supplyAllocationDOS.get(0)).setAllocation(BigDecimal.valueOf(100L));
            }
            data = supplyAllocationDOS.iterator();
            while (data.hasNext()) {
                ScpSupplyAllocationDTO d2 = (ScpSupplyAllocationDTO)data.next();
                if (count == 1L) continue;
                ((List)errorMap.get(d2.getLineNo())).add("\u540c\u4e00\u5e8f\u53f7\u7ec4 " + d2.getEs1() + "\u3010\u95e8\u5e97/\u4ed3\u5e93\u7f16\u7801-\u5546\u54c1\u7f16\u7801\u3011\u5fc5\u987b\u76f8\u540c\uff01");
            }
        }
        for (Integer line : errorMap.keySet()) {
            if (((List)errorMap.get(line)).isEmpty()) continue;
            if (Objects.equals(errorList.get(line - 1), "-")) {
                errorList.set(line - 1, String.join((CharSequence)",", (Iterable)errorMap.get(line)));
                continue;
            }
            errorList.set(line - 1, (String)errorList.get(line - 1) + String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
        successDocGroup = this.getSuccessDocGroup(errorList, dataList);
        ArrayList<ScpSupplyAllocationDTO> ddos = new ArrayList<ScpSupplyAllocationDTO>();
        if (!successDocGroup.isEmpty()) {
            List<String> finalSuccessDocGroup = successDocGroup;
            for (String key : supplyAllocationMap.keySet()) {
                List supplyAllocationDOS = (List)supplyAllocationMap.get(key);
                List doList = supplyAllocationDOS.stream().filter(i -> finalSuccessDocGroup.contains(i.getEs1())).collect(Collectors.toList());
                if (doList.isEmpty()) continue;
                ddos.addAll(doList);
            }
        }
        ArrayList<String> newResult = new ArrayList<String>();
        ArrayList<String> errorNewList = new ArrayList<String>();
        for (int i2 = 0; i2 < errorList.size(); ++i2) {
            String error = (String)errorList.get(i2);
            String importDocGroup = dataList.get(i2).getImportBillNum();
            if (!successDocGroup.contains(importDocGroup)) {
                if (Objects.equals(error, "-")) {
                    newResult.add("-");
                    continue;
                }
                newResult.add(error);
                errorNewList.add(error);
                continue;
            }
            newResult.add(null);
        }
        if (CollUtil.isEmpty(errorNewList)) {
            this.scpSupplyAllocationDomainService.createBatch(ddos);
        }
        return newResult;
    }

    private void checkImportData(List<ScpSupplyAllocationImportVO> dataList, int startRowIndex) {
        List suppCodeList = dataList.stream().map(e -> e.getSuppCode()).collect(Collectors.toList());
        List<String> storeWhCodeList = dataList.stream().map(e -> e.getStoreWhCode()).collect(Collectors.toList());
        List itemCodeList = dataList.stream().map(e -> e.getItemCode()).collect(Collectors.toList());
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(suppCodeList);
        List suppList = (List)this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam).getData();
        List<OrgStoreDetailRpcDTO> orgStoreDTOS = this.rmiOrgStoreRpcService.queryByStoreCodes(storeWhCodeList);
        List<ItmItemBaseRpcDTO> itmItemBaseDTOS = this.rmiItemService.findItemBaseRpcDtoByParam(ItmItemBaseRpcParam.builder().itemCodes(itemCodeList).build());
        Map<String, String> whMap = suppList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, PurSuppBaseRpcDTO::getSuppName));
        Map<String, String> storeMap = orgStoreDTOS.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, OrgStoreDetailRpcDTO::getStoreName));
        Map<String, String> itemMap = itmItemBaseDTOS.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode, ItmItemBaseRpcDTO::getItemName));
        for (int i = 0; i < dataList.size(); ++i) {
            ScpSupplyAllocationImportVO vo = dataList.get(i);
            int rowNum = startRowIndex + i;
            if (vo.getSuppCode() != null) {
                if (vo.getSuppName() == null) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u4f9b\u5e94\u5546\u7f16\u7801 " + vo.getSuppCode() + " \u5bf9\u5e94\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!whMap.containsKey(vo.getSuppCode())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u4f9b\u5e94\u5546\u7f16\u7801 " + vo.getSuppName() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!whMap.get(vo.getSuppCode()).equals(vo.getSuppName())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u4f9b\u5e94\u5546\u7f16\u7801 " + vo.getSuppCode() + " \u4e0e\u4f9b\u5e94\u5546\u540d\u79f0 " + vo.getSuppName() + "\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            } else {
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u4f9b\u5e94\u5546\u7f16\u7801 " + vo.getStoreWhCode() + " \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (vo.getStoreWhCode() != null) {
                if (vo.getStoreWhName() == null) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801 " + vo.getStoreWhCode() + " \u5bf9\u5e94\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!storeMap.containsKey(vo.getStoreWhCode())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801 " + vo.getStoreWhCode() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!storeMap.get(vo.getStoreWhCode()).equals(vo.getStoreWhName())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801 " + vo.getStoreWhCode() + " \u4e0e\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u540d\u79f0 " + vo.getStoreWhName() + " \u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            } else {
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801 " + vo.getStoreWhCode() + " \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (vo.getItemCode() != null) {
                if (vo.getItemName() == null) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u7269\u6599\u7f16\u7801 " + vo.getItemCode() + " \u5bf9\u5e94\u7269\u6599\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!itemMap.containsKey(vo.getItemCode())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u7269\u6599\u7f16\u7801 " + vo.getItemCode() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (itemMap.get(vo.getItemCode()).equals(vo.getItemName())) continue;
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u7269\u6599\u7f16\u7801 " + vo.getItemCode() + " \u4e0e\u7269\u6599\u540d\u79f0 " + vo.getItemName() + " \u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u7269\u6599\u7f16\u7801 " + vo.getStoreWhCode() + " \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    @Override
    public PagingVO<ScpSupplyAllocationPageVO> scpmanAuthorityPage(ScpSupplyAllocationPageParamVO queryParam) {
        PagingVO<ScpManAuthorityPageRespVO> userAuthority = this.scpDemandAuthorityService.getCurrentUserAuthority();
        if (userAuthority.isEmpty()) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        this.extractedAuthorityParam(queryParam, userAuthority);
        return this.page(queryParam);
    }

    @Override
    public Map<String, List<ScpSupplyAllocationRpcDTO>> findSupplyAllocationByParam(String demandWhStCode, String type, List<String> itemCodes) {
        ScpSupplyAllocationRpcDtoParam param = new ScpSupplyAllocationRpcDtoParam();
        param.setType(type);
        param.setStoreWhCode(demandWhStCode);
        param.setItemCodes(itemCodes);
        List<ScpSupplyAllocationRpcDTO> supplyAllocationList = this.scpSupplyAllocationRepoProc.findSupplyAllocationRpcByParam(param);
        if (CollUtil.isNotEmpty(supplyAllocationList)) {
            return supplyAllocationList.stream().collect(Collectors.groupingBy(ScpSupplyAllocationRpcDTO::getItemCode));
        }
        return new HashMap<String, List<ScpSupplyAllocationRpcDTO>>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<Long> ids) {
        List<ScpSupplyAllocationDO> allocationDOS = this.scpSupplyAllocationDomainService.findByIds(ids);
        Map<String, List<ScpSupplyAllocationDO>> suppMap = allocationDOS.stream().filter(row -> Boolean.TRUE.equals(row.getStatus())).collect(Collectors.groupingBy(row -> row.getStoreWhCode() + row.getItemCode() + row.getSuppCode()));
        for (String key : suppMap.keySet()) {
            List<ScpSupplyAllocationDO> suppList = suppMap.get(key);
            ScpSupplyAllocationDO scpSupplyAllocationDO = suppList.get(0);
            BigDecimal sumAlloc = suppList.stream().map(ScpSupplyAllocationDO::getAllocation).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sumAlloc.compareTo(new BigDecimal("100")) == 0) continue;
            throw new BusinessException("\u95e8\u5e97/\u4ed3\u5e93\u3010" + scpSupplyAllocationDO.getStoreWhName() + "\u3011,\u5546\u54c1\u3010  " + scpSupplyAllocationDO.getItemName() + "\u3011\u914d\u7f6e\u6bd4\u989d\u4e0d\u7b26\u5408\u767e\u5206\u4e4b\u767e");
        }
        List<Long> delIds = allocationDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.scpSupplyAllocationDomainService.deleteBatch(delIds);
    }

    private void extractedAuthorityParam(BaseScpmanAuthorityParam queryParam, PagingVO<ScpManAuthorityPageRespVO> userAuthority) {
        List<String> whCodes = userAuthority.stream().filter(v -> 1 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> stores = userAuthority.stream().filter(v -> 0 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhCodes(whCodes);
        queryParam.setStores(stores);
        queryParam.setScpmanAuthority(Boolean.TRUE);
    }

    private List<String> validResult(List<String> errorList) {
        errorList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String s) {
                if (StringUtils.isEmpty((String)s)) {
                    return "-";
                }
                return s;
            }
        });
        return errorList;
    }

    private List<String> getSuccessDocGroup(List<String> errorList, List<ScpSupplyAllocationImportVO> dataList) {
        List<String> docGroupNo = dataList.stream().filter(i -> org.springframework.util.StringUtils.hasText((String)i.getImportBillNum())).map(ScpSupplyAllocationImportVO::getImportBillNum).distinct().collect(Collectors.toList());
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            ScpSupplyAllocationImportVO entity = dataList.get(i2);
            if (Objects.equals("-", errorList.get(i2))) continue;
            docGroupNo.remove(entity.getImportBillNum());
        }
        return docGroupNo;
    }

    private void checkImportParam(List<ScpSupplyAllocationImportVO> dataList, List<String> errorList) {
        HashMap errorMap = new HashMap();
        Map typeMap = MapUtil.reverse((Map)this.systemService.getValueMapByUdcCode("yst-suplan", "DEMAND_SET_TYPE"));
        Map uomMap = MapUtil.reverse((Map)this.systemService.getValueMapByUdcCode("yst-supp", "UOM"));
        for (int i = 0; i < dataList.size(); ++i) {
            ScpSupplyAllocationImportVO importEntity = dataList.get(i);
            int line = i + 1;
            importEntity.setLine(line);
            errorMap.put(importEntity.getLine(), new ArrayList());
            if (importEntity.getImportBillNum() == null) {
                ((List)errorMap.get(line)).add("\u5217[\u5e8f\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)importEntity.getItemCode())) {
                ((List)errorMap.get(line)).add("\u5217[\u5546\u54c1\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)importEntity.getStoreWhCode())) {
                ((List)errorMap.get(line)).add("\u5217[\u4ed3\u5e93\u7f16\u7801/\u95e8\u5e97\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)importEntity.getTypeName())) {
                ((List)errorMap.get(line)).add("\u5217[\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                String lineType = (String)typeMap.get(importEntity.getTypeName());
                if (StringUtils.isEmpty((String)lineType)) {
                    ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u7c7b\u578b\u540d]" + importEntity.getTypeName() + " \u4e0d\u5b58\u5728");
                } else {
                    importEntity.setType(lineType);
                }
            }
            if (StringUtils.isEmpty((String)importEntity.getSuppCode())) {
                ((List)errorMap.get(line)).add("\u5217[\u4f9b\u5e94\u5546\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (importEntity.getAllocation() != null) continue;
            ((List)errorMap.get(line)).add("\u5217[\u914d\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Integer line : errorMap.keySet()) {
            errorList.add(String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
    }

    private List<ScpSupplyAllocationResultVO.ResultVO> getResultVOS(List<ScpSupplyAllocatioSaveVO.ScpSupplyAllocatio> supplyAllocatios) {
        return supplyAllocatios.stream().map(w -> {
            ScpSupplyAllocationResultVO.ResultVO resultVO = new ScpSupplyAllocationResultVO.ResultVO();
            resultVO.setSuppId(w.getId());
            resultVO.setSuppCode(w.getSuppCode());
            resultVO.setSuppName(w.getSuppName());
            resultVO.setType(w.getType());
            resultVO.setStoreWhId(w.getStoreWhId());
            resultVO.setStoreWhCode(w.getStoreWhCode());
            resultVO.setType(w.getType());
            resultVO.setItemCode(w.getItemCode());
            resultVO.setItemId(w.getItemId());
            resultVO.setItemName(w.getItemName());
            resultVO.setItemCateCode(w.getItemCateCode());
            resultVO.setItemCateName(w.getItemCateName());
            resultVO.setAllocation(w.getAllocation());
            resultVO.setMinimumOrderQuantity(w.getMinimumOrderQuantity());
            resultVO.setPurchaseLeadTime(w.getPurchaseLeadTime());
            resultVO.setLineNo(w.getLineNo());
            return resultVO;
        }).collect(Collectors.toList());
    }

    public ScpSupplyAllocationServiceImpl(ScpSupplyAllocationDomainService scpSupplyAllocationDomainService, UdcProvider udcProvider, ItmItemRpcService itmItemRpcService, ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc, PurSuppProvider purSuppProvider, ItmItemRpcService itemRpcService, InvWhProvider whProvider, OrgStoreRpcService orgStoreRpcService, UdcProvider systemService, ScpDemandAuthorityService scpDemandAuthorityService, RmiOrgOuService rmiOrgOuService, RmiInvStkRpcService rmiInvStkService, RmiOrgStoreRpcService rmiOrgStoreRpcService, SupportTransactionPathRpcService supportTransactionPathRpcService, RmiItemService rmiItemService) {
        this.scpSupplyAllocationDomainService = scpSupplyAllocationDomainService;
        this.udcProvider = udcProvider;
        this.itmItemRpcService = itmItemRpcService;
        this.scpSupplyAllocationRepoProc = scpSupplyAllocationRepoProc;
        this.purSuppProvider = purSuppProvider;
        this.itemRpcService = itemRpcService;
        this.whProvider = whProvider;
        this.orgStoreRpcService = orgStoreRpcService;
        this.systemService = systemService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiInvStkService = rmiInvStkService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.supportTransactionPathRpcService = supportTransactionPathRpcService;
        this.rmiItemService = rmiItemService;
    }
}

