/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.strategy;

import com.elitesland.scp.application.enums.AllocRuleType;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderComputeVO;
import com.elitesland.scp.application.service.strategy.EventStrategy;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PriorityEventService
implements EventStrategy {
    private static final Logger log = LoggerFactory.getLogger(PriorityEventService.class);

    @Override
    public void handleInvStk(List<ScpDemandOrderComputeVO> stores, BigDecimal warehouse) {
        BigDecimal sumDemandQty = stores.stream().map(row -> row.getAllocationDeQuantity()).reduce(BigDecimal::add).get();
        if (warehouse.compareTo(sumDemandQty) >= 0) {
            stores.forEach(store -> store.setPlanQuantity(store.getAllocationDeQuantity()));
            return;
        }
        long remindCount = stores.stream().filter(store -> store.getAllocationDeQuantity().compareTo(store.getPlanQuantity()) > 0).count();
        while (warehouse.compareTo(BigDecimal.ZERO) > 0 && remindCount > 0L) {
            BigDecimal allocation = warehouse.divide(BigDecimal.valueOf(remindCount), 0, RoundingMode.DOWN);
            log.info("\u8fd9\u4e00\u8f6e\u6bcf\u4e2a\u95e8\u5e97\u8981\u5206\u914d\u7684\u5e73\u5747\u6570\u91cf\uff1a{}", (Object)allocation);
            if (allocation.compareTo(BigDecimal.ONE) <= 0) {
                ScpDemandOrderComputeVO remindStore = stores.stream().filter(store -> store.getAllocationDeQuantity().compareTo(store.getPlanQuantity()) > 0).findFirst().orElse(null);
                if (remindStore != null) {
                    remindStore.setPlanQuantity(remindStore.getPlanQuantity().add(warehouse));
                }
                return;
            }
            boolean allocationChanged = false;
            for (ScpDemandOrderComputeVO store2 : stores) {
                BigDecimal actualAllocation;
                if (store2.getPlanQuantity().compareTo(store2.getAllocationDeQuantity()) >= 0 || warehouse.compareTo(BigDecimal.ZERO) <= 0 || (actualAllocation = allocation.min(store2.getAllocationDeQuantity().subtract(store2.getPlanQuantity()))).compareTo(BigDecimal.ZERO) <= 0) continue;
                allocationChanged = true;
                store2.setPlanQuantity(store2.getPlanQuantity().add(actualAllocation));
                warehouse = warehouse.subtract(actualAllocation);
                if (store2.getAllocationDeQuantity().compareTo(store2.getPlanQuantity()) != 0) continue;
                --remindCount;
            }
            if (allocationChanged) continue;
            break;
        }
    }

    @Override
    public String getAllocRuleType() {
        return AllocRuleType.PRIORITY.getCode();
    }
}

