/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.provider.mrp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDO;
import com.elitesland.scp.domain.service.mrp.ScpMrpDPlanDomainService;
import com.elitesland.scp.domain.service.mrp.ScpMrpDomainService;
import com.elitesland.scp.dto.mrp.ScpMrpDPlanCancelDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.service.mrp.ScpMrpRpcService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/mrp"})
public class ScpMrpRpcServiceImpl
implements ScpMrpRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpMrpRpcServiceImpl.class);
    private final ScpMrpDomainService scpMrpDomainService;
    private final ScpMrpDPlanDomainService scpMrpDPlanDomainService;

    public ApiResult<Long> cancelPlan(ScpMrpDPlanCancelDTO cancelDTO) {
        log.info("\u3010cancelMrpDPlan\u3011\u53d6\u6d88MRP\u91c7\u8d2d\u8ba1\u5212\uff1a{}", (Object)JSONUtil.toJsonStr((Object)cancelDTO));
        ScpMrpDO scpMrpDO = this.scpMrpDomainService.findById(cancelDTO.getMrpId());
        if (scpMrpDO == null) {
            throw new BusinessException("MRP\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        if (CollectionUtil.isEmpty((Collection)cancelDTO.getPodIds())) {
            throw new BusinessException("\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ScpMrpDPlanRespVO> scpMrpDPlanRespVOList = this.scpMrpDPlanDomainService.findByMrpId(cancelDTO.getMrpId());
        List<Long> cancelPlanIds = scpMrpDPlanRespVOList.stream().filter(plan -> plan.getPoDId() != null && cancelDTO.getPodIds().contains(plan.getPoDId())).map(BaseViewModel::getId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(cancelPlanIds)) {
            throw new BusinessException("MRP\u91c7\u8d2d\u8ba1\u5212\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        String mrpPushStatus = scpMrpDPlanRespVOList.stream().anyMatch(plan -> plan.getPoDId() == null || !cancelDTO.getPodIds().contains(plan.getId())) ? ScpUdcEnum.MRP_PUSH_STATUS_PART.getValueCode() : ScpUdcEnum.MRP_PUSH_STATUS_NOT.getValueCode();
        this.scpMrpDPlanDomainService.updatePushStatus(cancelPlanIds, ScpUdcEnum.MRP_D_PUSH_STATUS_NOT.getValueCode(), null, null, null, null);
        this.scpMrpDomainService.updatePushStatus(cancelDTO.getMrpId(), mrpPushStatus, null);
        return ApiResult.ok();
    }

    public ScpMrpRpcServiceImpl(ScpMrpDomainService scpMrpDomainService, ScpMrpDPlanDomainService scpMrpDPlanDomainService) {
        this.scpMrpDomainService = scpMrpDomainService;
        this.scpMrpDPlanDomainService = scpMrpDPlanDomainService;
    }
}

