package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.common.provider.DefaultUdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

@Data
@ApiModel("订货集模版分页返回")
public class ScpOrderTemplatePageRespVO extends BaseViewModel implements Serializable {
    @ApiModelProperty("模板类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;

    @ApiModelProperty("模板类型")
    private String typeName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    @ApiModelProperty("单据类型名")
    private String docTypeName;

    @ApiModelProperty("应用门店代码")
    private String storeCode;

    @ApiModelProperty("应用门店名称")
    private String storeName;

    @ApiModelProperty("所属区域")
    private String regionCode;

    @ApiModelProperty("所属区域名称")
    private String regionName;

    @ApiModelProperty("订单截至时间点")
    private LocalTime deadlineTime;

    private String deadlineTimeStr;

    @ApiModelProperty("开始日期")
    private LocalDate startDate;

    private String startDateStr;

    @ApiModelProperty("结束日期")
    private LocalDate endDate;

    private String endDateStr;

    @ApiModelProperty("是否启用")
    private Integer isActive;

    private String isActiveName;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    public ScpOrderTemplatePageRespVO update(UdcProvider udcProvider){
        this.docTypeName = udcProvider.getByUdcCode("OB_DOC_TYPE", this.getDocType()).getUdcName();
        this.typeName = udcProvider.getByUdcCode("DEMAND_SET_TYPE", this.getDocType()).getUdcName();
        return this;
    }
}
