package com.elitesland.scp.application.facade.vo.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:34
 * @Description:
 */
@Data
@ApiModel(description = "模板列表结果")
public class DemandOrderListRespVO implements Serializable {

    @ApiModelProperty("订货模板id")
    private Long id;

    @ApiModelProperty("订货模板编号")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称")
    private String demandTemName;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("起始日期")
    private Date startDate;

    @ApiModelProperty("截止日期")
    private Date endDate;

    @ApiModelProperty("详细日期")
    private String detailedTime;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer demandTemStatus;

    @ApiModelProperty("商品种数")
    private BigDecimal typeNumber;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

}
