package com.elitesland.scp.application.facade.vo.scpsman;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 19:33
 * @Description:
 */
@Data
@ApiModel("计划员详情查询返回参数")
public class SalesmanInfoDetailRespVO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("计划员编号")
    private String scpsmanNo;

    @ApiModelProperty("计划员类型")
    private String scpsmanType;

    @ApiModelProperty("计划员类型名称")
    private String scpsmanTypeName;

    @ApiModelProperty("管辖区域")
    private List<SalesmanRegionVO> jurisdiction;

    // @ApiModelProperty("管辖区域名称")
    // private String jurisdictionName;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司id")
    private String ouId;

    @ApiModelProperty("公司所属组织id")
    private String orgIdBelong;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("启用状态名称")
    private String enableStatusName;

    @ApiModelProperty("员工详情信息")
    private EmployeeDetailInfoRespVO employeeDetailInfoRespVO;

    @ApiModelProperty("ADD:新增计划员，EMP：绑定现有员工")
    private String source;

}
