package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.template.TemplateApplyCartContext;
import com.elitesland.scp.domain.convert.StoreInfoConvert;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class StoreAuthorityServiceImpl implements StoreAuthorityService {

    private final RmiItemService rmiItemService;
    private final CommonPriceService commonPriceService;
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    @SysCodeProc
    public StoreAuthorityRespDTO getStoreAuthorityDataBOH(StoreAuthorityRpcDTO storeAuthorityRpcDTO, TemplateApplyCartContext context,
                                                          List<String> itemCodeList, String type) {
        String storeCode = storeAuthorityRpcDTO.getStoreCode();
        if (StrUtil.isBlank(storeCode)) {
            throw new BusinessException("参数门店编码不能为空");
        }
        OrgStoreBaseRpcDTO storeDto = rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("门店信息:{}", JSONUtil.toJsonStr(storeDto));
        if (storeDto == null) {
            return null;
        }
        context.setStoreDto(storeDto);

        StoreAuthorityRespDTO storeAuthorityRespDTO = StoreInfoConvert.INSTANCE.toStoreAuthorityRespDTO(storeDto);
        String ouCode = storeAuthorityRespDTO.getOuCode();
        String brandCode = storeAuthorityRespDTO.getBrandCode();
        List<ItmItemBusinessRpcDTO> itmItemBusinessRpcDTOS =
                rmiItemService.findItmItemBusinessByBUCodeAndBrandAndItemList(ouCode, brandCode, itemCodeList);
        log.info("调用基础域查询商品结果:{}", JSONUtil.toJsonStr(itmItemBusinessRpcDTOS));
        context.setItmItemBusinessRpcDTOS(itmItemBusinessRpcDTOS);
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(storeAuthorityRpcDTO.getDocType(), type);
        List<AppItemActivityItemPriceParamVO> priceParamVOS = itmItemBusinessRpcDTOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom2());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(priceParamVOS, storeDto.getStoreCode(), orderSetting, type);
        log.info("商品价格字段数据:{}", JSONUtil.toJsonStr(priceMap));
        context.setPriceMap(priceMap);

        List<StoreAuthorityRespDTO.ItemInfo> itemInfoList = new ArrayList<>();
        for (ItmItemBusinessRpcDTO dto : itmItemBusinessRpcDTOS) {
            StoreAuthorityRespDTO.ItemInfo itemInfo = new StoreAuthorityRespDTO.ItemInfo();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom2());
            itemInfo.setUomName(dto.getUom2Name());
            itemInfo.setTaxRate(dto.getTaxRate2());
            List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(itemInfo.getItemCode());
            if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                itemInfo.setPrice(priceRpcDTOS.get(0).getPrice());
            }
            itemInfoList.add(itemInfo);
        }
        storeAuthorityRespDTO.setItemInfos(itemInfoList);
        log.info("门店要货权限数据:{}", JSONUtil.toJsonStr(storeAuthorityRespDTO));
        return storeAuthorityRespDTO;
    }


}
