/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemSpecParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemActivityRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemSpecRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmSkuRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmSpuRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppItemActivityService;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.convert.app.ScpStoreItemConvert;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppItemActivityrServiceImpl
implements AppItemActivityService {
    private static final Logger log = LoggerFactory.getLogger(AppItemActivityrServiceImpl.class);
    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpCacheService scpCacheService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;

    @Override
    @SysCodeProc
    public PagingVO<AppItemActivityRespVO> query(AppItemActivityParamVO paramVO) throws ExecutionException, InterruptedException {
        return new PagingVO();
    }

    @Override
    public PagingVO<AppItmItemPageVO> itemPage(AppItemPageParamVO paramVO) {
        Long count;
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            List<String> itemTypes = this.scpOrderSettingDomainService.findItemCatesByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setItemTypes(itemTypes);
        }
        if ((count = this.scpCateItemRepoProc.countAppItemSpu(paramVO)) == 0L) {
            return new PagingVO();
        }
        List<AppItmItemPageVO> itemList = this.scpCateItemRepoProc.pageAppItemSpu(paramVO);
        this.itemMessageImageAndDetailsQuery(itemList, paramVO.getStoreCode(), paramVO.getDocType(), paramVO.getOuCode());
        this.getPriceAndStock(paramVO.getDocType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        return new PagingVO(count.longValue(), itemList);
    }

    @Override
    public PagingVO<AppItmItemPageVO> commonItemPage(CommonItemPageParamVO paramVO) {
        if (StrUtil.isBlank((CharSequence)paramVO.getBrand())) {
            return new PagingVO();
        }
        Long count = this.scpCateItemRepoProc.countCommonItemSpu(paramVO);
        if (count == 0L) {
            return new PagingVO();
        }
        List<AppItmItemPageVO> itemList = this.scpCateItemRepoProc.pageCommonItemSpu(paramVO);
        this.itemMessageImageAndDetailsQuery(itemList, null, null, paramVO.getOuCode());
        return new PagingVO(count.longValue(), itemList);
    }

    public void getPriceAndStock(String docType, List<AppItmItemPageVO> itemList, String storeCode, String type) {
        CopyOnWriteArrayList appItemActivityItemPriceParamVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        itemList.forEach(row -> {
            List inList = row.getDetails().stream().map(t -> {
                AppItemActivityItemPriceParamVO appItemActivityItemPriceParamVO = new AppItemActivityItemPriceParamVO();
                appItemActivityItemPriceParamVO.setStoreCode(storeCode);
                appItemActivityItemPriceParamVO.setItemCode(t.getItemCode());
                appItemActivityItemPriceParamVO.setItemCateCode(t.getItemCateCode());
                appItemActivityItemPriceParamVO.setUom(t.getUom());
                appItemActivityItemPriceParamVO.setItemId(t.getItemId());
                appItemActivityItemPriceParamVO.setCombineItemCode(t.getCombineItemCode());
                appItemActivityItemPriceParamVO.setCombineItemFlag(t.getCombineItemFlag());
                return appItemActivityItemPriceParamVO;
            }).collect(Collectors.toList());
            appItemActivityItemPriceParamVOS.addAll(inList);
        });
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByDocType(docType, type);
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartDOS = this.cartRedisUtil.getStoreCartItems(storeCode, docType, currentUserId);
        ArrayList filterItemCodes = new ArrayList();
        Map<String, List<PriPriceRpcDTO>> priceMap = this.commonPriceService.getPriceAndStockDetails(appItemActivityItemPriceParamVOS, storeCode, orderSetting, type, stockMapRef);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        itemList.forEach(item -> {
            String itemKey;
            List priceDList;
            BigDecimal mainStkQty = BigDecimal.ZERO;
            List<AppItmItemPageVO> details = item.getDetails();
            for (int i = 0; i < details.size(); ++i) {
                BigDecimal qty;
                AppItmItemPageVO detail = details.get(i);
                if (detail == null) continue;
                String itemKey2 = SysUtils.getItemKey(detail.getCombineItemCode(), detail.getItemCode());
                List priceDList2 = (List)priceMap.get(itemKey2);
                if (CollUtil.isNotEmpty((Collection)priceDList2)) {
                    detail.setPrice(((PriPriceRpcDTO)priceDList2.get(0)).getPrice());
                }
                BigDecimal avalQty = stockMap.getOrDefault(detail.getItemCode(), BigDecimal.ZERO);
                detail.setAvalQty(avalQty);
                if (!Boolean.TRUE.equals(detail.getCombineItemFlag()) || (qty = detail.getCombineQty()) == null || qty.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal divide = detail.getAvalQty().divide(qty, 0, RoundingMode.FLOOR);
                if (i == 0) {
                    mainStkQty = divide;
                    continue;
                }
                if (divide.compareTo(mainStkQty) >= 0) continue;
                mainStkQty = divide;
            }
            if (item.getCombineItemFlag() != null && item.getCombineItemFlag().booleanValue()) {
                List priPriceRpcDTOS = (List)priceMap.get(SysUtils.getItemKey(item.getSpuCode(), item.getSpuCode()));
                if (CollUtil.isNotEmpty((Collection)priPriceRpcDTOS)) {
                    item.setCombineItemPrice(((PriPriceRpcDTO)priPriceRpcDTOS.get(0)).getPrice());
                    item.setPrice(((PriPriceRpcDTO)priPriceRpcDTOS.get(0)).getPrice());
                }
                item.setAvalQty(mainStkQty);
            } else {
                BigDecimal avalQty = stockMap.getOrDefault(item.getItemCode(), BigDecimal.ZERO);
                item.setAvalQty(avalQty);
            }
            if (item.getAvalQty() != null && item.getAvalQty().compareTo(BigDecimal.ZERO) <= 0) {
                filterItemCodes.add(item.getItemCode());
            }
            if (CollUtil.isNotEmpty((Collection)(priceDList = (List)priceMap.get(itemKey = SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()))))) {
                item.setPrice(((PriPriceRpcDTO)priceDList.get(0)).getPrice());
            }
            if (CollUtil.isNotEmpty((Collection)cartDOS)) {
                cartDOS.stream().filter(row -> StringUtils.equals((CharSequence)row.getItemCode(), (CharSequence)item.getItemCode()) && StringUtils.isEmpty((CharSequence)row.getCombineItemCode())).findFirst().ifPresentOrElse(cart -> item.setQty(cart.getQty()), () -> item.setQty(BigDecimal.ZERO));
            } else {
                item.setQty(BigDecimal.ZERO);
            }
        });
        List collect = itemList.stream().filter(item -> filterItemCodes.contains(item.getItemCode())).collect(Collectors.toList());
        itemList.removeAll(collect);
        if (CollUtil.isNotEmpty(itemList)) {
            log.debug("\u5f3a\u914d\u5546\u54c1");
            this.getAllocSettingItemList(storeCode, orderSetting, itemList);
        }
    }

    private void getAllocSettingItemList(String storeCode, ScpOrderSettingRespVO orderSetting, List<AppItmItemPageVO> itemList) {
        List itemTypes = StrUtil.split((CharSequence)orderSetting.getItemCate(), (CharSequence)",");
        List<ScpAllocSettingItemRespVO> allocSettingItemList = this.scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(storeCode, orderSetting.getDocType(), itemTypes);
        if (CollUtil.isEmpty(allocSettingItemList)) {
            return;
        }
        Set detailItemIds = itemList.stream().filter(item -> item.getDetails() != null).flatMap(item -> item.getDetails().stream()).map(AppItmItemPageVO::getItemId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map allocSettingItemMap = allocSettingItemList.stream().filter(item -> detailItemIds.contains(item.getItemId())).collect(Collectors.toMap(ScpAllocSettingItemRespVO::getItemId, Function.identity()));
        itemList.forEach(item -> {
            if (item.getDetails() != null) {
                item.getDetails().forEach(detail -> {
                    ScpAllocSettingItemRespVO allocItem = (ScpAllocSettingItemRespVO)allocSettingItemMap.get(detail.getItemId());
                    if (allocItem != null) {
                        detail.setActivityItemFlag(Boolean.TRUE);
                        detail.setActivityCode(allocItem.getActivityCode());
                        detail.setActivityId(allocItem.getMasId());
                        detail.setMinNum(allocItem.getMinNum());
                    }
                });
            }
        });
    }

    private static List<AppItmItemPageVO> mergeObjectsAndDetails(List<AppItmItemPageVO> outerList) {
        ArrayList<AppItmItemPageVO> mergedList = new ArrayList<AppItmItemPageVO>();
        for (AppItmItemPageVO outerObject : outerList) {
            mergedList.add(outerObject);
            List<AppItmItemPageVO> detailList = outerObject.getDetails();
            if (detailList == null) continue;
            for (AppItmItemPageVO detailObject : detailList) {
                mergedList.add(detailObject);
            }
        }
        return mergedList;
    }

    @Override
    public AppItmSpuRespVO findIdOne(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = this.scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5546\u54c1");
        }
        List<ItmItemAttachmentRpcDTO> skuAttachmentList = itemDOS.stream().filter(row -> CollUtil.isNotEmpty(row.getSkuAttachmentList())).flatMap(item -> item.getSkuAttachmentList().stream()).collect(Collectors.toList());
        AppItmSpuRespVO appItmSpuRespVO = ScpStoreItemConvert.INSTANCE.doToRespVo(itemDOS.get(0));
        appItmSpuRespVO.setSkuAttchmentList(skuAttachmentList);
        appItmSpuRespVO.setSpuAttchmentList(itemDOS.get(0).getSpuAttachmentList());
        Long currentUserId = UserService.currentUserId();
        appItmSpuRespVO.setCollectFlag(this.collectRedisUtil.existsSpuInUser(paramVO.getStoreCode(), currentUserId, paramVO.getItemCode()));
        return appItmSpuRespVO;
    }

    @Override
    public AppItemSpecRespVO specQuery(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = this.scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5546\u54c1");
        }
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItemActivityItemPriceParamVO> priceParamVOS = itemDOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            return priceParamVO;
        }).collect(Collectors.toList());
        Long currentUserId = UserService.currentUserId();
        Map<String, List<PriPriceRpcDTO>> priceMap = this.commonPriceService.getPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItmSkuRespVO> skuRespVOList = itemDOS.stream().map(row -> {
            ScpStoreCartDO storeCartItem;
            AppItmSkuRespVO appItmSkuRespVO = ScpStoreItemConvert.INSTANCE.doToSkuRespVo((ScpStoreItemDO)row);
            List priceRpcDTOS = (List)priceMap.get(row.getItemCode());
            if (CollUtil.isNotEmpty((Collection)priceRpcDTOS)) {
                appItmSkuRespVO.setPrice(((PriPriceRpcDTO)priceRpcDTOS.get(0)).getPrice());
            }
            if ((storeCartItem = this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(null, row.getItemCode()), paramVO.getStoreCode(), paramVO.getDocType(), currentUserId)) != null) {
                appItmSkuRespVO.setQty(storeCartItem.getQty());
            } else {
                appItmSkuRespVO.setQty(BigDecimal.ZERO);
            }
            return appItmSkuRespVO;
        }).collect(Collectors.toList());
        AppItemSpecRespVO result = new AppItemSpecRespVO();
        result.setMaxPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setMinPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setSkuRespVOList(skuRespVOList);
        return result;
    }

    private void itemMessageImageAndDetailsQuery(List<AppItmItemPageVO> collect, String storeCode, String cartType, String ouCode) {
        Long currentUserId = UserService.currentUserId();
        List<Long> spuIdList = collect.stream().map(AppItmItemPageVO::getSpuId).collect(Collectors.toList());
        List<String> itemCodeList = this.scpCateItemRepoProc.pageItemCodesByParam(spuIdList);
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(ouCode);
        param.setItmBusinessFlag(Boolean.valueOf(true));
        param.setEnable(Boolean.valueOf(true));
        param.setSaleFreeze(Boolean.valueOf(false));
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemScpBaseRpcDtoByParam(param);
        Map<Long, List<ItmItemScpBaseRpcDTO>> groupData = itemRpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getSpuId));
        collect.forEach(t -> {
            List itemScpBaseRpcDTOS = (List)groupData.get(t.getSpuId());
            if (itemScpBaseRpcDTOS == null) {
                return;
            }
            ItmItemScpBaseRpcDTO itmItemRpcDTO = (ItmItemScpBaseRpcDTO)itemScpBaseRpcDTOS.get(0);
            t.setItemId(itmItemRpcDTO.getId());
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            t.setItemType2(itmItemRpcDTO.getItemType2());
            t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            t.setDetails(this.getDetails(CollectionUtils.isNotEmpty((Collection)itmItemRpcDTO.getSubItems()) ? itmItemRpcDTO.getSubItems() : itemScpBaseRpcDTOS, storeCode, cartType, currentUserId, itmItemRpcDTO));
            t.setCombineItemFlag(CollectionUtils.isNotEmpty((Collection)itmItemRpcDTO.getSubItems()));
            if (Boolean.TRUE.equals(t.getCombineItemFlag())) {
                t.setDecimalPlaces(0);
            }
            log.info("\u5f53\u524d\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)t));
        });
        collect.removeIf(t -> !groupData.containsKey(t.getSpuId()));
    }

    @SysCodeProc
    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source, String storeCode, String cartType, Long currentUserId, ItmItemScpBaseRpcDTO parentItem) {
        log.info("\u83b7\u53d6\u8be6\u60c5\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(source));
        return source.stream().map(itmItemRpcDTO -> {
            AppItmItemPageVO t = new AppItmItemPageVO();
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            if (StrUtil.isNotBlank((CharSequence)cartType)) {
                ScpStoreCartDO storeCartItem = itmItemRpcDTO.getBomPid() != null ? this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(parentItem.getItemCode(), itmItemRpcDTO.getItemCode()), storeCode, cartType, currentUserId) : this.cartRedisUtil.getStoreCartItem(itmItemRpcDTO.getItemCode(), storeCode, cartType, currentUserId);
                if (storeCartItem != null) {
                    t.setQty(storeCartItem.getQty());
                } else {
                    t.setQty(BigDecimal.ZERO);
                }
            }
            t.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            t.setItemId(itmItemRpcDTO.getId());
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            t.setMoq(itmItemRpcDTO.getMoq());
            t.setPrice(itmItemRpcDTO.getPrice());
            t.setCombineQty(itmItemRpcDTO.getBomQty());
            if (itmItemRpcDTO.getBomPid() != null) {
                t.setCombineItemFlag(Boolean.TRUE);
                t.setCombineItemCode(parentItem.getItemCode());
                t.setCombineItemName(parentItem.getItemName());
            } else {
                t.setCombineItemFlag(Boolean.FALSE);
            }
            log.info("get detail:\u5f53\u524d\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)t));
            return t;
        }).collect(Collectors.toList());
    }

    public AppItemActivityrServiceImpl(RmiItemService rmiItemService, CartRedisUtil cartRedisUtil, CollectRedisUtil collectRedisUtil, ScpCateItemRepoProc scpCateItemRepoProc, ScpCacheService scpCacheService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpAllocSettingItemDomainService scpAllocSettingItemDomainService) {
        this.rmiItemService = rmiItemService;
        this.cartRedisUtil = cartRedisUtil;
        this.collectRedisUtil = collectRedisUtil;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.scpCacheService = scpCacheService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpAllocSettingItemDomainService = scpAllocSettingItemDomainService;
    }
}

