/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.order;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderReplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba2\u8d27\u5355\u8bc4\u4ef7\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/order/reply"}, produces={"application/json"})
public class ScpDemandOrderReplyController {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderReplyController.class);
    private final ScpDemandOrderReplyService scpDemandOrderReplyService;

    @ApiOperation(value="\u8ba2\u8d27\u5355\u8bc4\u4ef7 - \u67e5\u8be2\u8bc4\u4ef7\u4fe1\u606f")
    @GetMapping(value={"/findByOrderId/{orderId}"})
    public ApiResult<ScpDemandOrderReplyRespVO> findByOrderId(@PathVariable Long orderId) {
        log.info("[SCP-ORDER-REPLY] findByOrderId, id ={}", (Object)orderId);
        return ApiResult.ok((Object)this.scpDemandOrderReplyService.findReplyByOrderId(orderId));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u8ba2\u8d27\u5355\u8bc4\u4ef7 - \u8bc4\u4ef7")
    public ApiResult<Long> reply(@RequestBody @Validated ScpDemandOrderReplySaveVO saveVO) {
        log.info("[SCP-ORDER-REPLY] reply  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpDemandOrderReplyService.create(saveVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u5355\u8bc4\u4ef7 - \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpDemandOrderReplyPageRespVO>> page(@RequestBody ScpDemandOrderReplyPageParamVO paramVO) {
        log.info("[SCP-DEMAND-REPLY] page  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderReplyService.page(paramVO));
    }

    public ScpDemandOrderReplyController(ScpDemandOrderReplyService scpDemandOrderReplyService) {
        this.scpDemandOrderReplyService = scpDemandOrderReplyService;
    }
}

