package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel("分页查询返回值")
@Data
public class ScpCateItemPageVO implements Serializable {
    private static final long serialVersionUID = 8027787905788852916L;

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("商品类型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("分类名称")
    private String itemCateFullName;

    @ApiModelProperty("品牌")
    private String brandName;

    @ApiModelProperty("税率(进项)")
    private BigDecimal taxRate;

    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    @ApiModelProperty("配送类型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @SysCode(sys = "yst-supp", mod = "ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;
    private String itemSupplySourceName;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("配货模式")
    @SysCode(sys = "yst-supp", mod = "ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;

    @ApiModelProperty(value = "保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty(value = "保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(sys = "yst-supp", mod = "TIME_UNIT")
    private String guaranteePeriodUnit;
    @ApiModelProperty("保质期单位名称")
    private String guaranteePeriodUnitName;

    @ApiModelProperty("是否热销")
    private Boolean hotFlag;

    @ApiModelProperty(value = "小程序品类")
    private String scpCateCode;

    @ApiModelProperty(value = "小程序品类")
    private String scpCateName;

    @ApiModelProperty(value = "scpCateItemId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long scpCateItemId;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    @ApiModelProperty("组合商品编码")
    private Boolean combineItemFlag;

    @ApiModelProperty("品类名称")
    private String cateName;
}
