package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreCalendarSetLineRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@RequiredArgsConstructor
@Service
@Slf4j
public class ScpStoreCalendarSetLineDomainServiceImpl implements ScpStoreCalendarSetLineDomainService {
    private final ScpStoreCalendarSetLineRepoProc scpStoreCalendarSetLineRepoProc;

    @Override
    public PagingVO<ScpStoreCalendarSetLinePageRespVO> queryCalendarSetLineList(ScpStoreCalendarSetLinePageParamVO paramVO) {
        long count = scpStoreCalendarSetLineRepoProc.count(paramVO);
        if (count > 0) {
            var demandSet = scpStoreCalendarSetLineRepoProc.queryCalendarSetLine(paramVO);
            return new PagingVO<>(count, demandSet);
        }
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByParam(ScpStoreCalendarSetLineDelVO paramVO) {
        scpStoreCalendarSetLineRepoProc.deleteByParam(paramVO);
    }

    @Override
    public List<ScpStoreCalendarSetLineRespVO> findCalendarSetByParam(Long masId, Integer todayWeek) {
        return scpStoreCalendarSetLineRepoProc.findStoreByParam(masId, todayWeek);
    }

    @Override
    public List<ScpStoreCalendarSetLineRespVO> findCalendarSetInfoByParam(ScpStoreCalendarSetLineParamVO paramVO) {
        return scpStoreCalendarSetLineRepoProc.findStoreByParam(paramVO);
    }

    @Override
    public Long countCalendarSetLine(ScpStoreCalendarSetLineParamVO paramVO) {
        return scpStoreCalendarSetLineRepoProc.countCalendarSetLine(paramVO);
    }

    @Override
    public List<ScpStoreCalendarSetLineRespVO> findStoreCodeByMasId(Long masId, Integer year) {
        return scpStoreCalendarSetLineRepoProc.findStoreCodeByMasId(masId, year);
    }
}
