package com.elitesland.scp.application.facade.vo.freight;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Rikyon
 * @description: 门店订单运费查询返回
 * @datetime 2025年 08月 15日 9:54
 * @version: 1.0
 */

@Data
@ApiModel(value = "ScpStoreOrderFreightQuaryRespVO", description = "门店订单运费查询返回")
public class ScpStoreOrderFreightQuaryRespVO extends BaseModel implements Serializable {

    // 订货类型+仓库+门店+商品+订货数量+订货含税金额+订货单行主键+订货单主键+运费金额

    @ApiModelProperty("订货类型")
    @SysCode(sys = "yst-suplan", mod = "FREIGHT_ORDER_TYPE")
    private String orderType;
    private String orderTypeName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("需求类型")
    @SysCode(sys = "yst-suplan", mod = "FREIGHT_METHOD")
    private String demandType;
    private String demandTypeName;

    @ApiModelProperty("需求门店编码")
    private String storeCode;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("需求数量(订货含税金额)")
    private BigDecimal demandQuantity;

    @ApiModelProperty("订货含税金额")
    private BigDecimal planAmt;

    @ApiModelProperty("订货单主键")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long orderId;

    @ApiModelProperty("订货单行主键")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long orderDId;

    @ApiModelProperty("运费金额")
    private BigDecimal freightAmt;

}
