package com.elitesland.scp.infr.repo.alloc;

import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingBrandDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface ScpAllocSettingBrandRepo extends JpaRepository<ScpAllocSettingBrandDO, Long>, QuerydslPredicateExecutor<ScpAllocSettingBrandDO> {

    Optional<ScpAllocSettingBrandDO> findById(Long id);

    List<ScpAllocSettingBrandDO> findByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_alloc_setting_brand where mas_id = ?1 ", nativeQuery = true)
    void deleteByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_alloc_setting_brand where id in ?1 ", nativeQuery = true)
    void deleteByIds(List<Long> ids);
}
