/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.user;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkoauth2_1_0.Client;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoAccessTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoAccessTokenResponse;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoUserInfoHeaders;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoUserInfoRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoUserInfoResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/api"})
public class UserOssController {
    private static final Logger log = LoggerFactory.getLogger(UserOssController.class);
    @Value(value="${dingtalk.corpId}")
    private String corpId;
    @Value(value="${dingtalk.ssoSecret}")
    private String ssoSecret;
    @Autowired
    private UserRpcService userRpcService;
    @Autowired
    private TextEncryptor textEncryptor;
    @Autowired
    private SysUserPermissionRpcService sysUserPermissionRpcService;

    @GetMapping(value={"/ssoUserInfo"})
    public ApiResult<Object> ssoUserInfo(@RequestParam String code) {
        if (code == null || code.isEmpty()) {
            log.error("\u8bf7\u6c42\u7f3a\u5c11 code \u53c2\u6570");
            return ApiResult.fail((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11\u6388\u6743\u7801");
        }
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        try {
            String accessToken = this.getAccessToken();
            if (accessToken == null || accessToken.isEmpty()) {
                log.error("\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25, corpId: {}", (Object)this.corpId);
                return ApiResult.fail((String)"\u7cfb\u7edf\u65e0\u6cd5\u83b7\u53d6\u9489\u9489\u8bbf\u95ee\u4ee4\u724c");
            }
            Client client = new Client(config);
            GetSsoUserInfoHeaders getSsoUserInfoHeaders = new GetSsoUserInfoHeaders();
            getSsoUserInfoHeaders.xAcsDingtalkAccessToken = accessToken;
            GetSsoUserInfoRequest getSsoUserInfoRequest = new GetSsoUserInfoRequest().setCode(code);
            GetSsoUserInfoResponse getSsoUserInfoResponse = client.getSsoUserInfoWithOptions(getSsoUserInfoRequest, getSsoUserInfoHeaders, new RuntimeOptions());
            log.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u6210\u529f, body: {}", (Object)getSsoUserInfoResponse.getBody());
            ApiResult mobile = this.userRpcService.getByUsername(Objects.requireNonNull(getSsoUserInfoResponse.getBody()).getUserName());
            if (mobile == null || mobile.getData() == null) {
                return ApiResult.fail();
            }
            Long id = ((SysUserBasicDTO)mobile.getData()).getId();
            String encrypt = this.textEncryptor.encrypt(String.valueOf(id));
            AuthUserIdQueryDTO authUserIdQueryDTO = new AuthUserIdQueryDTO();
            authUserIdQueryDTO.setUserIdCypher(encrypt);
            ApiResult oAuthTokenApiResult = this.sysUserPermissionRpcService.authByUserId(authUserIdQueryDTO);
            if (oAuthTokenApiResult.isSuccess()) {
                JSONObject body = new JSONObject();
                body.put("accessToken", (Object)(Objects.requireNonNull((OAuthToken)oAuthTokenApiResult.getData()).getTokenType() + " " + Objects.requireNonNull((OAuthToken)oAuthTokenApiResult.getData()).getAccessToken()));
                return ApiResult.ok((Object)body);
            }
            return ApiResult.ok((Object)getSsoUserInfoResponse.getBody());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38, code: {}", (Object)code, (Object)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
    }

    private String getAccessToken() {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        try {
            Client client = new Client(config);
            GetSsoAccessTokenRequest getSsoAccessTokenRequest = new GetSsoAccessTokenRequest().setCorpid(this.corpId).setSsoSecret(this.ssoSecret);
            GetSsoAccessTokenResponse getSsoAccessTokenResponse = client.getSsoAccessToken(getSsoAccessTokenRequest);
            String accessToken = getSsoAccessTokenResponse.getBody().getAccessToken();
            return accessToken;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38, corpId: {}", (Object)this.corpId, (Object)e);
            return null;
        }
    }
}

