package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "购物车保存对象", description = "购物车")
public class StoreCartSaveVO implements Serializable {
    private static final long serialVersionUID = 3257501573580086493L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "采购车类型", required = true)
    @NotBlank(message = "采购车类型不能为空")
    private String cartType;

    @ApiModelProperty(value = "商品ID", required = true)
    @NotNull(message = "商品ID不能为空")
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "商品名称", required = true)
    @NotBlank(message = "商品名称不能为空")
    private String itemName;

    @ApiModelProperty(value = "单位", required = true)
    @NotBlank(message = "单位不能为空")
    private String uom;

    @ApiModelProperty(value = "单位名称", required = true)
    @NotBlank(message = "单位名称不能为空")
    private String uomName;

    @ApiModelProperty(value = "商品SPU-ID", required = true)
    @NotNull(message = "商品SPU-ID不能为空")
    private Long spuId;

    @ApiModelProperty(value = "商品SPU编码", required = true)
    @NotBlank(message = "商品SPU编码不能为空")
    private String spuCode;

    @ApiModelProperty(value = "商品SPU名称", required = true)
    @NotBlank(message = "商品SPU名称不能为空")
    private String spuName;

    @ApiModelProperty("数量")
    @NotNull(message = "商品数量不能为空")
    private BigDecimal qty;

    @ApiModelProperty("含税单价(总价)")
    @NotNull(message = "含税单价不能为空")
    private BigDecimal itemPrice;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("图片url")
    private String url;

    @ApiModelProperty(value = "商品品类编码")
    @NotBlank(message = "商品品类编码不能为空")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    @NotBlank(message = "商品品类名称不能为空")
    private String itemCateName;

    @ApiModelProperty("基本单位")
    @NotBlank(message = "基本单位不能为空")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    @NotBlank(message = "基本单位名称不能为空")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    @NotNull(message = "单位转换系数不能为空")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    @NotNull(message = "有效位数不能为空")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "商品分类")
    @NotBlank(message = "商品分类不能为空")
    private String itemType;

    @ApiModelProperty(value = "单据类型")
    private String docType;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty(value = "最小起订量")
    private BigDecimal moq;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("子品组合数量")
    private BigDecimal combineQty;

    @ApiModelProperty("是否属于强配商品")
    private Boolean activityItemFlag;

    private Long activityId;

    @ApiModelProperty(value = "强配活动编码")
    private String activityCode;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    private Boolean autoAddFlag;
}
