package com.elitesland.scp.domain.entity.order;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "scp_demand_set")
@org.hibernate.annotations.Table(appliesTo = "scp_demand_set", comment = "订货集")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货集", description = "订货集")
@Where(clause = "delete_flag = 0")
public class ScpDemandSetDO extends BaseModel implements Serializable {

    @ApiModelProperty("类型")
    @Comment("类型")
    @Column()
    private String type;

    @ApiModelProperty("订货集编码")
    @Comment("订货集编码")
    @Column()
    private String demandCode;

    @ApiModelProperty("订货集名称")
    @Comment("订货集名称")
    @Column()
    private String demandName;

    @ApiModelProperty("需求日期")
    @Comment("需求日期")
    @Column()
    private LocalDateTime demandDate;

    @ApiModelProperty("状态")
    @Comment("状态")
    @Column()
    private Boolean status;

    @ApiModelProperty("是否已推送")
    @Comment("是否已推送")
    @Column()
    private Boolean isPushed;

    @ApiModelProperty("计算分配结果")
    @Comment("计算分配结果")
    @Column()
    private String computeMsg;

    @ApiModelProperty("推送结果")
    @Comment("推送结果")
    @Column()
    private String pushMsg;

    @ApiModelProperty("订货截止时间点，格式：yyyy-MM-dd HH:mm:ss")
    @Comment("订货截止时间点,格式：yyyy-MM-dd HH:mm:ss")
    @Column()
    private LocalDateTime expireTime;


    @ApiModelProperty("适用单据类型")
    @Column()
    private String docType;

    @ApiModelProperty("应用门店代码")
    @Column()
    private String storeCode;

    @ApiModelProperty("应用门店名称")
    @Column()
    private String storeName;

    @ApiModelProperty("所属区域")
    @Column()
    private String regionCode;


    @ApiModelProperty("创建方式")
    @Comment("创建方式")
    @Column()
    private String createType;



}
