package com.elitesland.scp.infr.repo.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDetailRespVO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDDO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDPlanDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpMrpDRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpMrpDO scpMrpDO = QScpMrpDO.scpMrpDO;
    private final QScpMrpDDO scpMrpDDO = QScpMrpDDO.scpMrpDDO;
    private final QScpMrpDPlanDO scpMrpDPlanDO = QScpMrpDPlanDO.scpMrpDPlanDO;

    private final QBean<ScpMrpDRespVO> baseBean = Projections.bean(
            ScpMrpDRespVO.class,
            scpMrpDDO.id,
            scpMrpDDO.masId,
            scpMrpDDO.ouId,
            scpMrpDDO.ouCode,
            scpMrpDDO.ouName,
            scpMrpDDO.whId,
            scpMrpDDO.whCode,
            scpMrpDDO.whName,
            scpMrpDDO.itemId,
            scpMrpDDO.itemCode,
            scpMrpDDO.itemName,
            scpMrpDDO.predSafetyQty,
            scpMrpDDO.predTargetQty,
            scpMrpDDO.invQty,
            scpMrpDDO.grossDemand,
            scpMrpDDO.purTransitQty,
            scpMrpDDO.moq,
            scpMrpDDO.uom,
            scpMrpDDO.uomName,
            scpMrpDDO.purLeadTime,
            scpMrpDDO.expectArriveDate,
            scpMrpDDO.salQty,
            scpMrpDDO.ioQty,
            scpMrpDDO.beforeQty,
            scpMrpDDO.uomRatio,
            scpMrpDDO.invTurnover,
            scpMrpDDO.stdInvTurnover,
            scpMrpDDO.netDemand,
            scpMrpDDO.creator,
            scpMrpDDO.createUserId,
            scpMrpDDO.createTime,
            scpMrpDDO.updater,
            scpMrpDDO.modifyUserId,
            scpMrpDDO.modifyTime,
            scpMrpDDO.remark
    );

    public PagingVO<ScpMrpDRespVO> pageQuery(ScpMrpDPageParam param) {
        if (param == null) {
            return PagingVO.<ScpMrpDRespVO>builder().total(0).records(null).build();
        }
        var jpaQuery = jpaQueryFactory.select(baseBean)
                .from(scpMrpDDO);

        jpaQuery.where(this.where(param));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, scpMrpDDO);
        return PagingVO.<ScpMrpDRespVO>builder()
                .total(pageCount(param))
                .records(jpaQuery.fetch())
                .build();
    }

    public Long pageCount(ScpMrpDPageParam param) {
        var jpaQuery = jpaQueryFactory.select(scpMrpDDO.count())
                .from(scpMrpDDO);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }

        return jpaQuery.fetchCount();
    }

    private Predicate where(ScpMrpDPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (param.getMasId() != null) {
            predicates.add(scpMrpDDO.masId.eq(param.getMasId()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            predicates.add(scpMrpDDO.id.in(param.getIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getOuIds())) {
            predicates.add(scpMrpDDO.ouId.in(param.getOuIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getWhIds())) {
            predicates.add(scpMrpDDO.whId.in(param.getWhIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            predicates.add(scpMrpDDO.itemId.in(param.getItemIds()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findIdsByMasIds(List<Long> masIds) {
        return jpaQueryFactory.select(scpMrpDDO.id)
                .from(scpMrpDDO)
                .where(scpMrpDDO.masId.in(masIds)).fetch();
    }

    public PagingVO<ScpMrpDExportRespVO> queryExport(ScpMrpDPageParam param) {
        if (param == null) {
            return PagingVO.<ScpMrpDExportRespVO>builder().total(0).records(null).build();
        }
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpMrpDExportRespVO.class,
                        scpMrpDO.mrpLotNo,
                        scpMrpDO.predLotNo,
                        scpMrpDDO.id,
                        scpMrpDDO.ouCode,
                        scpMrpDDO.ouName,
                        scpMrpDDO.whCode,
                        scpMrpDDO.whName,
                        scpMrpDDO.itemCode,
                        scpMrpDDO.itemName,
                        scpMrpDDO.predSafetyQty,
                        scpMrpDDO.predTargetQty,
                        scpMrpDDO.invQty,
                        scpMrpDDO.grossDemand,
                        scpMrpDDO.purTransitQty,
                        scpMrpDDO.moq,
                        scpMrpDDO.uom.as("purUom"),
                        scpMrpDDO.uomName.as("purUomName"),
                        scpMrpDDO.purLeadTime,
                        scpMrpDDO.expectArriveDate,
                        scpMrpDDO.salQty,
                        scpMrpDDO.ioQty,
                        scpMrpDDO.beforeQty,
                        scpMrpDDO.uomRatio,
                        scpMrpDDO.invTurnover,
                        scpMrpDDO.stdInvTurnover,
                        scpMrpDDO.netDemand,
                        scpMrpDDO.createTime,
                        scpMrpDDO.modifyTime,
                        scpMrpDDO.creator,
                        scpMrpDPlanDO.ouCode.as("purOuCode"),
                        scpMrpDPlanDO.ouName.as("purOuName"),
                        scpMrpDPlanDO.suppCode,
                        scpMrpDPlanDO.suppName,
                        scpMrpDPlanDO.qty.as("purQty"),
                        scpMrpDPlanDO.poNo,
                        scpMrpDPlanDO.poLineNo,
                        scpMrpDPlanDO.pushStatus,
                        scpMrpDPlanDO.pushFailReason
                ))
                .from(scpMrpDDO)
                .leftJoin(scpMrpDO).on(scpMrpDO.id.eq(scpMrpDDO.masId))
                .leftJoin(scpMrpDPlanDO).on(scpMrpDDO.id.eq(scpMrpDPlanDO.masId));

        jpaQuery.where(this.where(param));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, scpMrpDDO);
        return PagingVO.<ScpMrpDExportRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public void updateNetDemand(Long id, BigDecimal netDemand) {
        jpaQueryFactory.update(scpMrpDDO)
                .set(scpMrpDDO.netDemand, netDemand)
                .where(scpMrpDDO.id.eq(id))
                .execute();
    }

    public JPAQuery<ScpMrpDetailRespVO> selectDetail() {
        return jpaQueryFactory.select(Projections.bean(ScpMrpDetailRespVO.class,
                        scpMrpDO.mrpLotNo,
                        scpMrpDO.predLotNo,
                        scpMrpDDO.id.as("dId"),
                        scpMrpDDO.masId,
                        scpMrpDDO.ouCode,
                        scpMrpDDO.ouName,
                        scpMrpDDO.whCode,
                        scpMrpDDO.whName,
                        scpMrpDDO.itemId,
                        scpMrpDDO.itemCode,
                        scpMrpDDO.itemName,
                        scpMrpDDO.predSafetyQty,
                        scpMrpDDO.predTargetQty,
                        scpMrpDDO.invQty,
                        scpMrpDDO.grossDemand,
                        scpMrpDDO.purTransitQty,
                        scpMrpDDO.moq,
                        scpMrpDDO.purLeadTime,
                        scpMrpDDO.expectArriveDate,
                        scpMrpDDO.salQty,
                        scpMrpDDO.ioQty,
                        scpMrpDDO.beforeQty,
                        scpMrpDDO.uomRatio,
                        scpMrpDDO.invTurnover,
                        scpMrpDDO.stdInvTurnover,
                        scpMrpDDO.netDemand,
                        scpMrpDDO.uom.as("purUom"),
                        scpMrpDDO.uomName.as("purUomName"),
                        scpMrpDPlanDO.id.as("planId"),
                        scpMrpDPlanDO.ouId.as("purOuId"),
                        scpMrpDPlanDO.ouCode.as("purOuCode"),
                        scpMrpDPlanDO.ouName.as("purOuName"),
                        scpMrpDPlanDO.suppId,
                        scpMrpDPlanDO.suppCode,
                        scpMrpDPlanDO.suppName,
                        scpMrpDPlanDO.qty.as("purQty"),
                        scpMrpDPlanDO.poNo,
                        scpMrpDPlanDO.poLineNo,
                        scpMrpDPlanDO.pushStatus,
                        scpMrpDPlanDO.pushFailReason
                ))
                .from(scpMrpDDO)
                .leftJoin(scpMrpDO).on(scpMrpDO.id.eq(scpMrpDDO.masId))
                .leftJoin(scpMrpDPlanDO).on(scpMrpDDO.id.eq(scpMrpDPlanDO.masId));
    }


    public List<ScpMrpDetailRespVO> findDetailByMasId(Long masId) {
        return selectDetail().where(scpMrpDDO.masId.eq(masId)).fetch();
    }
}
