/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import com.elitesland.inv.dto.invTrn.StoreOrderTrnRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.order.param.SalSoSaveDTO;
import com.elitesland.pur.dto.po.PurPoSaveDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpComputeDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpPoOrderCreateMqParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpSaleOrderCreateMqParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpTrnOrderCreateMqParam;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandUrgentSetSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.order.ScpDemandOrderSetService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.order.ScpDemandSetConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.TransactionCommitHandler;
import com.elitesland.support.provider.dingding.dto.Body;
import com.elitesland.support.provider.dingding.dto.FormItem;
import com.elitesland.support.provider.dingding.dto.Head;
import com.elitesland.support.provider.dingding.dto.OA;
import com.elitesland.support.provider.dingding.dto.OAMessageContent;
import com.elitesland.support.provider.dingding.dto.TodoCreateRequestDTO;
import com.elitesland.support.provider.dingding.dto.TodoDtlRequestDTO;
import com.elitesland.support.provider.dingding.dto.WorkCreateRequestDTO;
import com.elitesland.support.provider.dingding.service.DingDingRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreWhDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ScpDemandOrderSetServiceImpl
implements ScpDemandOrderSetService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderSetServiceImpl.class);
    private final RedisTemplate redisTemplate;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final TransactionCommitHandler transactionCommitHandler;
    private final ScpDemandOrderService scpDemandOrderService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final TaskExecutor taskExecutor;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiSysUDCService rmiSysUDCService;
    private final TaskExecutor executor;
    private final EmployeeRpcService employeeRpcService;
    private final SysUserPermissionRpcService sysUserPermissionRpcService;
    private final DingDingRpcService dingDingRpcService;
    private final SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService;

    @Override
    public PagingVO<ScpDemandSetPageRespVO> queryDemandSetList(ScpDemandSetPageParamVO paramVO) {
        return this.scpDemandSetDomainService.queryDemandSetList(paramVO);
    }

    @Override
    public Optional<ScpDemandSetRespVO> findDemandSetById(Long id) {
        Map<String, String> createTypeMap = this.rmiSysUDCService.getCodeMap("yst-suplan", UdcEnum.SCP_ORDER_SET_CREATE_TYPE_01.getCode());
        return this.scpDemandSetDomainService.findDemandSetById(id).map(row -> {
            ScpDemandSetRespVO scpDemandSetRespVO = ScpDemandSetConvert.INSTANCE.dtoToRespVO((ScpDemandSetDTO)row);
            if (row.getExpireTime() != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                scpDemandSetRespVO.setExpireTimeStr(row.getExpireTime().toLocalTime().format(formatter));
                scpDemandSetRespVO.setCreateTypeName((String)createTypeMap.get(row.getCreateType()));
            }
            return scpDemandSetRespVO;
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveDemandSet(ScpDemandSetSaveVO saveVO) {
        this.checkDemandSetParam(saveVO);
        if (saveVO.getId() == null) {
            saveVO.setDemandCode(this.orderSetNo(saveVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)saveVO.getExpireTimeStr())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            LocalDateTime expireTime = LocalDateTime.of(saveVO.getDemandDate().toLocalDate(), LocalTime.parse(saveVO.getExpireTimeStr(), formatter));
            saveVO.setExpireTime(expireTime);
        }
        return this.scpDemandSetDomainService.saveDemandSet(saveVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveUrgentDemandSet(ScpDemandUrgentSetSaveVO saveVO) {
        saveVO.setType(ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        saveVO.setDemandDate(LocalDateTime.now());
        saveVO.setStatus(false);
        if (saveVO.getId() == null) {
            saveVO.setDemandCode(this.orderSetNo(saveVO.getType()));
        }
        saveVO.setDemandName("\u95e8\u5e97\u8ba2\u8d27\u96c6" + this.convertDate(LocalDate.now().atStartOfDay()) + saveVO.getDemandCode().substring(saveVO.getDemandCode().length() - 3));
        if (StrUtil.isNotBlank((CharSequence)saveVO.getExpireTimeStr())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            LocalDateTime expireTime = LocalDateTime.of(saveVO.getDemandDate().toLocalDate(), LocalTime.parse(saveVO.getExpireTimeStr(), formatter));
            saveVO.setExpireTime(expireTime);
        }
        ScpDemandSetSaveVO scpDemandSetSaveVO = ScpDemandSetConvert.INSTANCE.saveVoToUrgentSaveVO(saveVO);
        scpDemandSetSaveVO.setCreateType(UdcEnum.SCP_ORDER_SET_CREATE_TYPE_03.getValueCode());
        Long demandSet = this.scpDemandSetDomainService.saveDemandSet(scpDemandSetSaveVO);
        this.extractedDingdingMsgHandler(saveVO, demandSet);
        CompletableFuture.runAsync(() -> this.pushMessage(saveVO, demandSet), (Executor)this.executor);
        return demandSet;
    }

    private void extractedDingdingMsgHandler(ScpDemandUrgentSetSaveVO saveVO, Long demandSet) {
        CompletableFuture.runAsync(() -> {
            log.info("\u5f00\u59cb\u53d1\u9001\u7d27\u6025\u8ba2\u8d27\u9489\u9489\u6d88\u606f");
            List<SysEmployeeBasicDTO> allEmployees = this.getEmployeeBasicDTOS();
            if (CollUtil.isNotEmpty(allEmployees)) {
                List<String> userIds = allEmployees.stream().map(d -> d.getUserId() == null ? "" : d.getUserId().toString()).toList();
                TodoCreateRequestDTO todoCreateRequestDTO = new TodoCreateRequestDTO();
                todoCreateRequestDTO.setYstUserIds(userIds);
                todoCreateRequestDTO.setSubject(saveVO.getStoreName() + "\u95e8\u5e97\u7533\u8bf7\u7d27\u6025\u8ba2\u8d27");
                todoCreateRequestDTO.setDocId(demandSet);
                todoCreateRequestDTO.setSourceType("ORDER_DEMAND_SET");
                todoCreateRequestDTO.setDescription(saveVO.getStoreName() + "\u5e97\u5df2\u7533\u8bf7\u7d27\u6025\u8ba2\u8d27\uff0c\u5355\u636e\u7c7b\u578b\uff1a" + saveVO.getDocType() + "\u622a\u5355\u65f6\u95f4\uff1a" + saveVO.getExpireTimeStr() + "\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
                TodoDtlRequestDTO todoDtlRequestDTO = new TodoDtlRequestDTO();
                String url = "/suplanapp/suplan/replenishmentPlan/orderSet/" + saveVO.getDemandCode();
                todoDtlRequestDTO.setPcUrl(url);
                todoCreateRequestDTO.setDetailUrl(todoDtlRequestDTO);
                log.info("\u521b\u5efa\u7d27\u6025\u8ba2\u8d27\u5f85\u529e:{}", (Object)todoCreateRequestDTO);
                this.dingDingRpcService.createTodo(todoCreateRequestDTO);
                WorkCreateRequestDTO workCreateRequestDTO = new WorkCreateRequestDTO();
                workCreateRequestDTO.setYstUserIds(userIds);
                workCreateRequestDTO.setDocId(demandSet);
                workCreateRequestDTO.setSourceType("ORDER_DEMAND_SET");
                OAMessageContent oaMessageContent = new OAMessageContent();
                OA oa = new OA();
                oa.setMessageUrl(url);
                oa.setHead(new Head());
                Body body = new Body();
                List<FormItem> form = this.getFormDo(saveVO);
                body.setForm(form);
                oa.setBody(body);
                oaMessageContent.setOa(oa);
                workCreateRequestDTO.setMsgContent(oaMessageContent);
                this.dingDingRpcService.createWork(workCreateRequestDTO);
                log.info("\u53d1\u9001\u7d27\u6025\u8ba2\u8d27\u9489\u9489\u6d88\u606f\u7ed3\u675f");
            }
        }, (Executor)this.executor);
    }

    @NotNull
    private List<SysEmployeeBasicDTO> getEmployeeBasicDTOS() {
        ArrayList<SysEmployeeBasicDTO> allEmployees = new ArrayList<SysEmployeeBasicDTO>();
        EmployeeQueryDTO logisticsQuery = new EmployeeQueryDTO();
        logisticsQuery.setDuty("\u7269\u6d41\u4e13\u5458");
        List logisticsStaff = (List)this.employeeRpcService.queryList(logisticsQuery).computeData();
        if (CollUtil.isNotEmpty((Collection)logisticsStaff)) {
            allEmployees.addAll(logisticsStaff);
        }
        EmployeeQueryDTO plannerQuery = new EmployeeQueryDTO();
        plannerQuery.setDuty("\u8ba1\u5212\u4e13\u5458");
        List planners = (List)this.employeeRpcService.queryList(plannerQuery).computeData();
        if (CollUtil.isNotEmpty((Collection)planners)) {
            allEmployees.addAll(planners);
        }
        EmployeeQueryDTO planningManagerQuery = new EmployeeQueryDTO();
        planningManagerQuery.setDuty("\u8ba1\u5212\u4e3b\u7ba1");
        List planningManagers = (List)this.employeeRpcService.queryList(planningManagerQuery).computeData();
        if (CollUtil.isNotEmpty((Collection)planningManagers)) {
            allEmployees.addAll(planningManagers);
        }
        return allEmployees;
    }

    public void pushMessage(ScpDemandUrgentSetSaveVO saveVO, Long demandSet) {
        log.info("\u7d27\u6025\u8ba2\u8d27{}\u7ad9\u5185\u6d88\u606f\u63a8\u9001\u5f00\u59cb", (Object)saveVO.getDemandCode());
        try {
            TemplateEmployeeSendParamDTO employeeSendParamDTO = new TemplateEmployeeSendParamDTO();
            employeeSendParamDTO.setTemplateCode("ORDER_DEMAND_SET");
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("entityId", demandSet.toString());
            objectObjectHashMap.put("msgType", "ORDER_DEMAND_SET");
            employeeSendParamDTO.setMesJoinParamMap(objectObjectHashMap);
            HashMap<String, String> total = new HashMap<String, String>();
            total.put("storeName", saveVO.getStoreName());
            HashMap<String, String> content = new HashMap<String, String>();
            content.put("storeName", saveVO.getStoreName());
            content.put("docType", saveVO.getDocType());
            content.put("expireTime", saveVO.getExpireTimeStr());
            employeeSendParamDTO.setTitleReplaceMap(total);
            employeeSendParamDTO.setContentReplaceMap(content);
            List<SysEmployeeBasicDTO> allEmployees = this.getEmployeeBasicDTOS();
            if (CollUtil.isNotEmpty(allEmployees)) {
                List receiptentUser = allEmployees.stream().map(vo -> {
                    MsgRecipientUserDTO msgRecipientUserDTO = new MsgRecipientUserDTO();
                    msgRecipientUserDTO.setUserId(vo.getUserId());
                    msgRecipientUserDTO.setUserName(vo.getMobile());
                    msgRecipientUserDTO.setUserStandby(vo.getLastName());
                    return msgRecipientUserDTO;
                }).collect(Collectors.toList());
                employeeSendParamDTO.setRecipientUserList(receiptentUser);
                this.sysMsgTemplateSendRpcService.msgTemplateSend(employeeSendParamDTO);
                log.info("\u63a8\u9001\u7d27\u6025\u8ba2\u8d27\u7ad9\u5185\u6d88\u606f\u7ed3\u675f");
            }
        }
        catch (Exception e) {
            log.error("\u7d27\u6025\u8ba2\u8d27\u63a8\u9001\u7ad9\u5185\u4fe1\u5931\u8d25" + saveVO.getDemandCode(), (Throwable)e);
        }
    }

    private List<FormItem> getFormDo(ScpDemandUrgentSetSaveVO scpDemandUrgentSetSaveVO) {
        ArrayList<FormItem> data = new ArrayList<FormItem>();
        FormItem formItem1 = new FormItem();
        formItem1.setKey("\u8ba2\u8d27\u96c6: ");
        formItem1.setValue(scpDemandUrgentSetSaveVO.getDemandCode());
        data.add(formItem1);
        FormItem formItem2 = new FormItem();
        formItem2.setKey("\u622a\u5355\u65f6\u95f4: ");
        formItem2.setValue(scpDemandUrgentSetSaveVO.getExpireTimeStr());
        data.add(formItem2);
        FormItem formItem3 = new FormItem();
        formItem3.setKey("\u5355\u636e\u7c7b\u578b: ");
        formItem3.setValue(scpDemandUrgentSetSaveVO.getDocType());
        data.add(formItem3);
        FormItem formItem4 = new FormItem();
        formItem4.setKey("\u72b6\u6001: ");
        formItem4.setValue("\u5f85\u542f\u7528");
        data.add(formItem4);
        return data;
    }

    private String convertDate(LocalDateTime demandDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u53f7");
        return demandDate.format(formatter);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeDemandSetStatus(ScpDemandSetStatusParamVO paramVO) {
        if (CollUtil.isEmpty(paramVO.getIds())) {
            throw new BusinessException("\u8ba2\u8d27\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scpDemandSetDomainService.enableDemandSet(paramVO.getIds(), paramVO.getStatus());
        try {
            this.dingdingMsgTaskHandler(paramVO);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6d88\u606f\u5f02\u5e38" + e);
        }
    }

    private void dingdingMsgTaskHandler(ScpDemandSetStatusParamVO paramVO) {
        List<ScpDemandSetDTO> demandSetDTOList;
        List<ScpDemandSetDTO> demandSetByIds;
        if (Boolean.TRUE.equals(paramVO.getStatus()) && CollUtil.isNotEmpty(demandSetByIds = this.scpDemandSetDomainService.findDemandSetByIds(paramVO.getIds())) && CollUtil.isNotEmpty(demandSetDTOList = demandSetByIds.stream().filter(d -> UdcEnum.SCP_ORDER_SET_CREATE_TYPE_03.getValueCode().equals(d.getCreateType())).collect(Collectors.toList()))) {
            demandSetDTOList.forEach(d -> {
                try {
                    this.dingDingRpcService.passTodo(d.getId());
                }
                catch (Exception e) {
                    log.error("\u5904\u7406\u5f85\u529e\u5f02\u5e38" + e);
                }
                try {
                    this.dingDingRpcService.passWork(d.getId(), Boolean.valueOf(true));
                }
                catch (Exception e) {
                    log.error("\u5904\u7406\u5de5\u4f5c\u901a\u77e5\u5f02\u5e38" + e);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        List<ScpDemandSetDTO> demandSetDTOList = this.scpDemandSetDomainService.findDemandSetByIds(ids);
        if (CollUtil.isEmpty(demandSetDTOList)) {
            throw new BusinessException("\u8ba2\u8d27\u96c6\u4e0d\u5b58\u5728");
        }
        Map<LocalDateTime, List<ScpDemandSetDTO>> demandDateMap = demandSetDTOList.stream().collect(Collectors.groupingBy(ScpDemandSetDTO::getDemandDate));
        for (Map.Entry<LocalDateTime, List<ScpDemandSetDTO>> entry : demandDateMap.entrySet()) {
            ScpDemandSetParamVO paramVO = ScpDemandSetParamVO.builder().demandDate(entry.getKey()).build();
            List<ScpDemandSetDTO> scpDemandSetDTOList = this.scpDemandSetDomainService.findDemandSetByParam(paramVO);
            if (scpDemandSetDTOList.size() > entry.getValue().size()) continue;
            throw new BusinessException("\u9700\u6c42\u65e5\u671f" + entry.getKey() + "\u5fc5\u987b\u6709\u4e00\u4e2a\u8ba2\u8d27\u96c6\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        List<ScpDemandOrderRespVO> demandOrderRespVOS = this.scpDemandOrderService.findDemandOrderByDemandIds(ids);
        if (CollUtil.isNotEmpty(demandOrderRespVOS)) {
            throw new BusinessException("\u8ba2\u8d27\u96c6:" + demandOrderRespVOS.get(0).getDemandName() + "\u5df2\u88ab\u8ba2\u8d27\u8ba2\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        demandSetDTOList.forEach(demandSetDTO -> {
            if (demandSetDTO.getStatus().booleanValue()) {
                throw new BusinessException("\u8ba2\u8d27\u96c6" + demandSetDTO.getDemandCode() + "\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        });
        this.scpDemandSetDomainService.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void compute(List<Long> ids) {
        List<ScpDemandSetDTO> demandSetDTOS = this.scpDemandSetDomainService.findDemandSetByIds(ids);
        demandSetDTOS.stream().filter(row -> row.getStatus() == false).forEach(row -> {
            throw new BusinessException("\u8ba2\u8d27\u96c6" + row.getDemandCode() + "\u672a\u542f\u7528");
        });
        this.scpDemandSetDomainService.updateDemandSetMsgByIds(ids, "\u8ba1\u7b97\u4e2d");
        this.transactionCommitHandler.handle(() -> CompletableFuture.supplyAsync(() -> {
            ids.forEach(row -> this.scpDemandOrderService.compute((Long)row));
            return 1;
        }, (Executor)this.taskExecutor));
    }

    @Override
    public List<ScpDemandSetSelectRespVO> demandSetSelectList(ScpDemandSetParamVO paramVO) {
        paramVO.setExpireTime(LocalDateTime.now());
        return this.scpDemandSetDomainService.findDemandSetByParam(paramVO).stream().map(ScpDemandSetConvert.INSTANCE::dtoToSelectRespVO).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandSetPageRespVO> commonPage(ScpDemandSetPageParamVO paramVO) {
        return this.scpDemandSetDomainService.commonPage(paramVO);
    }

    @Override
    @SysCodeProc
    public List<ScpDemandSetPageRespVO> commonNewPage(ScpDemandSetPageParamVO paramVO) {
        paramVO.setExpireTime(LocalDateTime.now());
        OrgStoreDetailRpcDTO byCode = this.rmiOrgStoreRpcService.getByCode(paramVO.getStoreCode());
        if (byCode != null) {
            paramVO.setRegionCode(byCode.getRegion());
        }
        return this.scpDemandSetDomainService.commonNewPage(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void push(List<Long> ids) {
        List<ScpDemandSetDTO> demandSetDTOS = this.scpDemandSetDomainService.findDemandSetByIds(ids);
        demandSetDTOS.stream().filter(row -> row.getStatus() == false).forEach(row -> {
            throw new BusinessException("\u8ba2\u8d27\u96c6" + row.getDemandCode() + "\u672a\u542f\u7528");
        });
        this.scpDemandSetDomainService.updateDemandSetPushMsgById(ids, "\u63a8\u9001\u4e2d");
        this.transactionCommitHandler.handle(() -> CompletableFuture.supplyAsync(() -> {
            ids.forEach(row -> this.pushToOtherDomain((Long)row));
            return 1;
        }, (Executor)this.taskExecutor));
    }

    private void pushToOtherDomain(Long demandSetId) {
        TimeInterval timer = new TimeInterval();
        log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u96c6ID\uff1a{},\u5f00\u59cb\u63a8\u9001", (Object)demandSetId);
        String redisKey = "PUSH_TO_OTHER@".concat(demandSetId.toString());
        if (this.redisTemplate.hasKey((Object)redisKey).booleanValue()) {
            log.info("\u3010pushToOtherDomain\u3011\u8ba2\u8d27\u96c6ID:{},\u6b63\u5728\u63a8\u9001\u4e2d...");
            return;
        }
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)"PUSH_TO_OTHER", 300L, TimeUnit.SECONDS);
        try {
            Long count = this.scpDemandOrderDomainService.countUnPushedOrderByDemandId(demandSetId);
            if (count <= 0L) {
                log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u96c6ID\uff1a{}\uff0c\u65e0\u9700\u63a8\u9001", (Object)demandSetId);
                return;
            }
            CurrentUserDTO currentUserDTO = UserService.currentUser();
            log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)currentUserDTO));
            if (ObjectUtils.isEmpty((Object)currentUserDTO) || currentUserDTO.getDetail() == null) {
                throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u5931\u8d25");
            }
            Integer totalPage = PageUtil.totalPage((long)count, (int)500);
            for (int i = 1; i <= totalPage; ++i) {
                ScpComputeDemandOrderPageParamVO pageParamVO = new ScpComputeDemandOrderPageParamVO();
                pageParamVO.setDemandId(demandSetId);
                pageParamVO.setSize(500);
                pageParamVO.setCurrent(i);
                ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
                OrderItem orderItem = new OrderItem();
                orderItem.setAsc(false);
                orderItem.setColumn("storeLevel");
                orders.add(orderItem);
                pageParamVO.setOrders(orders);
                List<Long> ids = this.scpDemandOrderDomainService.pageDemandOrderIds(pageParamVO);
                List<ScpDemandOrderDTO> demandOrderDTOS = this.scpDemandOrderDomainService.findDemandOrderByIds(ids);
                Map orderMap = demandOrderDTOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                List<ScpDemandOrderDDTO> demandOrderDList = this.scpDemandOrderDDomainService.findDemandOrderDByMasIds(ids);
                Map<Long, List<ScpDemandOrderDDTO>> orderDMap = demandOrderDList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getMasId));
                Map<String, List<OrgStoreWhDTO>> orgStoreMap = this.scpDemandOrderService.getOrgStoreMap(demandOrderDTOS);
                Map<Long, InvWhRpcSimpleDTO> whMap = this.scpDemandOrderService.getWhMap(demandOrderDTOS);
                for (Long id : ids) {
                    ScpDemandOrderDTO scpDemandOrderDTO = (ScpDemandOrderDTO)orderMap.get(id);
                    ScpOrderSettingRespVO setting = this.scpOrderSettingDomainService.findCacheByDocType(scpDemandOrderDTO.getDocType(), scpDemandOrderDTO.getType());
                    List<StoreOrderTrnRpcDTO> storeOrderTrnRpcDTOS = this.scpDemandOrderService.prepareDataTrnPush(scpDemandOrderDTO, orgStoreMap, whMap, currentUserDTO.getDetail().getEmployeeId(), orderDMap.get(id), setting);
                    List<PurPoSaveDTO> purPoSaveDTOS = this.scpDemandOrderService.prepareDataPoPush(scpDemandOrderDTO, orgStoreMap, currentUserDTO.getDetail().getEmployeeId(), orderDMap.get(id), setting);
                    List<SalSoSaveDTO> salSoSaveDTOS = this.scpDemandOrderService.prepareDataSoPush(scpDemandOrderDTO, orgStoreMap, orderDMap.get(id));
                    if (CollUtil.isNotEmpty(storeOrderTrnRpcDTOS)) {
                        ScpTrnOrderCreateMqParam orderCreateMqParam = new ScpTrnOrderCreateMqParam();
                        orderCreateMqParam.setTrnList(storeOrderTrnRpcDTOS);
                        orderCreateMqParam.setBusinessKey("scp_trn_order_create");
                        this.messageQueueTemplate.publishMessage("yst-suplan", "scp_trn_order_create", (Serializable)orderCreateMqParam);
                        log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u5355ID\uff1a{},\u8c03\u62e8\u5355\u63a8\u9001\u6210\u529f", (Object)id);
                    }
                    if (CollUtil.isNotEmpty(purPoSaveDTOS)) {
                        ScpPoOrderCreateMqParam poCreateMqParam = new ScpPoOrderCreateMqParam();
                        poCreateMqParam.setPoList(purPoSaveDTOS);
                        poCreateMqParam.setBusinessKey("scp_po_order_create");
                        this.messageQueueTemplate.publishMessage("yst-suplan", "scp_po_order_create", (Serializable)poCreateMqParam);
                        log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u5355ID\uff1a{},\u91c7\u8d2d\u8ba2\u5355\u63a8\u9001\u6210\u529f", (Object)id);
                    }
                    if (!CollUtil.isNotEmpty(salSoSaveDTOS)) continue;
                    ScpSaleOrderCreateMqParam saleCreateMqParam = new ScpSaleOrderCreateMqParam();
                    saleCreateMqParam.setSaleList(salSoSaveDTOS);
                    saleCreateMqParam.setBusinessKey("scp_po_order_create");
                    this.messageQueueTemplate.publishMessage("yst-suplan", "scp_sale_order_create", (Serializable)saleCreateMqParam);
                    log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u5355ID\uff1a{},\u9500\u552e\u8ba2\u5355\u63a8\u9001\u6210\u529f", (Object)id);
                }
            }
            this.scpDemandSetDomainService.completePushById(demandSetId);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            this.redisTemplate.delete((Object)redisKey);
        }
        log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u96c6ID\uff1a{},\u8017\u65f6\uff1a{}", (Object)demandSetId, (Object)timer.intervalMs());
    }

    private void checkDemandSetParam(ScpDemandSetSaveVO saveVO) {
        ScpDemandSetParamVO paramVO = ScpDemandSetParamVO.builder().demandName(saveVO.getDemandName()).build();
        boolean exist = this.scpDemandSetDomainService.findDemandSetByParam(paramVO).stream().anyMatch(demandSetDTO -> !demandSetDTO.getId().equals(saveVO.getId()));
        if (exist) {
            throw new BusinessException("\u8ba2\u8d27\u96c6\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (saveVO.getId() == null) {
            return;
        }
        List<ScpDemandOrderRespVO> demandOrderRespVO = this.scpDemandOrderService.findDemandOrderByDemandIds(List.of(saveVO.getId()));
        if (CollUtil.isNotEmpty(demandOrderRespVO)) {
            throw new BusinessException("\u8ba2\u8d27\u96c6:" + saveVO.getDemandName() + "\u5df2\u88ab\u8ba2\u8d27\u8ba2\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u7f16\u8f91");
        }
    }

    private String orderSetNo(String type) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type)) {
            return this.rmiSysUserRpcService.sysNumberRuleGenerateCode("BKST", new ArrayList<String>());
        }
        return this.rmiSysUserRpcService.sysNumberRuleGenerateCode("BKWH", new ArrayList<String>());
    }

    public ScpDemandOrderSetServiceImpl(RedisTemplate redisTemplate, RmiSysUserRpcService rmiSysUserRpcService, TransactionCommitHandler transactionCommitHandler, ScpDemandOrderService scpDemandOrderService, MessageQueueTemplate messageQueueTemplate, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpDemandSetDomainService scpDemandSetDomainService, ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, TaskExecutor taskExecutor, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiSysUDCService rmiSysUDCService, TaskExecutor executor, EmployeeRpcService employeeRpcService, SysUserPermissionRpcService sysUserPermissionRpcService, DingDingRpcService dingDingRpcService, SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService) {
        this.redisTemplate = redisTemplate;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.transactionCommitHandler = transactionCommitHandler;
        this.scpDemandOrderService = scpDemandOrderService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpDemandSetDomainService = scpDemandSetDomainService;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.taskExecutor = taskExecutor;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.executor = executor;
        this.employeeRpcService = employeeRpcService;
        this.sysUserPermissionRpcService = sysUserPermissionRpcService;
        this.dingDingRpcService = dingDingRpcService;
        this.sysMsgTemplateSendRpcService = sysMsgTemplateSendRpcService;
    }
}

