/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.boh;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.boh.StoreAppletHomeVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreTodoVO;
import com.elitesland.scp.application.service.boh.StoreAppletService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u9996\u9875"})
@RestController
@RequestMapping(value={"/applet/home"}, produces={"application/json"})
public class AppletHomeController {
    private static final Logger log = LoggerFactory.getLogger(AppletHomeController.class);
    private final StoreAppletService storeAppletService;

    @ApiOperation(value="\u9996\u9875\u67e5\u8be2")
    @GetMapping(value={"/detail"})
    public ApiResult<StoreAppletHomeVO> detail(@RequestParam(value="storeId") Long storeId, @RequestParam(value="startDate") String startDate, @RequestParam(value="demandWhStCode") String demandWhStCode, @RequestParam(value="type") String type) {
        LocalDateTime parse = LocalDateTimeUtil.parse((CharSequence)startDate, (String)"yyyy-MM-dd");
        StoreAppletHomeVO storeAppletHomeVO = this.storeAppletService.find(storeId, parse, demandWhStCode, type);
        return ApiResult.ok((Object)storeAppletHomeVO);
    }

    @ApiOperation(value="\u5f85\u529e\u6570\u6807")
    @PostMapping(value={"/todoCount"})
    public ApiResult<StoreTodoVO> todoCount(@RequestBody StoreReceivePageParam param) {
        StoreTodoVO storeTodoVO = this.storeAppletService.todo(param);
        return ApiResult.ok((Object)storeTodoVO);
    }

    @ApiOperation(value="\u6536\u8d27\u6570\u6807")
    @PostMapping(value={"/receiveTotal"})
    public ApiResult<StoreReceiveTotalVO> receiveTotal(@RequestBody StoreReceivePageParam param) {
        StoreReceiveTotalVO storeReceiveTotalVO = this.storeAppletService.receiveTotal(param);
        return ApiResult.ok((Object)storeReceiveTotalVO);
    }

    @ApiOperation(value="\u9000\u8d27\u6570\u6807")
    @PostMapping(value={"/rtnCount"})
    public ApiResult<StoreRtnTotalVO> rtnCount(@RequestBody StoreReceivePageParam param) {
        StoreRtnTotalVO storeRtnTotalVO = this.storeAppletService.rtnCount(param);
        return ApiResult.ok((Object)storeRtnTotalVO);
    }

    public AppletHomeController(StoreAppletService storeAppletService) {
        this.storeAppletService = storeAppletService;
    }
}

