package com.elitesland.scp.domain.convert.order;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.fin.dto.account.ScpDemandOrderTitlePageRespRpcVO;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoPayRpcDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScpDemandOrderConvert {
    ScpDemandOrderConvert INSTANCE = Mappers.getMapper(ScpDemandOrderConvert.class);

    ScpDemandOrderRespVO dtoToRespVO(ScpDemandOrderDTO orderDTO);

    ScpDemandOrderDTO doToDto(ScpDemandOrderDO orderDO);

    ScpDemandOrderDO saveVoToDO(ScpDemandOrderSaveVO saveVO);

    ScpDemandOrderSaveVO submitVoToSaveVO(ScpDemandOrderSubmitVO submitVO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(ScpDemandOrderSaveVO saveVO, @MappingTarget ScpDemandOrderDO intentDO);

    List<ScpOrderPayRespVO.PayItem> troDtosToRespVOS(List<InvTroPayRpcDTO> troPayList);

    List<ScpOrderPayRespVO.PayItem> purDtosToRespVOS(List<PurPoPayRpcDTO> purPoPayRpcDTOList);

    PagingVO<ScpDemandOrderTitlePageRespRpcVO> pageToRpcPage(PagingVO<ScpDemandOrderTitlePageRespVO> page);
}
