package com.elitesland.scp.domain.entity.authority;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "scpsman_authority")
@org.hibernate.annotations.Table(appliesTo = "scpsman_authority", comment = "计划员权限分配")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "计划员权限分配", description = "计划员权限分配")
@Where(clause = "delete_flag = 0")
public class ScpsmanAuthorityDO extends BaseModel implements Serializable {

    /** 计划员id */
    @ApiModelProperty(name = "计划员id")
    @Comment("计划员id")
    @Column
    private Long scpsmanId ;

    /** 计划员编码 */
    @ApiModelProperty(name = "计划员编码")
    @Comment("计划员编码")
    @Column
    private String scpsmanNo ;

    /** 公司id */
    @ApiModelProperty(name = "公司id")
    @Comment("公司id")
    @Column
    private Long ouId ;

    /** 公司名称 */
    @ApiModelProperty(name = "公司名称")
    @Comment("公司名称")
    @Column
    private String ouName ;

    /** 公司编码 */
    @ApiModelProperty(name = "公司编码")
    @Comment("公司编码")
    @Column
    private String ouCode ;

    /** 启用状态 */
    @ApiModelProperty(name = "启用状态")
    @Comment("启用状态")
    @Column
    private Boolean enableStatus ;

    /** 所属租户ID */
    @ApiModelProperty(name = "所属租户ID")
    @Comment("所属租户ID")
    @Column
    private Long tenantId ;

    /** 所属组织ID */
    @ApiModelProperty(name = "所属组织ID")
    @Comment("所属组织ID")
    @Column
    private Long belongOrgId ;

    /** 租户组织ID */
    @ApiModelProperty(name = "租户组织ID")
    @Comment("租户组织ID")
    @Column
    private Long tenantOrgId ;

    /** 备注 */
    @ApiModelProperty(name = "备注")
    @Comment("备注")
    @Column
    private String remark ;

    /** 公司所属组织id */
    @ApiModelProperty(name = "公司所属组织id")
    @Comment("公司所属组织id")
    @Column
    private Long orgIdBelong ;

}
