package com.elitesland.scp.infr.repo.feedback;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.domain.entity.feedback.QScpStoreFeedbackDO;
import org.springframework.util.StringUtils;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.val;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2025-09-23 18:26:14
 */
@Component
@RequiredArgsConstructor
public class ScpStoreFeedbackRepoProc {

     private final JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段
     *
     */ 
    public  JPAQuery<ScpStoreFeedbackRespVO> select(ScpStoreFeedbackQueryParamVO param){
        QScpStoreFeedbackDO jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        Predicate predicate = jpaQDo.isNotNull();
        JPAQuery<ScpStoreFeedbackRespVO> jpaQuery=jpaQueryFactory.select(Projections.bean(ScpStoreFeedbackRespVO.class,
                jpaQDo.id, 
                jpaQDo.feedbackType, 
                jpaQDo.feedbackReason, 
                jpaQDo.feedbackStoreCode, 
                jpaQDo.feedbackStoreName, 
                jpaQDo.itemCode, 
                jpaQDo.itemName, 
                jpaQDo.feedbackScore, 
                jpaQDo.evaluationComment, 
                jpaQDo.optimizationSuggestion, 
                jpaQDo.fileCode, 
                jpaQDo.fileUrl, 
                jpaQDo.approvalStatus, 
                jpaQDo.feedbackTime, 
                jpaQDo.feedbackBy, 
                jpaQDo.approvedBy, 
                jpaQDo.approvalTime, 
                jpaQDo.tenantId, 
                jpaQDo.remark, 
                jpaQDo.createUserId, 
                jpaQDo.creator, 
                jpaQDo.createTime, 
                jpaQDo.modifyUserId, 
                jpaQDo.updater, 
                jpaQDo.modifyTime, 
                jpaQDo.deleteFlag, 
                jpaQDo.auditDataVersion, 
                jpaQDo.secBuId, 
                jpaQDo.secUserId, 
                jpaQDo.secOuId, 
                jpaQDo.belongOrgId, 
                jpaQDo.tenantOrgId
                )).from(jpaQDo);
        if(param != null){
           jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate,jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }
     /**
     * 根据主键查询
     *
     * @param  id 主键
     */ 
    public Predicate where(Long id) {
        val jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
                Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }

    public void update(ScpStoreFeedbackRespVO param) {
        val jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.feedbackStatus, param.getFeedbackStatus())
                .set(jpaQDo.approvalStatus, param.getApprovalStatus())
                .set(jpaQDo.procInstStatus, param.getProcInstStatus())
                .set(jpaQDo.remark, param.getRemark())
                .set(jpaQDo.approvedBy, param.getApprovedBy())
                .set(jpaQDo.approvalTime, param.getApprovalTime())
                .where(jpaQDo.id.eq(param.getId()))
                .execute();
    }
   /**
     * 条件查询
     *
     * @param  param 查询条件
     */ 
    public Predicate where(ScpStoreFeedbackQueryParamVO param) {
        val jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
                Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
          if (!StringUtils.isEmpty(param.getId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
          }
          if (!StringUtils.isEmpty(param.getFeedbackType())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackType.eq(param.getFeedbackType()));
          }
          if (!StringUtils.isEmpty(param.getFeedbackReason())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackReason.eq(param.getFeedbackReason()));
          }
          if (!StringUtils.isEmpty(param.getFeedbackStoreCode())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackStoreCode.eq(param.getFeedbackStoreCode()));
          }
          if (!StringUtils.isEmpty(param.getFeedbackStoreName())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackStoreName.eq(param.getFeedbackStoreName()));
          }
        if (!StringUtils.isEmpty(param.getFeedbackStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackStatus.eq(param.getFeedbackStatus()));
        }
        if (!StringUtils.isEmpty(param.getFilteredFeedbackStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackStatus.ne(param.getFilteredFeedbackStatus()));
        }
          if (!StringUtils.isEmpty(param.getItemCode())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.itemCode.eq(param.getItemCode()));
          }
          if (!StringUtils.isEmpty(param.getItemName())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.itemName.eq(param.getItemName()));
          }
          if (!StringUtils.isEmpty(param.getFeedbackScore())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackScore.eq(param.getFeedbackScore()));
          }
          if (!StringUtils.isEmpty(param.getEvaluationComment())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.evaluationComment.eq(param.getEvaluationComment()));
          }
          if (!StringUtils.isEmpty(param.getOptimizationSuggestion())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.optimizationSuggestion.eq(param.getOptimizationSuggestion()));
          }
          if (!StringUtils.isEmpty(param.getFileCode())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.fileCode.eq(param.getFileCode()));
          }
          if (!StringUtils.isEmpty(param.getFileUrl())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.fileUrl.eq(param.getFileUrl()));
          }
          if (!StringUtils.isEmpty(param.getApprovalStatus())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.approvalStatus.eq(param.getApprovalStatus()));
          }
//          if (!StringUtils.isEmpty(param.getFeedbackTime())) {
//          predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackTime.eq(param.getFeedbackTime()));
//          }
          if (!StringUtils.isEmpty(param.getFeedbackBy())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.feedbackBy.eq(param.getFeedbackBy()));
          }
          if (!StringUtils.isEmpty(param.getApprovedBy())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.approvedBy.eq(param.getApprovedBy()));
          }
//          if (!StringUtils.isEmpty(param.getApprovalTime())) {
//          predicate = ExpressionUtils.and(predicate, jpaQDo.approvalTime.eq(param.getApprovalTime()));
//          }
          if (!StringUtils.isEmpty(param.getTenantId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
          }
          if (!StringUtils.isEmpty(param.getRemark())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
          }
          if (!StringUtils.isEmpty(param.getCreateUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
          }
          if (!StringUtils.isEmpty(param.getCreator())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.creator.eq(param.getCreator()));
          }
          if (!StringUtils.isEmpty(param.getCreateTime())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.eq(param.getCreateTime()));
          }
          if(!StringUtils.isEmpty(param.getCreateTimeStart())){
              predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.goe(param.getCreateTimeStart()));
          }
          if(!StringUtils.isEmpty(param.getCreateTimeEnd())){
              predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.loe(param.getCreateTimeEnd()));
          }
        if(!StringUtils.isEmpty(param.getItemType2())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemType2.eq(param.getItemType2()));
        }
          if (!StringUtils.isEmpty(param.getModifyUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
          }
          if (!StringUtils.isEmpty(param.getUpdater())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.updater.eq(param.getUpdater()));
          }
          if (!StringUtils.isEmpty(param.getModifyTime())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.modifyTime.eq(param.getModifyTime()));
          }
          if (!StringUtils.isEmpty(param.getDeleteFlag())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
          }
          if (!StringUtils.isEmpty(param.getAuditDataVersion())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
          }
          if (!StringUtils.isEmpty(param.getSecBuId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secBuId.eq(param.getSecBuId()));
          }
          if (!StringUtils.isEmpty(param.getSecUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secUserId.eq(param.getSecUserId()));
          }
          if (!StringUtils.isEmpty(param.getSecOuId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secOuId.eq(param.getSecOuId()));
          }
          if (!StringUtils.isEmpty(param.getBelongOrgId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.belongOrgId.eq(param.getBelongOrgId()));
          }
          if (!StringUtils.isEmpty(param.getTenantOrgId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.tenantOrgId.eq(param.getTenantOrgId()));
          }
         return predicate;
    }
}

