/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.job.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.job.service.ScpDemandOrderCloseJobService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpDemandOrderCloseJobServiceImpl
implements ScpDemandOrderCloseJobService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderCloseJobServiceImpl.class);
    private final MessageDelyQueueService delyQueueService;
    private final ScpDemandOrderService scpDemandOrderService;

    @Override
    public void autoCloseDemandOrder() {
        log.info("\u8ba2\u8d27\u5355\u5ef6\u65f6\u961f\u5217\u626b\u63cf\u5df2\u542f\u52a8,\u542f\u52a8\u65f6\u95f4:{}", (Object)LocalDateTime.now());
        StringBuilder flag = new StringBuilder();
        String message = this.delyQueueService.pull();
        if (StrUtil.isNotEmpty((CharSequence)message) && this.delyQueueService.remove(message).booleanValue()) {
            log.info("\u6d88\u8d39\u6d88\u606f\uff1a{}:\u6d88\u606f\u521b\u5efa\u65f6\u95f4\uff1a{},\u6d88\u8d39\u65f6\u95f4\uff1a{}", (Object)message, (Object)LocalDateTime.now());
            String[] split = message.split(":");
            int length = split.length;
            this.handleMessage(split[length - 1]);
            flag.append("S");
        }
    }

    public void handleMessage(String message) {
        try {
            log.info("consumer message:{},date:{}", (Object)message, (Object)DateUtil.now());
            this.scpDemandOrderService.closePoOrTro(message);
            log.info("\u8ba2\u8d27\u5355\uff1a{} \u5ef6\u65f6\u5173\u95ed\u6210\u529f", (Object)message);
        }
        catch (Exception e) {
            log.error("\u8ba2\u8d27\u5355\u5ef6\u65f6\u5173\u95ed\u8ba2\u5355\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public ScpDemandOrderCloseJobServiceImpl(MessageDelyQueueService delyQueueService, ScpDemandOrderService scpDemandOrderService) {
        this.delyQueueService = delyQueueService;
        this.scpDemandOrderService = scpDemandOrderService;
    }
}

