package com.elitesland.scp.job.service;

import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.application.service.order.ScpOrderTemplateService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandSetConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandSetDO;
import com.elitesland.scp.domain.entity.order.ScpOrderTemplateDO;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.infr.repo.freight.ScpStoreOrderFreightRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandSetRepo;
import com.elitesland.scp.infr.repo.order.ScpOrderTemplateRepo;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.SysUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandSetJobServiceImpl implements ScpDemandSetJobService {

    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpStoreDemandCalendarService scpStoreDemandCalendarService;
    private final ScpOrderTemplateService orderTemplateService;
    private final ScpOrderTemplateRepo scpOrderTemplateRepo;
    private final ScpDemandSetRepo scpDemandSetRepo;


    private final SysSettingService sysSettingService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoCreateDemandSet() {
        ScpCalendarStoreQueryParamVO paramVO = new ScpCalendarStoreQueryParamVO();
        paramVO.setWorkStatus(ScpUdcEnum.CALENDAR_WORK_STATUS_W.getValueCode());
        paramVO.setFindDate(LocalDate.now());
        Boolean isExist = scpStoreDemandCalendarService.isExistStoreByDateAndWorkStatus(paramVO);
        if (!isExist) {
            return;
        }
        LocalDate demandDate = LocalDate.now();
        List<ScpDemandSetDO> setDOS = scpDemandSetRepo.findByDemandDate(demandDate.atStartOfDay());
        if (CollectionUtils.isNotEmpty(setDOS)){
            log.info("订货集已生成，无需重复生成");
            return;
        }

        List<ScpOrderTemplateDO> templateDOS = scpOrderTemplateRepo.findByIsActive(1);
//        注意生成的数据的顺序要满足查询时的以下条件
//        优先级一：类型+单据类型+门店+下单时间 早于 订单截单时间；
//        优先级二：类型+单据类型+区域+下单时间 早于 订单截单时间；
//        优先级三：类型+单据类型+门店/区域=ALL+下单时间 早于 订单截单时间；

        ArrayList<ScpDemandSetDO> scpDemandSetDOS = new ArrayList<>();
        int times = SysUtils.getAutoOrderSetNumSetting();

        templateDOS.forEach(template->{
            if (!demandDate.isBefore(template.getStartDate()) && !demandDate.isAfter(template.getEndDate())){
                String bkst=null;
                if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(template.getType())){
                     bkst = ScpConstant.BKST;
                }else {
                     bkst = ScpConstant.BKWH;
                }
                for (int n = 0; n < times; n++) {
                    String storeDemandCode = rmiSysUserRpcService.sysNumberRuleGenerateCode(bkst, new ArrayList<>());
                    ScpDemandSetDO demandSetSaveVO = new ScpDemandSetDO();
                    demandSetSaveVO.setDemandCode(storeDemandCode);
                    demandSetSaveVO.setType(template.getType());
                    demandSetSaveVO.setDemandDate(demandDate.atStartOfDay());
                    demandSetSaveVO.setDemandName(ScpConstant.MDDHJ + convertDate(demandDate.atStartOfDay()) + storeDemandCode.substring(storeDemandCode.length() - 3));
                    demandSetSaveVO.setExpireTime(LocalDateTime.of(demandDate.atStartOfDay().toLocalDate(), template.getDeadlineTime()));
                    demandSetSaveVO.setStoreName(template.getStoreName());
                    demandSetSaveVO.setStoreCode(template.getStoreCode());
                    demandSetSaveVO.setRegionCode(template.getRegionCode());
                    demandSetSaveVO.setDocType(template.getDocType());
                    demandSetSaveVO.setCreateType(UdcEnum.SCP_ORDER_SET_CREATE_TYPE_01.getValueCode());
                    scpDemandSetDOS.add(demandSetSaveVO);
                }
            }
        });
        // 按storeCode不为空的排在前面，再按regionCode排序
        scpDemandSetDOS.sort(new Comparator<ScpDemandSetDO>() {
            @Override
            public int compare(ScpDemandSetDO o1, ScpDemandSetDO o2) {
                // 获取两个对象的storeCode
                String storeCode1 = o1.getStoreCode();
                String storeCode2 = o2.getStoreCode();

                // 检查storeCode是否为空
                boolean isEmpty1 = storeCode1 == null || storeCode1.trim().isEmpty();
                boolean isEmpty2 = storeCode2 == null || storeCode2.trim().isEmpty();

                // 处理storeCode为空的情况：非空值排在前面
                if (isEmpty1 && !isEmpty2) {
                    return 1; // o1为空，o2非空，o1排在后面
                } else if (!isEmpty1 && isEmpty2) {
                    return -1; // o1非空，o2为空，o1排在前面
                }
                return -1;
            }
        });
        scpDemandSetRepo.saveAll(scpDemandSetDOS);
        // 保存订货集(门店+仓库) 只生成1天
//        for (int i = 0; i < 1; i++) {
        //查询是否存在订货集
//        var scpDemandSetDTOList = scpDemandSetDomainService.findDemandSetByParam(ScpDemandSetParamVO.builder().demandDate(demandDate.atStartOfDay()).build());
//        Optional<ScpDemandSetDTO> storeType = scpDemandSetDTOList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).findAny();
//        Optional<ScpDemandSetDTO> whType = scpDemandSetDTOList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType())).findAny();
        for (int n = 0; n < times; n++) {
            String storeDemandCode = rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.BKST, new ArrayList<>());
            saveDemandSet(demandDate.atStartOfDay(), storeDemandCode, ScpUdcEnum.DEMAND_SET_TYPE_0, ScpConstant.MDDHJ);
        }
        for (int n = 0; n < times; n++) {
            String whDemandCode = rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.BKWH, new ArrayList<>());
            saveDemandSet(demandDate.atStartOfDay(), whDemandCode, ScpUdcEnum.DEMAND_SET_TYPE_1, ScpConstant.CKDHJ);
        }

    }

    /**
     * 保存订货集
     *
     * @param demandCode   需求编码
     * @param demandType   需求类型
     * @param demandPrefix 需求前缀
     */
    private void saveDemandSet(LocalDateTime demandDate, String demandCode, ScpUdcEnum demandType, String demandPrefix) {
        ScpDemandSetSaveVO demandSetSaveVO = new ScpDemandSetSaveVO();
        demandSetSaveVO.setDemandCode(demandCode);
        demandSetSaveVO.setType(demandType.getValueCode());
        demandSetSaveVO.setDemandName(demandPrefix + convertDate(demandDate) + demandCode.substring(demandCode.length() - 3));
        demandSetSaveVO.setDemandDate(demandDate);
        demandSetSaveVO.setCreateType(UdcEnum.SCP_ORDER_SET_CREATE_TYPE_01.getValueCode());
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.equals(demandType)){
            demandSetSaveVO.setDocType("all");
            demandSetSaveVO.setStoreName("all");
            demandSetSaveVO.setStoreCode("all");
            demandSetSaveVO.setRegionCode("all");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        demandSetSaveVO.setExpireTime(LocalDateTime.of(demandDate.toLocalDate(), LocalTime.parse("16:00:00", formatter)));
        scpDemandSetDomainService.saveDemandSet(demandSetSaveVO);
    }

    /**
     * 格式化日期
     *
     * @return
     */
    private String convertDate(LocalDateTime demandDate) {
        // 定义日期格式
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy年M月d号");
        // 格式化日期
        return demandDate.format(formatter);
    }
}
