/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingBrandSaveVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingItemSaveVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingRegionSaveVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingStoreSaveVO;
import com.elitesland.scp.application.service.alloc.ScpAllocSettingService;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingDO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingBrandDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingRegionDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRepo;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.dto.SpuImageDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBasePageRpcParam;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpAllocSettingServiceImpl
implements ScpAllocSettingService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingServiceImpl.class);
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpAllocSettingDomainService scpAllocSettingDomainService;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final ScpAllocSettingRegionDomainService scpAllocSettingRegionDomainService;
    private final ScpAllocSettingBrandDomainService scpAllocSettingBrandDomainService;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RedisTemplate redisClient;
    private final ScpAllocSettingRepo scpAllocSettingRepo;
    private final RmiItemService rmiItemService;

    @Override
    public PagingVO<ScpAllocSettingPageRespVO> page(ScpAllocSettingPageParamVO paramVO) {
        HashSet<Long> masIds = new HashSet<Long>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getRegion())) {
            List<Long> regionMasIds = this.scpAllocSettingRegionDomainService.findMasIdByRegionCode(paramVO.getRegion());
            if (CollUtil.isEmpty(regionMasIds)) {
                return new PagingVO();
            }
            masIds.addAll(regionMasIds);
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
            List<Long> brandMasIds = this.scpAllocSettingBrandDomainService.findMasIdByBrand(paramVO.getBrand());
            if (CollUtil.isEmpty(brandMasIds)) {
                return new PagingVO();
            }
            this.intersectSets(masIds, brandMasIds);
        }
        if (paramVO.getStoreCode() != null) {
            List<Long> storeMasIds = this.scpAllocSettingStoreDomainService.findMasIdByStoreCode(paramVO.getStoreCode());
            if (CollUtil.isEmpty(storeMasIds)) {
                return new PagingVO();
            }
            this.intersectSets(masIds, storeMasIds);
        }
        if (paramVO.getItemId() != null) {
            List<Long> itemMasIds = this.scpAllocSettingItemDomainService.findMasIdByItemId(paramVO.getItemId());
            if (CollUtil.isEmpty(itemMasIds)) {
                return new PagingVO();
            }
            this.intersectSets(masIds, itemMasIds);
        }
        paramVO.setIds(new ArrayList<Long>(masIds));
        return this.scpAllocSettingDomainService.queryAllocSettingList(paramVO);
    }

    @Override
    @SysCodeProc
    public ScpAllocSettingRespVO findAllocSettingById(Long id) {
        Optional<ScpAllocSettingRespVO> scpAllocSettingRespVO = this.scpAllocSettingDomainService.findAllocSettingById(id).map(ScpAllocSettingConvert.INSTANCE::dtoToRespVO);
        if (scpAllocSettingRespVO.isPresent()) {
            ScpAllocSettingRespVO allocSettingRespVO = scpAllocSettingRespVO.get();
            allocSettingRespVO.setAllStoreFlag(Boolean.FALSE);
            allocSettingRespVO.setItemRespVOList(this.scpAllocSettingItemDomainService.findByMasId(id));
            allocSettingRespVO.setBrandRespVOList(this.scpAllocSettingBrandDomainService.findByMasId(id));
            allocSettingRespVO.setRegionRespVOList(this.scpAllocSettingRegionDomainService.findByMasId(id));
            allocSettingRespVO.setStoreRespVOList(this.scpAllocSettingStoreDomainService.findByMasId(id));
            if (StrUtil.isNotBlank((CharSequence)allocSettingRespVO.getDocType())) {
                allocSettingRespVO.setDocTypes(StrUtil.split((CharSequence)allocSettingRespVO.getDocType(), (char)','));
            }
            return allocSettingRespVO;
        }
        return new ScpAllocSettingRespVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveAllocSetting(ScpAllocSettingSaveVO saveVO) {
        ScpAllocSettingServiceImpl.checkParam(saveVO);
        if (saveVO.getId() == null) {
            if (CollUtil.isEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
                throw new BusinessException("\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String orderNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("FA", new ArrayList<String>());
            saveVO.setActivityCode(orderNo);
        } else {
            ScpAllocSettingStoreParamVO scpAllocSettingStoreParamVO = new ScpAllocSettingStoreParamVO();
            scpAllocSettingStoreParamVO.setMasIds(List.of(saveVO.getId()));
            scpAllocSettingStoreParamVO.setUsed(Boolean.TRUE);
            List<ScpAllocSettingStoreRespVO> byParam = this.scpAllocSettingStoreDomainService.findByParam(scpAllocSettingStoreParamVO);
            if (CollUtil.isNotEmpty(byParam)) {
                throw new BusinessException("\u6d3b\u52a8\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
        }
        Long masId = this.scpAllocSettingDomainService.saveAllocSetting(saveVO);
        this.scpAllocSettingItemDomainService.deleteByMasId(masId);
        this.scpAllocSettingBrandDomainService.deleteByMasId(masId);
        this.scpAllocSettingRegionDomainService.deleteByMasId(masId);
        saveVO.getRegionList().forEach(row -> row.setMasId(masId));
        this.scpAllocSettingRegionDomainService.batchSaveAllocSettingRegion(saveVO.getRegionList());
        List itemCodes = saveVO.getItemList().stream().map(ScpAllocSettingItemSaveVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodes);
        List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
        saveVO.getItemList().forEach(row -> {
            row.setMasId(masId);
            if (itemRpcDTOMap.containsKey(row.getItemCode())) {
                row.setItemId(((ItmItemRpcDTO)itemRpcDTOMap.get(row.getItemCode())).getId());
            }
        });
        this.scpAllocSettingItemDomainService.batchSaveAllocSettingItem(saveVO.getItemList());
        saveVO.getBrandList().forEach(row -> row.setMasId(masId));
        this.scpAllocSettingBrandDomainService.batchSaveAllocSettingBrand(saveVO.getBrandList());
        this.scpAllocSettingStoreDomainService.deleteByMasId(masId);
        if (CollUtil.isNotEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
            saveVO.getStoreList().forEach(row -> {
                row.setMasId(masId);
                row.setId(null);
            });
            this.scpAllocSettingStoreDomainService.batchSaveAllocSettingStore(saveVO.getStoreList());
            this.refreshRedisValue(saveVO, masId, saveVO.getStoreList(), itemRpcDTOMap);
        }
        if (CollUtil.isEmpty(saveVO.getStoreList()) && saveVO.getAllStoreFlag().booleanValue()) {
            this.saveDefaultStore(saveVO, masId, itemRpcDTOMap);
        }
        String key = "SCP:ALLOC:SETTING:" + masId;
        if (LocalDateTime.now().compareTo(saveVO.getValidTo()) <= 0) {
            long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), saveVO.getValidTo());
            this.redisClient.opsForValue().set((Object)key, (Object)saveVO.getValidFrom(), between, TimeUnit.MINUTES);
        }
        this.scpAllocSettingDomainService.enableAllocSetting(List.of(masId), Boolean.TRUE);
        return masId;
    }

    private void refreshRedisValue(ScpAllocSettingSaveVO saveVO, Long masId, List<ScpAllocSettingStoreSaveVO> storeList, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
        ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO>();
        for (ScpAllocSettingItemSaveVO item : saveVO.getItemList()) {
            ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpAllocSettingRedisDO.ActivityDO.InnerItemDO();
            innerItemDO.setItemCode(item.getItemCode());
            innerItemDO.setMasId(masId);
            innerItemDO.setMinNum(item.getMinNum());
            innerItemDO.setItemType2(item.getItemType2());
            if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = itemRpcDTOMap.get(item.getItemCode());
                List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                    Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                    innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                }
                innerItemDO.setItemId(itmItemRpcDTO.getId());
                innerItemDO.setItemName(itmItemRpcDTO.getItemName());
            }
            innerItemDOS.add(innerItemDO);
        }
        for (ScpAllocSettingStoreSaveVO store : storeList) {
            ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
            Object obj = this.redisClient.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + store.getStoreCode()));
            if (obj == null) {
                ScpAllocSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                scpAllocSettingRedisDO.setActivityList(List.of(activityDO1));
            } else {
                String str = (String)obj;
                ScpAllocSettingRedisDO setting = (ScpAllocSettingRedisDO)JSON.parseObject((String)str, ScpAllocSettingRedisDO.class);
                List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
                Boolean flag = Boolean.FALSE;
                for (ScpAllocSettingRedisDO.ActivityDO inActivityDO : activityList) {
                    if (!inActivityDO.getActivityId().equals(masId)) continue;
                    inActivityDO.setActivityId(masId);
                    inActivityDO.setActivityCode(saveVO.getActivityCode());
                    inActivityDO.setDocTypes(saveVO.getDocTypes());
                    inActivityDO.setMaxNum(store.getMaxNum());
                    inActivityDO.setAllocNum(0);
                    inActivityDO.setValidTo(saveVO.getValidTo());
                    inActivityDO.setValidFrom(saveVO.getValidFrom());
                    inActivityDO.setInnerItemDOS(innerItemDOS);
                    flag = Boolean.TRUE;
                }
                if (!flag.booleanValue()) {
                    ScpAllocSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                    activityList.add(activityDO1);
                }
                scpAllocSettingRedisDO.setActivityList(activityList);
            }
            String key = "SCP:ALLOC:SETTING:" + store.getStoreCode();
            redisMap.put((CallSite)((Object)key), JSONUtil.toJsonStr((Object)scpAllocSettingRedisDO));
        }
        this.redisClient.opsForValue().multiSet(redisMap);
    }

    private ScpAllocSettingRedisDO.ActivityDO createActivityDO(Long masId, ScpAllocSettingSaveVO saveVO, ScpAllocSettingStoreSaveVO store, List<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS) {
        ScpAllocSettingRedisDO.ActivityDO activityDO = new ScpAllocSettingRedisDO.ActivityDO();
        activityDO.setInnerItemDOS(innerItemDOS);
        activityDO.setActivityId(masId);
        activityDO.setActivityCode(saveVO.getActivityCode());
        activityDO.setDocTypes(saveVO.getDocTypes());
        activityDO.setMaxNum(store.getMaxNum());
        activityDO.setAllocNum(0);
        activityDO.setValidFrom(saveVO.getValidFrom());
        activityDO.setValidTo(saveVO.getValidTo());
        return activityDO;
    }

    private void saveDefaultStore(ScpAllocSettingSaveVO saveVO, Long masId, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        if (saveVO.getMaxAllocNum() == null) {
            throw new BusinessException("\u6700\u5927\u5f3a\u914d\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List regionList = saveVO.getRegionList().stream().map(ScpAllocSettingRegionSaveVO::getRegion).distinct().collect(Collectors.toList());
        List brandList = saveVO.getBrandList().stream().map(ScpAllocSettingBrandSaveVO::getBrand).distinct().collect(Collectors.toList());
        OrgStoreBasePageRpcParam orgStoreBasePageRpcParam = new OrgStoreBasePageRpcParam();
        orgStoreBasePageRpcParam.setRegionList(regionList);
        orgStoreBasePageRpcParam.setBrandCodeList(brandList);
        if (CollUtil.isEmpty(regionList) || CollUtil.isEmpty(brandList)) {
            log.info("saveDefaultStore\u54c1\u724c\u6216\u8005\u533a\u57df\u4e3a\u7a7a");
            return;
        }
        Long count = this.rmiOrgStoreRpcService.countBaseStoreByParam(orgStoreBasePageRpcParam);
        if (count == null || count == 0L) {
            log.info("saveDefaultStore\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u95e8\u5e97\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        Integer totalPage = PageUtil.totalPage((long)count, (int)1000);
        for (int i = 1; i <= totalPage; ++i) {
            orgStoreBasePageRpcParam.setSize(Integer.valueOf(1000));
            orgStoreBasePageRpcParam.setCurrent(Integer.valueOf(i));
            PagingVO<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOPagingVO = this.rmiOrgStoreRpcService.queryBaseStore(orgStoreBasePageRpcParam);
            List<ScpAllocSettingStoreSaveVO> storeSaveVOS = orgStoreBaseRpcDTOPagingVO.getRecords().stream().map(row -> {
                ScpAllocSettingStoreSaveVO scpAllocSettingStoreSaveVO = new ScpAllocSettingStoreSaveVO();
                scpAllocSettingStoreSaveVO.setStoreId(row.getId());
                scpAllocSettingStoreSaveVO.setStoreCode(row.getStoreCode());
                scpAllocSettingStoreSaveVO.setStoreName(row.getStoreName());
                scpAllocSettingStoreSaveVO.setStoreType2(row.getStoreType2());
                scpAllocSettingStoreSaveVO.setMasId(masId);
                scpAllocSettingStoreSaveVO.setMaxNum(saveVO.getMaxAllocNum());
                return scpAllocSettingStoreSaveVO;
            }).collect(Collectors.toList());
            this.scpAllocSettingStoreDomainService.batchSaveAllocSettingStore(storeSaveVOS, 1000);
            this.refreshRedisValue(saveVO, masId, storeSaveVOS, itemRpcDTOMap);
        }
    }

    private static void checkParam(ScpAllocSettingSaveVO saveVO) {
        if (CollUtil.isEmpty(saveVO.getBrandList())) {
            throw new BusinessException("\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(saveVO.getRegionList())) {
            throw new BusinessException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(saveVO.getItemList())) {
            throw new BusinessException("\u5f3a\u914d\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpAllocSettingDomainService.deleteByIds(ids);
        List keys = ids.stream().map(row -> "SCP:ALLOC:SETTING:" + row).collect(Collectors.toList());
        this.redisClient.delete(keys);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeAllocSettingStatus(ScpAllocSettingStatusParamVO paramVO) {
        if (Boolean.TRUE.equals(paramVO.getStatus())) {
            ScpAllocSettingStoreParamVO scpAllocSettingStoreParamVO = new ScpAllocSettingStoreParamVO();
            scpAllocSettingStoreParamVO.setMasIds(paramVO.getIds());
            List<ScpAllocSettingStoreRespVO> storeRespVOList = this.scpAllocSettingStoreDomainService.findByParam(scpAllocSettingStoreParamVO);
            if (CollUtil.isEmpty(storeRespVOList)) {
                throw new BusinessException("\u95e8\u5e97\u4fe1\u606f\u672a\u7ef4\u62a4");
            }
            List<ScpAllocSettingDO> settingDOS = this.scpAllocSettingRepo.findByIdIn(paramVO.getIds());
            for (ScpAllocSettingDO settingDO : settingDOS) {
                String key = "SCP:ALLOC:SETTING:" + settingDO.getId();
                if (LocalDateTime.now().compareTo(settingDO.getValidTo()) > 0) continue;
                long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), settingDO.getValidTo());
                this.redisClient.opsForValue().set((Object)key, (Object)settingDO.getValidFrom(), between, TimeUnit.MINUTES);
                List<ScpAllocSettingItemRespVO> itemList = this.scpAllocSettingItemDomainService.findByMasId(settingDO.getId());
                List itemCodes = itemList.stream().map(ScpAllocSettingItemRespVO::getItemCode).distinct().collect(Collectors.toList());
                ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
                Map itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
                ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO>();
                for (ScpAllocSettingItemRespVO item : itemList) {
                    ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpAllocSettingRedisDO.ActivityDO.InnerItemDO();
                    innerItemDO.setItemCode(item.getItemCode());
                    innerItemDO.setMasId(settingDO.getId());
                    innerItemDO.setMinNum(item.getMinNum());
                    innerItemDO.setItemType2(item.getItemType2());
                    if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                        ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemRpcDTOMap.get(item.getItemCode());
                        List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                        if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                            Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                            innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                        }
                        innerItemDO.setItemId(itmItemRpcDTO.getId());
                        innerItemDO.setItemName(itmItemRpcDTO.getItemName());
                    }
                    innerItemDOS.add(innerItemDO);
                }
                HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
                for (ScpAllocSettingStoreRespVO store : storeRespVOList) {
                    ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
                    Object obj = this.redisClient.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + store.getStoreCode()));
                    if (obj != null) continue;
                    ScpAllocSettingRedisDO.ActivityDO activityDO1 = new ScpAllocSettingRedisDO.ActivityDO();
                    activityDO1.setActivityId(settingDO.getId());
                    activityDO1.setActivityCode(settingDO.getActivityCode());
                    activityDO1.setDocTypes(StrUtil.split((CharSequence)settingDO.getDocType(), (CharSequence)","));
                    activityDO1.setMaxNum(store.getMaxNum());
                    activityDO1.setAllocNum(0);
                    activityDO1.setInnerItemDOS(innerItemDOS);
                    scpAllocSettingRedisDO.setActivityList(List.of(activityDO1));
                    String storeKey = "SCP:ALLOC:SETTING:" + store.getStoreCode();
                    redisMap.put((CallSite)((Object)storeKey), JSONUtil.toJsonStr((Object)scpAllocSettingRedisDO));
                }
                if (!CollUtil.isNotEmpty(redisMap)) continue;
                this.redisClient.opsForValue().multiSet(redisMap);
            }
        } else {
            List keys = paramVO.getIds().stream().map(row -> "SCP:ALLOC:SETTING:" + row).collect(Collectors.toList());
            this.redisClient.delete(keys);
        }
        this.scpAllocSettingDomainService.enableAllocSetting(paramVO.getIds(), paramVO.getStatus());
    }

    private void intersectSets(Set<Long> set1, List<Long> list2) {
        if (set1.isEmpty()) {
            set1.addAll(list2);
        }
        set1.retainAll(list2);
    }

    public ScpAllocSettingServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, ScpAllocSettingDomainService scpAllocSettingDomainService, ScpAllocSettingItemDomainService scpAllocSettingItemDomainService, ScpAllocSettingRegionDomainService scpAllocSettingRegionDomainService, ScpAllocSettingBrandDomainService scpAllocSettingBrandDomainService, ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RedisTemplate redisClient, ScpAllocSettingRepo scpAllocSettingRepo, RmiItemService rmiItemService) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpAllocSettingDomainService = scpAllocSettingDomainService;
        this.scpAllocSettingItemDomainService = scpAllocSettingItemDomainService;
        this.scpAllocSettingRegionDomainService = scpAllocSettingRegionDomainService;
        this.scpAllocSettingBrandDomainService = scpAllocSettingBrandDomainService;
        this.scpAllocSettingStoreDomainService = scpAllocSettingStoreDomainService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.redisClient = redisClient;
        this.scpAllocSettingRepo = scpAllocSettingRepo;
        this.rmiItemService = rmiItemService;
    }
}

