/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.item;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemParam;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemQueryCateDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.service.ItmItemCateRpcService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpCateItemServiceImpl
implements ScpCateItemService {
    private static final Logger log = LoggerFactory.getLogger(ScpCateItemServiceImpl.class);
    private final ScpCateItemDomainService scpCateItemDomainService;
    private final RmiItemService rmiItemService;
    private final ItmItemCateRpcService itmItemCateRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindItem(ScpCateItemParam cateStoreParam) {
        Map<Long, List<String>> rootBrandMap = this.rmiItemService.findRootBrandByCateId(cateStoreParam.getCateId());
        List<String> brands = rootBrandMap.values().stream().findAny().get();
        if (CollUtil.isEmpty(brands)) {
            throw new BusinessException("\u54c1\u7c7b\u4e0b\u65e0\u54c1\u724c\u4fe1\u606f");
        }
        Long rootId = (Long)rootBrandMap.keySet().stream().findAny().get();
        String brand = String.join((CharSequence)";", brands);
        List<ScpCateItemParam.CateItem> items = cateStoreParam.getItems();
        List itemIds = items.stream().map(ScpCateItemParam.CateItem::getItemId).distinct().collect(Collectors.toList());
        ItmItemBaseRpcParam rpcParam = new ItmItemBaseRpcParam();
        rpcParam.setItemIds(itemIds);
        Map itmMap = this.rmiItemService.findItemBaseRpcDtoByParam(rpcParam).stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
        this.scpCateItemDomainService.saveBatch(items.stream().map(item -> {
            ScpCateItemDO scpCateItemDO = (ScpCateItemDO)BeanUtils.toBean((Object)item, ScpCateItemDO.class);
            if (ObjectUtils.isNotEmpty((Object)item.getItemId()) && MapUtils.isNotEmpty((Map)itmMap)) {
                ItmItemBaseRpcDTO itmItemRpcDTO = (ItmItemBaseRpcDTO)itmMap.get(item.getItemId());
                scpCateItemDO.setSpuId(itmItemRpcDTO.getSpuId());
                scpCateItemDO.setSpuCode(itmItemRpcDTO.getSpuCode());
                scpCateItemDO.setSpuName(itmItemRpcDTO.getSpuName());
                scpCateItemDO.setItemType(itmItemRpcDTO.getItemType());
                scpCateItemDO.setAnotherName(itmItemRpcDTO.getAnotherName());
                scpCateItemDO.setItemType2(itmItemRpcDTO.getItemType2());
                scpCateItemDO.setCombineItemFlag(ScpUdcEnum.ITM_ITM_TYPE_70.getValueCode().equals(itmItemRpcDTO.getItemType()));
            }
            scpCateItemDO.setCateCode(cateStoreParam.getCateCode());
            scpCateItemDO.setCateId(cateStoreParam.getCateId());
            scpCateItemDO.setBrand(brand);
            scpCateItemDO.setRootCateId(rootId);
            return scpCateItemDO;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(List<Long> ids) {
        this.scpCateItemDomainService.delete(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return this.scpCateItemDomainService.query(cateItemRpcParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        this.scpCateItemDomainService.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        return this.scpCateItemDomainService.page(paramVO);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        PagingVO<ScpCateItemPageVO> scpCateItemPage = this.scpCateItemDomainService.skuPage(paramVO);
        List<Long> itemIds = scpCateItemPage.getRecords().stream().map(ScpCateItemPageVO::getItemId).distinct().collect(Collectors.toList());
        List cateCodes = scpCateItemPage.getRecords().stream().map(ScpCateItemPageVO::getScpCateCode).collect(Collectors.toList());
        Map<Object, Object> objectObjectHashMap = new HashMap();
        this.itmItemCateRpcService.findByCode(paramVO.getScpCateCodes());
        List byCode = this.itmItemCateRpcService.findByCode(cateCodes);
        if (CollectionUtils.isNotEmpty((Collection)byCode)) {
            objectObjectHashMap = byCode.stream().collect(Collectors.toMap(ItmItemQueryCateDTO::getItemCateCode, t -> t));
        }
        Map<Long, ItmItemSimpleRpcDTO> baseItemMap = this.rmiItemService.findBaseItemMap(itemIds);
        for (ScpCateItemPageVO record : scpCateItemPage.getRecords()) {
            ItmItemSimpleRpcDTO itmItemSimpleRpcDTO;
            if (objectObjectHashMap.get(record.getScpCateCode()) != null) {
                record.setCateName(((ItmItemQueryCateDTO)objectObjectHashMap.get(record.getScpCateCode())).getItemCateFullName());
            }
            if (ObjectUtils.isEmpty((Object)(itmItemSimpleRpcDTO = baseItemMap.get(record.getItemId())))) continue;
            record.setItemName(itmItemSimpleRpcDTO.getItemName());
            record.setSpec(itmItemSimpleRpcDTO.getSpec());
            record.setItemCateFullName(itmItemSimpleRpcDTO.getItemCateFullName());
            record.setBrandName(itmItemSimpleRpcDTO.getBrandName());
            record.setTaxRate(itmItemSimpleRpcDTO.getTaxRate());
            record.setTaxRate2(itmItemSimpleRpcDTO.getTaxRate2());
            record.setItemType(itmItemSimpleRpcDTO.getItemType());
            record.setItemType2(itmItemSimpleRpcDTO.getItemType2());
            record.setItemSupplySource(itmItemSimpleRpcDTO.getItemSupplySource());
            record.setLotFlag(itmItemSimpleRpcDTO.getLotFlag());
            record.setAllocType(itmItemSimpleRpcDTO.getAllocType());
            record.setGuaranteePeriod(itmItemSimpleRpcDTO.getGuaranteePeriod());
            record.setGuaranteePeriodUnit(itmItemSimpleRpcDTO.getGuaranteePeriodUnit());
            record.setSuppCode(itmItemSimpleRpcDTO.getSuppCode());
            record.setSuppName(itmItemSimpleRpcDTO.getSuppName());
        }
        return scpCateItemPage;
    }

    @Override
    public void saveSortNo(Long id, Integer sorNo) {
        this.scpCateItemDomainService.saveSorNo(id, sorNo);
    }

    public ScpCateItemServiceImpl(ScpCateItemDomainService scpCateItemDomainService, RmiItemService rmiItemService, ItmItemCateRpcService itmItemCateRpcService) {
        this.scpCateItemDomainService = scpCateItemDomainService;
        this.rmiItemService = rmiItemService;
        this.itmItemCateRpcService = itmItemCateRpcService;
    }
}

