/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreRespVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepoProc;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpStoreDemandCalendarDomainServiceImpl
implements ScpStoreDemandCalendarDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreDemandCalendarDomainServiceImpl.class);
    private final ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc;
    private final ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo;
    private final EntityManager entityManager;

    @Override
    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO queryParam) {
        return this.storeDemandCalendarRepoProc.searchPage(queryParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<ScpStoreDemandCalendarDO> createList) {
        this.scpStoreDemandCalendarRepo.saveAll(createList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        this.scpStoreDemandCalendarRepo.deleteAllById(ids);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey) {
        return this.scpStoreDemandCalendarRepo.findByConcatYearAndMonthKey(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByStoreDayCalendar(List<String> concatKey) {
        return this.scpStoreDemandCalendarRepo.findByStoreDayCalendar(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDTO> listCalendarDTOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam) {
        return this.storeDemandCalendarRepoProc.findDemandCalendarByParam(scpStoreDemandCalendarParam);
    }

    @Override
    @SysCodeProc
    public List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param) {
        return this.storeDemandCalendarRepoProc.findStoreCalendarByParam(param);
    }

    @Override
    public List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param) {
        return this.storeDemandCalendarRepoProc.listStoreByQueryParam(param);
    }

    @Override
    public void batchInsert(List<ScpStoreDemandCalendarDO> createList, int batchSize) {
        int index = 0;
        for (ScpStoreDemandCalendarDO data : createList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!createList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByStoreAndYear(List<String> storeCodes, String year) {
        this.storeDemandCalendarRepoProc.deleteByStoreAndYear(storeCodes, year);
    }

    public ScpStoreDemandCalendarDomainServiceImpl(ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc, ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo, EntityManager entityManager) {
        this.storeDemandCalendarRepoProc = storeDemandCalendarRepoProc;
        this.scpStoreDemandCalendarRepo = scpStoreDemandCalendarRepo;
        this.entityManager = entityManager;
    }
}

