/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.param.AppItemRpcParamVO;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.service.item.CateItemRpcService;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/cate/item"})
public class ScpCateItemDomainServiceImpl
implements ScpCateItemDomainService,
CateItemRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpCateItemDomainServiceImpl.class);
    private final ScpCateItemRepo scpCateItemRepo;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    public void saveBatch(List<ScpCateItemDO> scpCateItemDOS) {
        this.scpCateItemRepo.saveAll(scpCateItemDOS);
    }

    @Override
    public void delete(List<Long> ids) {
        this.scpCateItemRepo.deleteAllByIdInBatch(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    public ApiResult<List<String>> queryCateCodeByDocType(AppItemRpcParamVO paramVO) {
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            List<String> itemTypes = this.scpOrderSettingDomainService.findItemCatesByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setItemTypes(itemTypes);
        }
        log.info("queryCateCodeByDocType paramVO:{}", (Object)paramVO);
        List<AppItmItemPageVO> byDocType = this.scpCateItemRepoProc.getByDocType(paramVO);
        this.itemMessageImageAndDetailsQuery(byDocType, paramVO.getStoreCode(), paramVO.getDocType(), paramVO.getOuCode());
        this.getPriceAndStock(paramVO.getDocType(), byDocType, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List itemCateCodes = byDocType.stream().map(AppItmItemPageVO::getItemCateCode).distinct().collect(Collectors.toList());
        return ApiResult.ok(itemCateCodes);
    }

    private void itemMessageImageAndDetailsQuery(List<AppItmItemPageVO> collect, String storeCode, String cartType, String ouCode) {
        Long currentUserId = UserService.currentUserId();
        List<Long> spuIdList = collect.stream().map(AppItmItemPageVO::getSpuId).collect(Collectors.toList());
        List<String> itemCodeList = this.scpCateItemRepoProc.pageItemCodesByParam(spuIdList);
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(ouCode);
        param.setItmBusinessFlag(Boolean.valueOf(true));
        param.setEnable(Boolean.valueOf(true));
        param.setSaleFreeze(Boolean.valueOf(false));
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemScpBaseRpcDtoByParam(param);
        Map<Long, List<ItmItemScpBaseRpcDTO>> groupData = itemRpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getSpuId));
        collect.forEach(t -> {
            List itemScpBaseRpcDTOS = (List)groupData.get(t.getSpuId());
            if (itemScpBaseRpcDTOS == null) {
                return;
            }
            ItmItemScpBaseRpcDTO itmItemRpcDTO = (ItmItemScpBaseRpcDTO)itemScpBaseRpcDTOS.get(0);
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setDetails(this.getDetails(CollectionUtils.isNotEmpty((Collection)itmItemRpcDTO.getSubItems()) ? itmItemRpcDTO.getSubItems() : itemScpBaseRpcDTOS, storeCode, cartType, currentUserId, itmItemRpcDTO));
            t.setCombineItemFlag(CollectionUtils.isNotEmpty((Collection)itmItemRpcDTO.getSubItems()));
            if (Boolean.TRUE.equals(t.getCombineItemFlag())) {
                t.setDecimalPlaces(0);
            }
            log.info("\u5f53\u524d\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)t));
        });
        collect.removeIf(t -> !groupData.containsKey(t.getSpuId()));
    }

    @SysCodeProc
    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source, String storeCode, String cartType, Long currentUserId, ItmItemScpBaseRpcDTO parentItem) {
        log.info("\u83b7\u53d6\u8be6\u60c5\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(source));
        return source.stream().map(itmItemRpcDTO -> {
            AppItmItemPageVO t = new AppItmItemPageVO();
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            t.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            t.setItemId(itmItemRpcDTO.getId());
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            t.setMoq(itmItemRpcDTO.getMoq());
            t.setPrice(itmItemRpcDTO.getPrice());
            t.setCombineQty(itmItemRpcDTO.getBomQty());
            if (itmItemRpcDTO.getBomPid() != null) {
                t.setCombineItemFlag(Boolean.TRUE);
                t.setCombineItemCode(parentItem.getItemCode());
                t.setCombineItemName(parentItem.getItemName());
            } else {
                t.setCombineItemFlag(Boolean.FALSE);
            }
            log.info("get detail:\u5f53\u524d\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)t));
            return t;
        }).collect(Collectors.toList());
    }

    public void getPriceAndStock(String docType, List<AppItmItemPageVO> itemList, String storeCode, String type) {
        CopyOnWriteArrayList appItemActivityItemPriceParamVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        itemList.forEach(row -> {
            List inList = row.getDetails().stream().map(t -> {
                AppItemActivityItemPriceParamVO appItemActivityItemPriceParamVO = new AppItemActivityItemPriceParamVO();
                appItemActivityItemPriceParamVO.setStoreCode(storeCode);
                appItemActivityItemPriceParamVO.setItemCode(t.getItemCode());
                appItemActivityItemPriceParamVO.setItemCateCode(t.getItemCateCode());
                appItemActivityItemPriceParamVO.setUom(t.getUom());
                appItemActivityItemPriceParamVO.setItemId(t.getItemId());
                appItemActivityItemPriceParamVO.setCombineItemCode(t.getCombineItemCode());
                appItemActivityItemPriceParamVO.setCombineItemFlag(t.getCombineItemFlag());
                return appItemActivityItemPriceParamVO;
            }).collect(Collectors.toList());
            appItemActivityItemPriceParamVOS.addAll(inList);
        });
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByDocType(docType, type);
        ArrayList filterItemCodes = new ArrayList();
        this.commonPriceService.getPriceAndStockDetails(appItemActivityItemPriceParamVOS, storeCode, orderSetting, type, stockMapRef);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        itemList.forEach(item -> {
            BigDecimal mainStkQty = BigDecimal.ZERO;
            List<AppItmItemPageVO> details = item.getDetails();
            for (int i = 0; i < details.size(); ++i) {
                BigDecimal qty;
                AppItmItemPageVO detail = details.get(i);
                if (detail == null) continue;
                BigDecimal avalQty = stockMap.getOrDefault(detail.getItemCode(), BigDecimal.ZERO);
                detail.setAvalQty(avalQty);
                if (!Boolean.TRUE.equals(detail.getCombineItemFlag()) || (qty = detail.getCombineQty()) == null || qty.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal divide = detail.getAvalQty().divide(qty, 0, RoundingMode.FLOOR);
                if (i == 1) {
                    mainStkQty = divide;
                    continue;
                }
                if (divide.compareTo(mainStkQty) >= 0) continue;
                mainStkQty = divide;
            }
            if (item.getCombineItemFlag() != null && item.getCombineItemFlag().booleanValue()) {
                item.setAvalQty(mainStkQty);
            } else {
                BigDecimal avalQty = stockMap.getOrDefault(item.getItemCode(), BigDecimal.ZERO);
                item.setAvalQty(avalQty);
            }
            if (item.getAvalQty().compareTo(BigDecimal.ZERO) <= 0) {
                filterItemCodes.add(item.getItemCode());
            }
        });
        List collect = itemList.stream().filter(item -> filterItemCodes.contains(item.getItemCode())).collect(Collectors.toList());
        itemList.removeAll(collect);
    }

    @Override
    public List<String> existByItemCodes(List<String> itemCodes) {
        return this.scpCateItemRepoProc.queryByItemCodes(itemCodes);
    }

    public ApiResult<List<String>> findItemCodesBy(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryItemCode(cateItemRpcParam));
    }

    public ApiResult<List<ScpCateItemDTO>> listByParam(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    @Override
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        this.scpCateItemRepoProc.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        long count = this.scpCateItemRepoProc.countItem(paramVO);
        if (count > 0L) {
            List<ScpCateItemRespVO> itemList = this.scpCateItemRepoProc.queryItemList(paramVO);
            List<ScpOrderSettingRespVO> settingList = this.scpOrderSettingDomainService.findEnabledSetting();
            if (CollUtil.isEmpty(settingList)) {
                return new PagingVO(count, itemList);
            }
            Map<String, List<ScpOrderSettingRespVO>> settingMap = settingList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).collect(Collectors.groupingBy(row -> (String)StrUtil.split((CharSequence)row.getItemCate(), (CharSequence)",").get(0)));
            Map<Long, List<ItmItemScpBaseRpcDTO>> itemMap = this.getItemMap(itemList);
            itemList.forEach(row -> {
                if (itemMap.containsKey(row.getItemId())) {
                    Optional<ItmItemAttachmentRpcDTO> first;
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)((List)itemMap.get(row.getItemId())).get(0);
                    row.setSpec(itmItemScpBaseRpcDTO.getSpec());
                    List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                    if (CollUtil.isNotEmpty((Collection)spuAttchmentList) && (first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst()).isPresent()) {
                        row.setUrl(first.get().getUrl());
                    }
                    row.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
                    row.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
                    row.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
                    row.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                    row.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
                    row.setUom(itmItemScpBaseRpcDTO.getUom2());
                    List settingRespVOS = (List)settingMap.get(itmItemScpBaseRpcDTO.getItemType());
                    if (CollUtil.isEmpty((Collection)settingRespVOS)) {
                        return;
                    }
                    ScpOrderSettingRespVO setting = (ScpOrderSettingRespVO)settingRespVOS.get(0);
                    row.setDocType(setting.getDocType());
                }
            });
            Map<String, List<ScpCateItemRespVO>> docTypeMap = itemList.stream().filter(row -> StrUtil.isNotBlank((CharSequence)row.getDocType())).collect(Collectors.groupingBy(ScpCateItemRespVO::getDocType));
            HashMap allPriceMap = new HashMap();
            docTypeMap.forEach((k, v) -> {
                ScpOrderSettingRespVO setting = this.scpOrderSettingDomainService.findCacheByDocType((String)k, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                List<AppItemActivityItemPriceParamVO> priceParamVOS = v.stream().map(row -> {
                    AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                    priceParamVO.setItemCode(row.getItemCode());
                    priceParamVO.setItemId(row.getItemId());
                    priceParamVO.setItemCateCode(row.getItemCateCode());
                    priceParamVO.setUom(row.getUom());
                    return priceParamVO;
                }).collect(Collectors.toList());
                Map<String, List<PriPriceRpcDTO>> priceMap = this.commonPriceService.getPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), setting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                allPriceMap.putAll(priceMap);
            });
            itemList.forEach(row -> {
                if (!allPriceMap.containsKey(row.getItemCode())) {
                    return;
                }
                row.setPrice(((PriPriceRpcDTO)((List)allPriceMap.get(row.getItemCode())).get(0)).getPrice());
            });
            return new PagingVO(count, itemList);
        }
        return new PagingVO();
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        long count = this.scpCateItemRepoProc.countItem(paramVO);
        if (count > 0L) {
            List<ScpCateItemPageVO> scpCateItemPageVOS = this.scpCateItemRepoProc.skuPage(paramVO);
            return new PagingVO(count, scpCateItemPageVOS);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSorNo(Long id, Integer sorNo) {
        this.scpCateItemRepoProc.updateSortNoById(sorNo, id);
    }

    private Map<Long, List<ItmItemScpBaseRpcDTO>> getItemMap(List<ScpCateItemRespVO> cateItemList) {
        List itemIds = cateItemList.stream().map(ScpCateItemRespVO::getItemId).collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> baseRpcDTOList = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isNotEmpty(baseRpcDTOList)) {
            return baseRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getId));
        }
        return new HashMap<Long, List<ItmItemScpBaseRpcDTO>>();
    }

    public ScpCateItemDomainServiceImpl(ScpCateItemRepo scpCateItemRepo, ScpCateItemRepoProc scpCateItemRepoProc, RmiItemService rmiItemService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService) {
        this.scpCateItemRepo = scpCateItemRepo;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.rmiItemService = rmiItemService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
    }
}

