/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.rns.PurRnsRpcDTO;
import com.elitesland.pur.provider.PurRnsProvider;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnConfirmParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.boh.StoreRtnApproveSendParam;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreRtnApproveListener
implements MessageQueueListener<StoreRtnApproveSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreRtnApproveListener.class);
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveDRepo storeReceiveDRepo;
    private final StoreReceiveService storeReceiveService;
    private final PurRnsProvider purRnsProvider;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_rtn_approve"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreRtnApproveSendParam storeReceiveSendParam) {
        log.info("\u95e8\u5e97\u9000\u8d27\u5ba1\u6279\u56de\u5199\uff1a" + JSON.toJSONString((Object)storeReceiveSendParam));
        if (storeReceiveSendParam.getRelateDocId() == null) {
            List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
            if (CollectionUtil.isEmpty(receiveDOS)) {
                return;
            }
            StoreReceiveDO receiveDO = receiveDOS.get(0);
            receiveDO.setStatus("CE");
            receiveDO.setDeliveryDate(LocalDateTime.now());
            ApiResult result = this.purRnsProvider.findById(storeReceiveSendParam.getDocId());
            PurRnsRpcDTO resultData = (PurRnsRpcDTO)result.getData();
            if (resultData != null && resultData.getReturnType().equals("ONLY_REFUND")) {
                log.info("\u5f00\u59cb\u95e8\u5e97\u51fa\u5e93\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a");
                StoreRtnConfirmParam storeRtnConfirmParam = new StoreRtnConfirmParam();
                StoreReceiveDetailVO storeReceiveDetailVO = this.storeReceiveService.find(receiveDO.getDocId());
                storeRtnConfirmParam.setDocId(storeReceiveDetailVO.getDocId());
                storeRtnConfirmParam.setDeliveryMethod("SE");
                ArrayList<StoreRtnConfirmParam.StoreRtnConfirmDetail> details = new ArrayList<StoreRtnConfirmParam.StoreRtnConfirmDetail>();
                List<StoreReceiveDDetailVO> items = storeReceiveDetailVO.getItems();
                for (StoreReceiveDDetailVO item : items) {
                    StoreRtnConfirmParam.StoreRtnConfirmDetail storeRtnConfirmDetail = new StoreRtnConfirmParam.StoreRtnConfirmDetail();
                    storeRtnConfirmDetail.setId(item.getId());
                    storeRtnConfirmDetail.setItemCode(item.getItemCode());
                    storeRtnConfirmDetail.setItemId(item.getItemId());
                    storeRtnConfirmDetail.setQty(item.getOrderQty());
                    details.add(storeRtnConfirmDetail);
                }
                storeRtnConfirmParam.setDetails(details);
                this.storeReceiveService.rtnConfirm(storeRtnConfirmParam);
            }
        } else {
            List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getRelateDocId());
            if (CollectionUtil.isEmpty(receiveDOS)) {
                return;
            }
            StoreReceiveDO receiveDO = receiveDOS.get(0);
            receiveDO.setStatus("APPROVED");
            receiveDO.setDeliveryDate(LocalDateTime.now());
            StoreReceiveDO trnReceiveDO = new StoreReceiveDO();
            trnReceiveDO.setDocCreateDate(LocalDateTime.now());
            trnReceiveDO.setStatus("CE");
            trnReceiveDO.setDocId(storeReceiveSendParam.getDocId());
            trnReceiveDO.setDocNo(storeReceiveSendParam.getDocNo());
            trnReceiveDO.setOrderId(receiveDO.getOrderId());
            trnReceiveDO.setOrderNo(receiveDO.getOrderNo());
            trnReceiveDO.setOrderDate(receiveDO.getOrderDate());
            trnReceiveDO.setReceiveDate(receiveDO.getReceiveDate());
            trnReceiveDO.setDeliveryDate(receiveDO.getDeliveryDate());
            trnReceiveDO.setReceiveDocId(receiveDO.getReceiveDocId());
            trnReceiveDO.setReceiveDocNo(receiveDO.getReceiveDocNo());
            trnReceiveDO.setStoreId(receiveDO.getStoreId());
            trnReceiveDO.setOrderSetId(receiveDO.getOrderSetId());
            trnReceiveDO.setDocType("TRN");
            trnReceiveDO.setTotalAmt(storeReceiveSendParam.getItems().stream().filter(i -> i.getQty() != null && i.getPrice() != null).map(i -> i.getQty().multiply(i.getPrice())).reduce(BigDecimal.ZERO, BigDecimal::add));
            trnReceiveDO.setTotalQty(storeReceiveSendParam.getItems().stream().map(i -> i.getQty()).reduce(BigDecimal.ZERO, BigDecimal::add));
            trnReceiveDO.setRtType("T");
            StoreReceiveDO saved = (StoreReceiveDO)this.storeReceiveRepo.save(trnReceiveDO);
            Map<Long, BigDecimal> priceMap = storeReceiveSendParam.getItems().stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(i -> i.getDid(), i -> i.getPrice()));
            ArrayList<StoreReceiveDDO> trnReceiveDDOS = new ArrayList<StoreReceiveDDO>();
            for (StoreRtnApproveSendParam.OrderItem item : storeReceiveSendParam.getItems()) {
                StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
                storeReceiveDDO.setDid(item.getDid());
                storeReceiveDDO.setId(IdFactory.generateLong());
                storeReceiveDDO.setItemId(item.getItemId());
                storeReceiveDDO.setMasId(saved.getId());
                storeReceiveDDO.setQty(item.getQty());
                storeReceiveDDO.setPrice(priceMap.get(item.getDid()));
                trnReceiveDDOS.add(storeReceiveDDO);
            }
            this.storeReceiveDRepo.saveAll(trnReceiveDDOS);
        }
    }

    public StoreRtnApproveListener(StoreReceiveRepo storeReceiveRepo, StoreReceiveDRepo storeReceiveDRepo, StoreReceiveService storeReceiveService, PurRnsProvider purRnsProvider) {
        this.storeReceiveRepo = storeReceiveRepo;
        this.storeReceiveDRepo = storeReceiveDRepo;
        this.storeReceiveService = storeReceiveService;
        this.purRnsProvider = purRnsProvider;
    }
}

