/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.org.dto.OrgContactRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreWhDTO;
import com.elitesland.support.provider.org.param.OrgStoreBasePageRpcParam;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.param.OrgStoreRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiOrgStoreRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgStoreRpcService.class);
    private final OrgStoreRpcService orgStoreRpcService;

    public OrgStoreDetailRpcDTO findOrgStoreByStoreCode(String storeCode) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5165\u53c2\uff1astoreCode={}", (Object)storeCode);
        try {
            OrgStoreDetailRpcDTO rpcDTO = this.orgStoreRpcService.getByCode(storeCode);
            log.info("\u95e8\u5e97\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)rpcDTO));
            return rpcDTO;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public List<OrgStoreDetailRpcDTO> queryByStoreCodes(List<String> storeCodes) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u96c6\u5408\uff1astoreCodes={}", storeCodes);
        try {
            return this.orgStoreRpcService.queryByStoreCodes(storeCodes);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u96c6\u5408:{}", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u96c6\u5408\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public List<OrgStoreWhDTO> listWhByCode(List<String> storeCodes) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u4ed3\u5e93\u4fe1\u606f\u5165\u53c2\uff1astoreCodes={}", storeCodes);
        ApiResult listApiResult = this.orgStoreRpcService.listWhByCode(storeCodes);
        if (!listApiResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u95e8\u5e97\u4ed3\u5e93\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + listApiResult.getMsg());
        }
        return (List)listApiResult.getData();
    }

    public List<OrgStoreRpcDTO> appSearch(OrgStoreRpcParam param) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u5165\u53c2\uff1astoreCode={}", (Object)param);
        try {
            List orgStoreRpcDTOS = this.orgStoreRpcService.appSearch(param);
            log.info("\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)orgStoreRpcDTOS));
            return orgStoreRpcDTOS;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public List<String> queryAllStoreCodes() {
        try {
            List listApiResult = (List)this.orgStoreRpcService.queryAllStoreCodes().getData();
            return listApiResult;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public PagingVO<OrgStoreRpcDTO> rpcStoreQuery(OrgStoreRpcParam param) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u5165\u53c2\uff1astoreCode={}", (Object)param);
        try {
            PagingVO orgStoreRpcDTOPagingVO = this.orgStoreRpcService.rpcStoreQuery(param);
            log.info("\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)orgStoreRpcDTOPagingVO));
            return orgStoreRpcDTOPagingVO;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u5217\u8868\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public OrgStoreDetailRpcDTO getByCode(String storeCode) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5165\u53c2\uff1astoreCode={}", (Object)storeCode);
        try {
            OrgStoreDetailRpcDTO byCode = this.orgStoreRpcService.getByCode(storeCode);
            log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)byCode));
            return byCode;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public Map<String, OrgStoreBaseRpcDTO> getOrgStoreBaseMap(List<String> storeCodes) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5165\u53c2getOrgStoreMap\uff1astoreCode={}", storeCodes);
        OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
        orgStoreBaseRpcParam.setStoreCodeList(storeCodes);
        ApiResult rpcDTO = this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam);
        log.info("\u95e8\u5e97\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)rpcDTO));
        if (!rpcDTO.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + rpcDTO.getMsg());
        }
        List data = (List)rpcDTO.getData();
        if (CollUtil.isEmpty((Collection)data)) {
            return new HashMap<String, OrgStoreBaseRpcDTO>();
        }
        return data.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity()));
    }

    public OrgStoreBaseRpcDTO getOrgStoreBase(String storeCode) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5165\u53c2getOrgStoreBase\uff1astoreCode={}", (Object)storeCode);
        OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
        orgStoreBaseRpcParam.setStoreCodeList((List)CollUtil.toList((Object[])new String[]{storeCode}));
        ApiResult rpcDTO = this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam);
        log.info("\u95e8\u5e97\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)rpcDTO));
        if (!rpcDTO.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + rpcDTO.getMsg());
        }
        List data = (List)rpcDTO.getData();
        if (CollUtil.isEmpty((Collection)data)) {
            return null;
        }
        return (OrgStoreBaseRpcDTO)data.get(0);
    }

    public List<OrgStoreBaseRpcDTO> findOrgStoreBaseByParam(List<String> storeCodes) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u5165\u53c2\uff1abaseRpcParam={}", (Object)JSONUtil.toJsonStr(storeCodes));
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCodeList(storeCodes);
        ApiResult rpcDTO = this.orgStoreRpcService.findOrgStoreBaseByParam(baseRpcParam);
        log.info("\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)rpcDTO));
        if (!rpcDTO.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + rpcDTO.getMsg());
        }
        return (List)rpcDTO.getData();
    }

    public List<OrgStoreBaseRpcDTO> findOrgStoreBaseByBuIds(List<Long> buIds) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u5165\u53c2\uff1abaseRpcParam={}", (Object)JSONUtil.toJsonStr(buIds));
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setBuIdList(buIds);
        ApiResult rpcDTO = this.orgStoreRpcService.findOrgStoreBaseByParam(baseRpcParam);
        log.info("\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)rpcDTO));
        if (!rpcDTO.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + rpcDTO.getMsg());
        }
        return (List)rpcDTO.getData();
    }

    public List<OrgStoreBaseRpcDTO> findOrgStoreBaseByRegion(List<String> regionList) {
        log.info("\u6309\u533a\u57df\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u5165\u53c2\uff1aregion={}", (Object)JSONUtil.toJsonStr(regionList));
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setRegionList(regionList);
        ApiResult rpcDTO = this.orgStoreRpcService.findOrgStoreBaseByParam(baseRpcParam);
        log.info("\u6309\u533a\u57df\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)rpcDTO));
        if (!rpcDTO.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:" + rpcDTO.getMsg());
        }
        return (List)rpcDTO.getData();
    }

    public List<OrgContactRpcDTO> findContactByStoreCode(String storeCode) {
        List contactRpcDTOS = this.orgStoreRpcService.findContactByStoreCode(storeCode);
        log.info("\u67e5\u8be2\u95e8\u5e97\u8054\u7cfb\u4eba\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)contactRpcDTOS));
        return contactRpcDTOS;
    }

    public Long countBaseStoreByParam(OrgStoreBasePageRpcParam param) {
        ApiResult result = this.orgStoreRpcService.countBaseStoreByParam(param);
        return (Long)result.getData();
    }

    public PagingVO<OrgStoreBaseRpcDTO> queryBaseStore(OrgStoreBasePageRpcParam param) {
        return this.orgStoreRpcService.pageBaseStore(param);
    }

    public RmiOrgStoreRpcService(OrgStoreRpcService orgStoreRpcService) {
        this.orgStoreRpcService = orgStoreRpcService;
    }
}

