/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupDParam;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupParam;
import com.elitesland.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupDVO;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupRespVO;
import com.elitesland.sale.api.vo.resp.crm.AllowShipRuleCustItemVO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcParam;
import com.elitesland.sale.api.vo.resp.crm.MktGiftUpdateNumRpcParam;
import com.elitesland.sale.api.vo.resp.salesman.SalesmanInfoBaseRespVO;
import com.elitesland.sale.constant.AllowShipStatus;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.dto.CrmCustRespDTO;
import com.elitesland.sale.dto.SalesmanInfoDTO;
import com.elitesland.sale.dto.param.AllowShipRpcParam;
import com.elitesland.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.sale.service.AllowShipRpcService;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.sale.service.MktDiscountGiftRpcService;
import com.elitesland.sale.service.SalesmanRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RmiSalService {
    private static final Logger log = LoggerFactory.getLogger(RmiSalService.class);
    @Autowired
    private CrmCustRpcService crmCustRpcService;
    @Autowired
    private SalesmanRpcService salesmanRpcService;
    @Autowired
    private AllowShipRpcService allowShipRpcService;
    @Autowired
    private MktDiscountGiftRpcService mktDiscountGiftRpcService;
    @Autowired
    private EmployeeRpcService employeeRpcService;

    public ApiResult<CrmCustDTO> getCustInfo(String custCode) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a" + custCode);
        try {
            return this.crmCustRpcService.getCustInfo(custCode);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9500\u552e\u652f\u6301\u4e2d\u5fc3\uff0c\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u9500\u552e\u652f\u6301\u4e2d\u5fc3\uff0c\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38" + e);
        }
    }

    public List<LmSaveCustRespVO> findInvCust(List<String> custCodeList) {
        ApiResult apiResult = this.crmCustRpcService.findInvCust(custCodeList);
        Assert.notNull((Object)apiResult, (String)"\u8c03\u75282B\u9500\u552e\u57df\u67e5\u8be2\u4e3b\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a,\u5ba2\u6237\u7f16\u7801{}", (Object[])new Object[]{custCodeList});
        Assert.isTrue((boolean)apiResult.isSuccess(), (String)"\u8c03\u75282B\u9500\u552e\u57df\u67e5\u8be2\u4e3b\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5ba2\u6237\u7f16\u7801{}", (Object[])new Object[]{custCodeList});
        return (List)apiResult.getData();
    }

    public ApiResult<String> getCustName(@NonNull Long custId) {
        if (custId == null) {
            throw new NullPointerException("custId is marked non-null but is null");
        }
        try {
            log.info("\u67e5\u8be2\u5ba2\u6237\u540d\u79f0{}", (Object)custId);
            return this.crmCustRpcService.getCustName(custId);
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u540d\u79f0\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u5ba2\u6237\u540d\u79f0\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
    }

    public ApiResult<List<CrmCustDTO>> listCustById(@NonNull List<Long> custIds) {
        if (custIds == null) {
            throw new NullPointerException("custIds is marked non-null but is null");
        }
        try {
            ApiResult listApiResult = this.crmCustRpcService.listCustById(custIds);
            return listApiResult;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u5f02\u5e38:{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
    }

    public ApiResult<List<CrmCustRespDTO>> getCustByParam(@NonNull CrmCustRpcDtoParam crmCustRpcDtoParam) {
        if (crmCustRpcDtoParam == null) {
            throw new NullPointerException("crmCustRpcDtoParam is marked non-null but is null");
        }
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u6570\u636e\u5165\u53c2{}", (Object)JSON.toJSONString((Object)crmCustRpcDtoParam));
        ApiResult result = this.crmCustRpcService.getCustByParam(crmCustRpcDtoParam);
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u6570\u636e\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public ApiResult<List<CrmCustRespDTO>> getCustByCodeOrNames(List<String> custs) {
        CrmCustRpcDtoParam crmCustRpcDtoParam = new CrmCustRpcDtoParam();
        crmCustRpcDtoParam.setCust(custs);
        log.info("\u6df7\u5408\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u6570\u636e\u5165\u53c2{}", (Object)JSON.toJSONString((Object)crmCustRpcDtoParam));
        ApiResult result = this.crmCustRpcService.getCustByParam(crmCustRpcDtoParam);
        log.info("\u6df7\u5408\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u6570\u636e\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)result));
        if (!result.isSuccess()) {
            throw new BusinessException(result.getErrorMsg());
        }
        return result;
    }

    public ApiResult<Object> updateOrderIsSend(@NonNull List<String> orderCodes) {
        if (orderCodes == null) {
            throw new NullPointerException("orderCodes is marked non-null but is null");
        }
        return null;
    }

    public ApiResult<Object> shipMentMessagePush(@NonNull List<String> bipShipMentOrderCodes) {
        if (bipShipMentOrderCodes == null) {
            throw new NullPointerException("bipShipMentOrderCodes is marked non-null but is null");
        }
        return null;
    }

    public List<SalesmanInfoDTO> querySalesmanInfoList(List<Long> salesmanIds) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u6839\u636e\u591a\u4e2a\u4e1a\u52a1\u5458id \u6216\u8005 \u591a\u4e2a\u4e1a\u52a1\u5458\u7f16\u7801\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), salesmanIds);
        if (CollUtil.isEmpty(salesmanIds)) {
            return new ArrayList<SalesmanInfoDTO>();
        }
        try {
            SalesmanQueryDTO param = new SalesmanQueryDTO();
            param.setSalesmanIdList(salesmanIds);
            ApiResult sysUser = this.salesmanRpcService.querySalesmanInfoByIds(param);
            if (sysUser != null && sysUser.isSuccess()) {
                return (List)sysUser.getData();
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f\u9519\u8bef:", (Throwable)e);
        }
        return null;
    }

    public Map<Long, SalesmanInfoDTO> querySalesmanInfoMap(List<Long> salesmanIds) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u6839\u636e\u591a\u4e2a\u4e1a\u52a1\u5458id \u6216\u8005 \u591a\u4e2a\u4e1a\u52a1\u5458\u7f16\u7801\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), salesmanIds);
        if (CollUtil.isEmpty(salesmanIds)) {
            return new HashMap<Long, SalesmanInfoDTO>();
        }
        SalesmanQueryDTO param = new SalesmanQueryDTO();
        param.setSalesmanIdList(salesmanIds);
        ApiResult salesmanInfo = this.salesmanRpcService.querySalesmanInfoByIds(param);
        if (salesmanInfo != null && salesmanInfo.isSuccess()) {
            return ((List)salesmanInfo.getData()).stream().collect(Collectors.toMap(SalesmanInfoDTO::getId, Function.identity()));
        }
        return new HashMap<Long, SalesmanInfoDTO>();
    }

    public List<SalesmanInfoDTO> querySalesmanInfoListByCodes(List<String> salesmanCodes) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u6839\u636e\u591a\u4e2a\u4e1a\u52a1\u5458\u7f16\u7801 \u6216\u8005 \u591a\u4e2a\u4e1a\u52a1\u5458\u7f16\u7801\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), salesmanCodes);
        if (CollUtil.isEmpty(salesmanCodes)) {
            return new ArrayList<SalesmanInfoDTO>();
        }
        SalesmanQueryDTO param = new SalesmanQueryDTO();
        param.setSalesmanCodeList(salesmanCodes);
        ApiResult sysUser = this.salesmanRpcService.querySalesmanInfoList(param);
        if (!sysUser.isSuccess() || null == sysUser.getData()) {
            throw new BusinessException("\u9500\u552e\u57df\u670d\u52a1\u5f02\u5e38:" + sysUser.getMsg());
        }
        return (List)sysUser.getData();
    }

    @Nullable
    private List<SalesmanInfoDTO> getSalesmanInfoDTOS(EmployeeQueryDTO param) {
        ApiResult listApiResult = this.employeeRpcService.queryList(param);
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u6839\u636e\u591a\u4e2a\u5458\u5de5\u7f16\u7801 \u6216\u8005 \u591a\u4e2a\u5458\u5de5\u7f16\u7801\u67e5\u8be2\u5458\u5de5\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{LocalDateTime.now(), param, JSON.toJSONString((Object)listApiResult)});
        if (listApiResult.isSuccess() && CollUtil.isNotEmpty((Collection)((Collection)listApiResult.getData()))) {
            List data = (List)listApiResult.getData();
            return data.stream().map(row -> {
                SalesmanInfoDTO result = new SalesmanInfoDTO();
                result.setId(row.getId());
                result.setSalesmanNo(row.getCode());
                result.setFullName(row.getFullName());
                return result;
            }).collect(Collectors.toList());
        }
        return new ArrayList<SalesmanInfoDTO>();
    }

    public List<SalesmanInfoDTO> querySalesmanInfoListByCodeOrNames(List<String> salemans) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u6839\u636e\u591a\u4e2a\u4e1a\u52a1\u5458\u7f16\u7801 \u6216\u8005 \u591a\u4e2a\u4e1a\u52a1\u5458\u59d3\u540d\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), salemans);
        if (CollUtil.isEmpty(salemans)) {
            return new ArrayList<SalesmanInfoDTO>();
        }
        SalesmanQueryDTO param = new SalesmanQueryDTO();
        param.setSalemans(salemans);
        ApiResult sysUser = this.salesmanRpcService.querySalesmanInfoList(param);
        if (!sysUser.isSuccess()) {
            throw new BusinessException(sysUser.getErrorMsg());
        }
        if (sysUser != null && sysUser.isSuccess()) {
            log.info("\u4e1a\u52a1\u5458\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)sysUser.getData()));
            return (List)sysUser.getData();
        }
        return new ArrayList<SalesmanInfoDTO>();
    }

    public List<AllowShipRuleCustItemVO> getAllowShipSale(String custCode, List<String> itemCodes) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u5ba2\u6237\u5141\u53d1\u671f\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{LocalDateTime.now(), custCode, itemCodes});
        if (CollUtil.isEmpty(itemCodes)) {
            throw new BusinessException("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u5ba2\u6237\u5141\u53d1\u671f\u4fe1\u606f\uff0c\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
        }
        try {
            List paramList = itemCodes.stream().map(row -> {
                AllowShipRpcParam allowShipRpcParam = new AllowShipRpcParam();
                allowShipRpcParam.setCustCode(custCode);
                allowShipRpcParam.setItemCode(row);
                return allowShipRpcParam;
            }).collect(Collectors.toList());
            return this.allowShipRpcService.getAllowShipSale(paramList);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5ba2\u6237\u5141\u53d1\u671f\u4fe1\u606f:", (Throwable)e);
            throw new BusinessException("\u9500\u552e\u57df\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<AllowShipCustGroupRespVO> getCustGroup(List<String> groupCodes) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u5ba2\u6237\u7ec4\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), groupCodes);
        if (CollUtil.isEmpty(groupCodes)) {
            throw new BusinessException("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u5ba2\u6237\u7ec4\u4fe1\u606f\uff0c\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        try {
            AllowShipCustGroupParam param = new AllowShipCustGroupParam();
            param.setCodes(groupCodes);
            return this.allowShipRpcService.getCustGroup(param);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5ba2\u6237\u7ec4\u4fe1\u606f:", (Throwable)e);
            throw new BusinessException("\u9500\u552e\u57df\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<AllowShipCustGroupDVO> getCustGroupInfo(List<String> custCodes, String type) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u5ba2\u6237\u7ec4\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), custCodes);
        if (CollUtil.isEmpty(custCodes)) {
            throw new BusinessException("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u5ba2\u6237\u7ec4\u4fe1\u606f\uff0c\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        try {
            AllowShipCustGroupDParam param = new AllowShipCustGroupDParam();
            param.setCustCodes(custCodes);
            param.setType(type);
            param.setStatus(AllowShipStatus.ACTIVE.getType());
            return this.allowShipRpcService.getCustGroupInfo(param);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5ba2\u6237\u7ec4\u4fe1\u606f:", (Throwable)e);
            throw new BusinessException("\u9500\u552e\u57df\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public MktDiscountGiftRpcDTO findDiscountGift(MktDiscountGiftRpcParam giftRpcParam) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u6ee1\u8d60\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)giftRpcParam);
        ApiResult giftResult = this.mktDiscountGiftRpcService.getGiftByParam(giftRpcParam);
        return (MktDiscountGiftRpcDTO)giftResult.getData();
    }

    public List<MktDiscountGiftRpcDTO> findDiscountGiftList(MktDiscountGiftRpcParam giftRpcParam) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u83b7\u53d6\u6ee1\u8d60\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)giftRpcParam);
        ApiResult giftResult = this.mktDiscountGiftRpcService.getGiftListByParam(giftRpcParam);
        return (List)giftResult.getData();
    }

    public void updateGiftLockNum(MktGiftUpdateNumRpcParam giftRpcParam) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u9501\u5b9a\u6216\u8005\u91ca\u653e\u8d60\u54c1\u6570\u91cf,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)giftRpcParam);
        ApiResult result = this.mktDiscountGiftRpcService.updateGiftLocknum(giftRpcParam);
        if (!result.isSuccess()) {
            throw new BusinessException("\u9501\u5b9a\u6216\u8005\u91ca\u653e\u8d60\u54c1\u6570\u91cf\u5931\u8d25\uff1a" + result.getMsg());
        }
    }

    public Map<Long, SalesmanInfoBaseRespVO> findBaseMapByIds(List<Long> salesmanIds) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u6839\u636e\u591a\u4e2a\u4e1a\u52a1\u5458id \u6216\u8005 \u591a\u4e2a\u4e1a\u52a1\u5458\u7f16\u7801\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), salesmanIds);
        if (CollUtil.isEmpty(salesmanIds)) {
            return new HashMap<Long, SalesmanInfoBaseRespVO>();
        }
        SalesmanInfoSimpleQueryVO param = new SalesmanInfoSimpleQueryVO();
        param.setIds(salesmanIds);
        ApiResult salesmanInfo = this.salesmanRpcService.findBaseByParam(param);
        if (!salesmanInfo.isSuccess()) {
            throw new BusinessException("\u9500\u552e\u57df\u670d\u52a1\u5f02\u5e38:" + salesmanInfo.getMsg());
        }
        return ((List)salesmanInfo.getData()).stream().collect(Collectors.toMap(SalesmanInfoBaseRespVO::getId, Function.identity()));
    }

    public SalesmanInfoBaseRespVO findBaseMapById(Long salesmanId) {
        log.info("\u8c03\u7528\u9500\u552e\u57df-\u6839\u636e\u591a\u4e2a\u4e1a\u52a1\u5458id \u6216\u8005 \u591a\u4e2a\u4e1a\u52a1\u5458\u7f16\u7801\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)salesmanId);
        if (salesmanId == null) {
            return new SalesmanInfoBaseRespVO();
        }
        SalesmanInfoSimpleQueryVO param = new SalesmanInfoSimpleQueryVO();
        param.setIds(List.of(salesmanId));
        ApiResult salesmanInfo = this.salesmanRpcService.findBaseByParam(param);
        if (!salesmanInfo.isSuccess()) {
            throw new BusinessException("\u9500\u552e\u57df\u670d\u52a1\u5f02\u5e38:" + salesmanInfo.getMsg());
        }
        return (SalesmanInfoBaseRespVO)((List)salesmanInfo.getData()).get(0);
    }

    public Map<Long, CustBaseDTO> findCustBaseMap(List<Long> custIds) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr(custIds));
        if (CollUtil.isEmpty(custIds)) {
            return new HashMap<Long, CustBaseDTO>();
        }
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustIdList(custIds);
        ApiResult custInfo = this.crmCustRpcService.findBaseByParam(custBaseRpcParam);
        if (!custInfo.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)custInfo.getData()));
        return ((List)custInfo.getData()).stream().collect(Collectors.toMap(CustBaseDTO::getId, Function.identity()));
    }

    public CustBaseDTO findCustBaseByCustCode(String custCode) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)custCode));
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(List.of(custCode));
        ApiResult custInfo = this.crmCustRpcService.findBaseByParam(custBaseRpcParam);
        if (!custInfo.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)custInfo.getData()));
        return (CustBaseDTO)((List)custInfo.getData()).get(0);
    }
}

