package com.elitesland.scp.domain.service.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.param.AppItemRpcParamVO;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.service.item.CateItemRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/3 11:40 上午
 * @version:v1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
@RestController
@RequestMapping(ScpApplication.URI_PREFIX + CateItemRpcService.PATH)
public class ScpCateItemDomainServiceImpl implements ScpCateItemDomainService, CateItemRpcService {
    private final ScpCateItemRepo scpCateItemRepo;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;


    @Override
    public void saveBatch(List<ScpCateItemDO> scpCateItemDOS) {
        scpCateItemRepo.saveAll(scpCateItemDOS);
    }

    @Override
    public void delete(List<Long> ids) {
        scpCateItemRepo.deleteAllByIdInBatch(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(scpCateItemRepoProc.queryDto(cateItemRpcParam));

    }

    @Override
    public ApiResult<List<String>> queryCateCodeByDocType(AppItemRpcParamVO paramVO) {
        //根据单据类型查询绑定的商品分类
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            List<String> itemTypes = scpOrderSettingDomainService.findItemCatesByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setItemTypes(itemTypes);
        }
        log.info("queryCateCodeByDocType paramVO:{}", paramVO);
        List<AppItmItemPageVO> byDocType = scpCateItemRepoProc.getByDocType(paramVO);
        // 商品信息查询,图片信息，同SPU下其他SKU信息
        this.itemMessageImageAndDetailsQuery(byDocType, paramVO.getStoreCode(), paramVO.getDocType(), paramVO.getOuCode());
        //商品价格和库存查询
        this.getPriceAndStock(paramVO.getDocType(), byDocType, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<String> itemCateCodes = byDocType.stream().map(AppItmItemPageVO::getItemCateCode).distinct().collect(Collectors.toList());
        return ApiResult.ok(itemCateCodes);

    }

    /**
     * 商品信息查询,图片信息，同SPU下其他SKU信息
     *
     * @param collect
     */
    private void itemMessageImageAndDetailsQuery(List<AppItmItemPageVO> collect, String storeCode, String cartType, String ouCode) {
        Long currentUserId = UserService.currentUserId();
        List<Long> spuIdList = collect.stream().map(AppItmItemPageVO::getSpuId).collect(Collectors.toList());
        List<String> itemCodeList = scpCateItemRepoProc.pageItemCodesByParam(spuIdList);
        //查询采购车商品信息
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(ouCode);
        param.setItmBusinessFlag(true);
        param.setEnable(true);
        param.setSaleFreeze(false);
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemScpBaseRpcDtoByParam(param);
        Map<Long, List<ItmItemScpBaseRpcDTO>> groupData =
                itemRpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getSpuId));
        //减少遍历次数和查找逻辑，以提高性能
        collect.forEach(t -> {
            List<ItmItemScpBaseRpcDTO> itemScpBaseRpcDTOS = groupData.get(t.getSpuId());
            if(itemScpBaseRpcDTOS == null){
                return;
            }
            ItmItemScpBaseRpcDTO itmItemRpcDTO = itemScpBaseRpcDTOS.get(0);
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setItemName(itmItemRpcDTO.getItemName());
            //设置同一个SPU下其他SKU信息
            t.setDetails(getDetails(CollectionUtils.isNotEmpty(itmItemRpcDTO.getSubItems()) ? itmItemRpcDTO.getSubItems() : itemScpBaseRpcDTOS,
                    storeCode,
                    cartType,
                    currentUserId,
                    itmItemRpcDTO
            ));
            t.setCombineItemFlag(CollectionUtils.isNotEmpty(itmItemRpcDTO.getSubItems()));
            if (Boolean.TRUE.equals(t.getCombineItemFlag())) {
                t.setDecimalPlaces(0);
            }
            log.info("当前商品：{}", JSON.toJSONString(t));
        });

        //移除未查询到的商品
        collect.removeIf(t -> !groupData.containsKey(t.getSpuId()));

    }

    @SysCodeProc
    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source, String storeCode, String cartType, Long currentUserId, ItmItemScpBaseRpcDTO parentItem) {
        log.info("获取详情，入参：{}", JSON.toJSONString(source));
        return source.stream().map(
                itmItemRpcDTO -> {
                    AppItmItemPageVO t = new AppItmItemPageVO();
                    t.setItemName(itmItemRpcDTO.getItemName());
                    t.setUom(itmItemRpcDTO.getUom2());
                    t.setUomName(itmItemRpcDTO.getUom2Name());
                    t.setItemType(itmItemRpcDTO.getItemType());
                    t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
                    t.setBrand(itmItemRpcDTO.getBrand());
                    t.setBrandName(itmItemRpcDTO.getBrandName());
                    t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
                    t.setSpec(itmItemRpcDTO.getSpec());
                    t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                    t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
                    t.setSpuId(itmItemRpcDTO.getSpuId());
                    t.setSpuCode(itmItemRpcDTO.getSpuCode());
                    t.setSpuName(itmItemRpcDTO.getSpuName());
                    t.setItemAttrName(StrUtil.isBlank(itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
                    t.setAnotherName(itmItemRpcDTO.getAnotherName());
                    //图片信息
                    t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
                    t.setItemId(itmItemRpcDTO.getId());
                    t.setItemCode(itmItemRpcDTO.getItemCode());
                    t.setUom2(itmItemRpcDTO.getUom());
                    t.setUom2Name(itmItemRpcDTO.getUomName());
                    t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
                    t.setUomRatio(itmItemRpcDTO.getUomRatio2());
                    t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
                    t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
                    t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
                    t.setMoq(itmItemRpcDTO.getMoq());
                    t.setPrice(itmItemRpcDTO.getPrice());
                    t.setCombineQty(itmItemRpcDTO.getBomQty());
                    if (itmItemRpcDTO.getBomPid() != null) {
                        t.setCombineItemFlag(Boolean.TRUE);
                        t.setCombineItemCode(parentItem.getItemCode());
                        t.setCombineItemName(parentItem.getItemName());
                    } else {
                        t.setCombineItemFlag(Boolean.FALSE);
                    }
                    log.info("get detail:当前商品：{}", JSON.toJSONString(t));
                    return t;
                }
        ).collect(Collectors.toList());
    }



    /**
     * 商品价格查询
     *
     * @param docType
     * @param itemList
     * @param storeCode
     * @param type
     */
    public void getPriceAndStock(String docType, List<AppItmItemPageVO> itemList, String storeCode, String type) {
        List<AppItemActivityItemPriceParamVO> appItemActivityItemPriceParamVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList<>());
        itemList.forEach(row -> {
            List<AppItemActivityItemPriceParamVO> inList = row.getDetails().stream()
                    .map(t -> {
                        AppItemActivityItemPriceParamVO appItemActivityItemPriceParamVO = new AppItemActivityItemPriceParamVO();
                        appItemActivityItemPriceParamVO.setStoreCode(storeCode);
                        appItemActivityItemPriceParamVO.setItemCode(t.getItemCode());
                        appItemActivityItemPriceParamVO.setItemCateCode(t.getItemCateCode());
                        appItemActivityItemPriceParamVO.setUom(t.getUom());
                        appItemActivityItemPriceParamVO.setItemId(t.getItemId());
                        appItemActivityItemPriceParamVO.setCombineItemCode(t.getCombineItemCode());
                        appItemActivityItemPriceParamVO.setCombineItemFlag(t.getCombineItemFlag());
                        return appItemActivityItemPriceParamVO;
                    }).collect(Collectors.toList());
            appItemActivityItemPriceParamVOS.addAll(inList);
        });
        //查询库存信息
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(docType, type);

        List<String> filterItemCodes = new ArrayList<>();
        //获取价格和库存信息
        commonPriceService.getPriceAndStockDetails(appItemActivityItemPriceParamVOS, storeCode, orderSetting, type, stockMapRef);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        itemList.forEach(item -> {
            BigDecimal mainStkQty = BigDecimal.ZERO;
            List<AppItmItemPageVO> details = item.getDetails();
            for (int i = 0; i < details.size(); i++) {
                AppItmItemPageVO detail = details.get(i);
                if (detail == null) continue;

                // 库存数据设置
                BigDecimal avalQty = stockMap.getOrDefault(detail.getItemCode(), BigDecimal.ZERO);
                detail.setAvalQty(avalQty);

                // 主商品库存计算
                if (Boolean.TRUE.equals(detail.getCombineItemFlag())) {
                    BigDecimal qty = detail.getCombineQty();
                    // 若 qty 为 0，divide 不执行，避免异常
                    if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal divide = detail.getAvalQty().divide(qty, 0, RoundingMode.FLOOR);
                        if (i == 1) {
                            mainStkQty = divide;
                        } else {
                            if (divide.compareTo(mainStkQty) < 0) {
                                mainStkQty = divide;
                            }
                        }
                    }
                }
            }

            if (item.getCombineItemFlag() != null && item.getCombineItemFlag()) {
                item.setAvalQty(mainStkQty);
            }else {
                // 库存数据设置
                BigDecimal avalQty = stockMap.getOrDefault(item.getItemCode(), BigDecimal.ZERO);
                item.setAvalQty(avalQty);
            }

            //过滤无库存的
            if(item.getAvalQty().compareTo(BigDecimal.ZERO)<=0){
                filterItemCodes.add(item.getItemCode());
            }
        });

        List<AppItmItemPageVO> collect = itemList.stream().filter(item -> filterItemCodes.contains(item.getItemCode())).collect(Collectors.toList());
        itemList.removeAll( collect);
    }

    @Override
    public List<String> existByItemCodes(List<String> itemCodes) {
        return scpCateItemRepoProc.queryByItemCodes(itemCodes);
    }

    @Override
    public ApiResult<List<String>> findItemCodesBy(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(scpCateItemRepoProc.queryItemCode(cateItemRpcParam));
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> listByParam(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    @Override
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        scpCateItemRepoProc.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        long count = scpCateItemRepoProc.countItem(paramVO);
        if (count > 0) {
            var itemList = scpCateItemRepoProc.queryItemList(paramVO);
            List<ScpOrderSettingRespVO> settingList = scpOrderSettingDomainService.findEnabledSetting();
            if (CollUtil.isEmpty(settingList)) {
                return new PagingVO<>(count, itemList);
            }
            var settingMap = settingList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).collect(Collectors.groupingBy(
                    row -> StrUtil.split(row.getItemCate(), ",").get(0)));

            Map<Long, List<ItmItemScpBaseRpcDTO>> itemMap = getItemMap(itemList);
            itemList.forEach(row -> {
                if (itemMap.containsKey(row.getItemId())) {
                    var itmItemScpBaseRpcDTO = itemMap.get(row.getItemId()).get(0);
                    row.setSpec(itmItemScpBaseRpcDTO.getSpec());
                    List<ItmItemAttachmentRpcDTO> spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                    if (CollUtil.isNotEmpty(spuAttchmentList)) {
                        //商品图片取spu主图
                        Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        if (first.isPresent()) {
                            row.setUrl(first.get().getUrl());
                        }
                    }
                    row.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
                    row.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
                    row.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
                    row.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                    row.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
                    row.setUom(itmItemScpBaseRpcDTO.getUom2());
                    List<ScpOrderSettingRespVO> settingRespVOS = settingMap.get(itmItemScpBaseRpcDTO.getItemType());
                    if (CollUtil.isEmpty(settingRespVOS)) {
                        return;
                    }
                    ScpOrderSettingRespVO setting = settingRespVOS.get(0);
                    row.setDocType(setting.getDocType());
                }
            });
            Map<String, List<ScpCateItemRespVO>> docTypeMap = itemList.stream().filter(row -> StrUtil.isNotBlank(row.getDocType())).collect(Collectors.groupingBy(ScpCateItemRespVO::getDocType));
            // 循环docTypeMap
            Map<String, List<PriPriceRpcDTO>> allPriceMap = new HashMap<>();
            docTypeMap.forEach((k, v) -> {
                ScpOrderSettingRespVO setting = scpOrderSettingDomainService.findCacheByDocType(k, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                // 根据docType查询对应的单据配置
                var priceParamVOS = v.stream().map(row -> {
                    AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                    priceParamVO.setItemCode(row.getItemCode());
                    priceParamVO.setItemId(row.getItemId());
                    priceParamVO.setItemCateCode(row.getItemCateCode());
                    priceParamVO.setUom(row.getUom());
                    return priceParamVO;
                }).collect(Collectors.toList());
                Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), setting,
                        ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                allPriceMap.putAll(priceMap);
            });
            itemList.forEach(row -> {
                if (!allPriceMap.containsKey(row.getItemCode())) {
                    return;
                }
                row.setPrice(allPriceMap.get(row.getItemCode()).get(0).getPrice());
            });

            return new PagingVO<>(count, itemList);
        }
        return new PagingVO<>();
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        long count = scpCateItemRepoProc.countItem(paramVO);
        if (count > 0) {
            List<ScpCateItemPageVO> scpCateItemPageVOS = scpCateItemRepoProc.skuPage(paramVO);
            return new PagingVO<>(count, scpCateItemPageVOS);
        }
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSorNo(Long id, Integer sorNo) {
        scpCateItemRepoProc.updateSortNoById(sorNo, id);
    }

    private Map<Long, List<ItmItemScpBaseRpcDTO>> getItemMap(List<ScpCateItemRespVO> cateItemList) {
        List<Long> itemIds = cateItemList.stream().map(ScpCateItemRespVO::getItemId).collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> baseRpcDTOList = rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isNotEmpty(baseRpcDTOList)) {
            return baseRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getId));
        }
        return new HashMap<>();
    }
}
