package com.elitesland.scp.pay.controller;

import com.elitesland.scp.pay.service.AccountLinkService;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/account/")
@Slf4j
@RequiredArgsConstructor
public class AccountLinkController {

    private final AccountLinkService accountLinkService;

    // 获取支付跳转链接
    @PostMapping(value = "/redirects/{payment_id}")
    public Redirect createPaymentLink(@PathVariable("payment_id") String paymentId) throws EntpayException {
        return accountLinkService.createPaymentLink(paymentId, null, null);
    }

}
