/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.boh.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.dto.account.AccountAmtFlowRpcVO;
import com.elitesland.fin.dto.account.AccountFlowAppRpcVO;
import com.elitesland.fin.dto.account.StoreReceivePageRpcVO;
import com.elitesland.fin.param.account.AccountAppRpcParam;
import com.elitesland.fin.service.account.AccountRpcService;
import com.elitesland.inv.dto.boh.StoreOrderDRpcDTO;
import com.elitesland.inv.dto.boh.StoreOrderRpcDTO;
import com.elitesland.inv.dto.boh.StoreRtnApplyResult;
import com.elitesland.inv.dto.invTrn.StoreCanRtnQtyRpcDTO;
import com.elitesland.inv.dto.invTrn.StoreReceiveRpcDTO;
import com.elitesland.inv.dto.invTrn.StoreRtnRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.provider.StoreOrderTrnProvider;
import com.elitesland.pur.provider.PurRnsProvider;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveConfirmParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnApplyParam;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnConfirmParam;
import com.elitesland.scp.application.facade.vo.param.order.StoreReceiveSubmitMqParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.domain.convert.order.StoreReceiveConvert;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemLotRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemQualifyRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class StoreReceiveServiceImpl
implements StoreReceiveService {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveServiceImpl.class);
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveDRepo storeReceiveDRepo;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final OrgOuRpcService orgOuRpcService;
    private final ItmItemRpcService itmItemRpcService;
    private final UdcProvider udcProvider;
    private final OrgAddrRpcService orgAddrRpcService;
    private final StoreOrderTrnProvider storeOrderTrnProvider;
    private final PurRnsProvider purRnsProvider;
    private final TaskExecutor taskExecutor;
    private final MessageQueueTemplate messageQueueTemplate;
    private final RedisTemplate redisTemplate;
    private final RmiItemService rmiItemService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountRpcService accountRpcService;
    private static final Map<String, String> receiveStatusMap = new HashMap<String, String>();
    private static final Map<String, String> rtnStatusMap = new HashMap<String, String>();
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;

    @Override
    public PagingVO<StoreReceivePageVO> page(StoreReceivePageParam param) {
        PagingVO<StoreReceivePageVO> page;
        if (StrUtil.isNotBlank((CharSequence)param.getItemName()) || StrUtil.isNotBlank((CharSequence)param.getItemCode()) || StrUtil.isNotBlank((CharSequence)param.getItemKeyword())) {
            List itemIdByCodeName = this.itmItemRpcService.findItemIdByCodeName(param.getItemCode(), param.getItemName(), param.getItemKeyword());
            if (CollectionUtil.isEmpty((Collection)itemIdByCodeName)) {
                return new PagingVO();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdByCodeName);
            } else {
                param.getItemIds().retainAll(itemIdByCodeName);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getCateIds())) {
            List allLeafCateId = this.itmItemRpcService.findAllLeafCateId(param.getCateIds());
            param.setCateIds(allLeafCateId);
            List<Long> itemIdsByCate = this.storeReceiveRepoProc.findItemIdsByCate(allLeafCateId);
            if (CollectionUtil.isEmpty(itemIdsByCate)) {
                return new PagingVO();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdsByCate);
            } else {
                param.getItemIds().retainAll(itemIdsByCate);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            List<Long> docId = this.storeReceiveRepoProc.findDocId(param.getItemIds());
            if (CollectionUtil.isEmpty(docId)) {
                return new PagingVO();
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                param.setIds(docId);
            } else {
                param.getIds().retainAll(docId);
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(page = this.storeReceiveRepoProc.page(param)).getRecords())) {
            for (StoreReceivePageVO record : page.getRecords()) {
                if (record.getRtType().equals("R")) {
                    record.setStatusName(receiveStatusMap.get(record.getStatus()));
                } else {
                    record.setStatusName(rtnStatusMap.get(record.getStatus()));
                }
                if (record.getDocType().equals("TRN")) {
                    record.setDocTypeName("\u4ed3\u914d");
                    continue;
                }
                record.setDocTypeName("\u4f9b\u5e94\u5546\u76f4\u53d1");
            }
        }
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            List rnsRtnList = page.getRecords().stream().filter(i -> i.getRtType().equals("T") && i.getStatus().equals("DR")).filter(i -> i.getDocType().equals("GR")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(rnsRtnList)) {
                ArrayList approvingIds = (ArrayList)this.purRnsProvider.findApproving(rnsRtnList.stream().map(i -> i.getDocId()).collect(Collectors.toList())).computeData();
                if (CollectionUtil.isEmpty((Collection)approvingIds)) {
                    approvingIds = new ArrayList();
                }
                ArrayList finalApprovingIds = approvingIds;
                rnsRtnList.stream().filter(i -> !finalApprovingIds.contains(i.getDocId())).forEach(i -> i.setCanAbort(true));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            List trnRtnList = page.getRecords().stream().filter(i -> i.getRtType().equals("T") && i.getStatus().equals("DR")).filter(i -> i.getDocType().equals("TRN")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(trnRtnList)) {
                ArrayList approvingIds = (ArrayList)this.storeOrderTrnProvider.findApproving(trnRtnList.stream().map(i -> i.getDocId()).collect(Collectors.toList())).computeData();
                if (CollectionUtil.isEmpty((Collection)approvingIds)) {
                    approvingIds = new ArrayList();
                }
                ArrayList finalApprovingIds = approvingIds;
                trnRtnList.stream().filter(i -> !finalApprovingIds.contains(i.getDocId())).forEach(i -> i.setCanAbort(true));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        return page;
    }

    @Override
    public StoreReceiveDetailVO find(Long docId) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        StoreOrderRpcDTO storeOrderRpcDTO = (StoreOrderRpcDTO)this.storeOrderTrnProvider.detail(docId, thisDO.getDocType(), thisDO.getRtType()).computeData();
        StoreReceiveDetailVO storeReceiveDetailVO = new StoreReceiveDetailVO();
        storeReceiveDetailVO.setAttachments(storeOrderRpcDTO.getAttachments());
        storeReceiveDetailVO.setAttachmentsList(storeOrderRpcDTO.getAttachmentsList());
        storeReceiveDetailVO.setStoreName(this.storeReceiveRepoProc.findStoreName(thisDO.getOrderId()));
        this.assignAddress(storeReceiveDetailVO, storeOrderRpcDTO.getAddrNo());
        storeReceiveDetailVO.setDocId(docId);
        storeReceiveDetailVO.setDocNo(storeOrderRpcDTO.getDocNo());
        storeReceiveDetailVO.setRealAmt(thisDO.getRealAmt());
        if (thisDO.getDocType().equals("TRN") && thisDO.getRtType().equals("R")) {
            simpleOuDto = this.orgOuRpcService.findSimpleOuDto(List.of(storeOrderRpcDTO.getFromOuId()));
            if (CollectionUtil.isNotEmpty((Collection)simpleOuDto)) {
                storeReceiveDetailVO.setDeliveyOuName(((OrgOuRpcSimpleDTO)simpleOuDto.get(0)).getOuName());
            }
            storeReceiveDetailVO.setDeliveryWhId(storeOrderRpcDTO.getFromWhId());
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
            storeReceiveDetailVO.setRecvWhId(storeOrderRpcDTO.getToWhId());
        } else if (thisDO.getDocType().equals("GR") && thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setSuppName(storeOrderRpcDTO.getSuppName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
        } else if (thisDO.getDocType().equals("GR") && thisDO.getRtType().equals("T")) {
            storeReceiveDetailVO.setSuppName(storeOrderRpcDTO.getSuppName());
            storeReceiveDetailVO.setDeliveryWhId(storeOrderRpcDTO.getFromWhId());
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
        } else {
            simpleOuDto = this.orgOuRpcService.findSimpleOuDto(List.of(storeOrderRpcDTO.getToOuId()));
            if (CollectionUtil.isNotEmpty((Collection)simpleOuDto)) {
                storeReceiveDetailVO.setReceiveOuName(((OrgOuRpcSimpleDTO)simpleOuDto.get(0)).getOuName());
            }
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
        }
        storeReceiveDetailVO.setCreateDate(storeOrderRpcDTO.getCreateTime());
        storeReceiveDetailVO.setReceiveDate(thisDO.getReceiveDate());
        storeReceiveDetailVO.setDocStatus(storeOrderRpcDTO.getDocStatus());
        storeReceiveDetailVO.setNote(storeOrderRpcDTO.getRemark());
        storeReceiveDetailVO.setPics(storeOrderRpcDTO.getPics());
        storeReceiveDetailVO.setPicList(storeOrderRpcDTO.getPicList());
        if (thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setRelateDocClsName("\u95e8\u5e97\u8ba2\u8d27\u5355");
            storeReceiveDetailVO.setRelateDocNo(thisDO.getOrderNo());
        } else {
            storeReceiveDetailVO.setRelateDocClsName("\u95e8\u5e97\u6536\u8d27\u5355");
            storeReceiveDetailVO.setRelateDocNo(thisDO.getReceiveDocNo());
        }
        storeReceiveDetailVO.setDocType(thisDO.getDocType());
        if (thisDO.getDocType().equals("TRN")) {
            storeReceiveDetailVO.setDocTypeName("\u4ed3\u914d");
        } else {
            storeReceiveDetailVO.setDocTypeName("\u4f9b\u5e94\u5546\u76f4\u53d1");
        }
        List itemIds = storeOrderRpcDTO.getInvTrnDRpcDTOS().stream().map(i -> i.getItemId()).distinct().collect(Collectors.toList());
        Map<Object, Object> itmItemMap = new HashMap();
        Map<Object, Object> itmItemBaseMap = new HashMap();
        Map<Object, Object> itemUomConvMap = new HashMap();
        if (CollectionUtil.isNotEmpty(itemIds)) {
            List simpleItem = this.itmItemRpcService.findLotRpcDTOS(itemIds);
            itmItemMap = simpleItem.stream().collect(Collectors.toMap(i -> i.getId(), i -> i));
            ItmItemBaseRpcParam itemBaseRpcParam = new ItmItemBaseRpcParam();
            itemBaseRpcParam.setItemIds(itemIds);
            List itemBaseRpcDto = this.itmItemRpcService.findItemBaseRpcDtoByParam(itemBaseRpcParam);
            ItmItemUomConvRpcDtoParam param = new ItmItemUomConvRpcDtoParam();
            param.setItemIds(itemIds);
            List itemUomConvDto = this.itmItemRpcService.findItemUomConvDtoByParam(param);
            itmItemBaseMap = itemBaseRpcDto.stream().collect(Collectors.toMap(i -> i.getId(), i -> i));
            itemUomConvMap = itemUomConvDto.stream().collect(Collectors.groupingBy(ItmItemUomConvRpcDTO::getItemId));
        }
        Map<Long, List<DemandOrderDtl>> itemImgUrlMap = this.getItemImgUrlMap(thisDO.getOrderId());
        Map suppUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", Set.of("UOM"));
        Map invUdcMap = this.udcProvider.getValueMapByUdcCode("yst-inv", Set.of("STK_ITM_STATUS"));
        String orderItemSetting = SysUtils.getOrderItemSetting();
        ArrayList<StoreReceiveDDetailVO> items = new ArrayList<StoreReceiveDDetailVO>();
        for (StoreOrderDRpcDTO invTrnDRpcDTO : storeOrderRpcDTO.getInvTrnDRpcDTOS()) {
            ItmItemLotRpcDTO itmItemSimpleRpcDTO = (ItmItemLotRpcDTO)itmItemMap.get(invTrnDRpcDTO.getItemId());
            ItmItemBaseRpcDTO itmItemBaseRpcDTO = (ItmItemBaseRpcDTO)itmItemBaseMap.get(invTrnDRpcDTO.getItemId());
            List itmItemUomConvRpcDTOS = (List)itemUomConvMap.get(invTrnDRpcDTO.getItemId());
            if (thisDO.getRtType().equals("T") && itmItemSimpleRpcDTO.getItemCode().equals(orderItemSetting)) continue;
            StoreReceiveDDetailVO storeReceiveDDetailVO = new StoreReceiveDDetailVO();
            storeReceiveDDetailVO.setUom1(itmItemBaseRpcDTO.getUom());
            storeReceiveDDetailVO.setUom1Name(itmItemBaseRpcDTO.getUomName());
            storeReceiveDDetailVO.setUom3(itmItemBaseRpcDTO.getUom3());
            storeReceiveDDetailVO.setUom3Name(itmItemBaseRpcDTO.getUom3Name());
            storeReceiveDDetailVO.setUom4(itmItemBaseRpcDTO.getUom4());
            storeReceiveDDetailVO.setUom4Name(itmItemBaseRpcDTO.getUom4Name());
            storeReceiveDDetailVO.setItmItemUomConvRpcDTOS(itmItemUomConvRpcDTOS);
            storeReceiveDDetailVO.setId(invTrnDRpcDTO.getId());
            storeReceiveDDetailVO.setManuDate(invTrnDRpcDTO.getManuDate());
            storeReceiveDDetailVO.setManuFactory(invTrnDRpcDTO.getManuFactory());
            storeReceiveDDetailVO.setManuFactoryName(invTrnDRpcDTO.getManuFactoryName());
            storeReceiveDDetailVO.setOrderDid(invTrnDRpcDTO.getRelateDocDid());
            storeReceiveDDetailVO.setItemId(invTrnDRpcDTO.getItemId());
            storeReceiveDDetailVO.setPrice(invTrnDRpcDTO.getPrice());
            if (thisDO.getRtType().equals("R")) {
                storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getInLotNo());
                storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getInLimit1());
                if (invTrnDRpcDTO.getOutQty() == null || BigDecimal.ZERO.compareTo(invTrnDRpcDTO.getOutQty()) == 0) {
                    continue;
                }
            } else if (thisDO.getStatus().equals("CF")) {
                storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getOutLotNo());
                storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
            } else {
                storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getLotNo());
                storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
            }
            if (thisDO.getDocType().equals("GR")) {
                storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty());
                storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty());
                storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty());
                storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom());
                storeReceiveDDetailVO.setUomName((String)((Map)suppUdcMap.get("UOM")).get(invTrnDRpcDTO.getUom()));
            } else {
                if (invTrnDRpcDTO.getQty2() == null) continue;
                storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty2());
                storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty2());
                storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty2());
                storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom2());
                storeReceiveDDetailVO.setUomName((String)((Map)suppUdcMap.get("UOM")).get(invTrnDRpcDTO.getUom2()));
            }
            if (itmItemSimpleRpcDTO != null) {
                storeReceiveDDetailVO.setItemCode(itmItemSimpleRpcDTO.getItemCode());
                storeReceiveDDetailVO.setItemName(itmItemSimpleRpcDTO.getItemName());
                storeReceiveDDetailVO.setLotFlag(itmItemSimpleRpcDTO.getLotFlag());
                List<DemandOrderDtl> demandOrderDtls = itemImgUrlMap.get(itmItemSimpleRpcDTO.getId());
                if (CollectionUtil.isNotEmpty(demandOrderDtls)) {
                    storeReceiveDDetailVO.setImageUrl(demandOrderDtls.get(0).getImgUrl());
                }
                if (CollectionUtil.isNotEmpty((Collection)itmItemSimpleRpcDTO.getSpuIdQualifyDTOS())) {
                    List<ItmItemQualifyRpcDTO> list = itmItemSimpleRpcDTO.getSpuIdQualifyDTOS().stream().filter(a -> a.getIsShow() != null && a.getIsShow() != false).collect(Collectors.toList());
                    storeReceiveDDetailVO.setItemQualifyRpcDTOList(list);
                }
            }
            storeReceiveDDetailVO.setLimit1Name((String)((Map)invUdcMap.get("STK_ITM_STATUS")).get(storeReceiveDDetailVO.getLimit1()));
            items.add(storeReceiveDDetailVO);
        }
        storeReceiveDetailVO.setItems(items);
        if (thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setDocStatusName(receiveStatusMap.get(thisDO.getStatus()));
        } else {
            storeReceiveDetailVO.setDocStatusName(rtnStatusMap.get(thisDO.getStatus()));
        }
        String invOidoc = SysUtils.getInvOidoc();
        if (invOidoc != null && "1".equals(invOidoc)) {
            storeReceiveDetailVO.setIoDO(true);
        } else {
            storeReceiveDetailVO.setIoDO(false);
        }
        storeReceiveDetailVO.setCarrier(storeOrderRpcDTO.getCarrier());
        storeReceiveDetailVO.setLogisCarrierId(storeOrderRpcDTO.getLogisCarrierId());
        storeReceiveDetailVO.setLogisCarrierCode(storeOrderRpcDTO.getLogisCarrierCode());
        storeReceiveDetailVO.setLogisCarrierName(storeReceiveDetailVO.getLogisCarrierName());
        storeReceiveDetailVO.setLogisContactName(storeReceiveDetailVO.getLogisContactName());
        storeReceiveDetailVO.setLogisContactTel(storeReceiveDetailVO.getLogisContactTel());
        if (StrUtil.isNotBlank((CharSequence)storeOrderRpcDTO.getDeliverMethod())) {
            storeReceiveDetailVO.setDeliverMethod(storeOrderRpcDTO.getDeliverMethod());
            Map orderUdcMap = this.udcProvider.getValueMapByUdcCode("yst-order", Set.of("SO_DELIVER_METHOD"));
            storeReceiveDetailVO.setDeliverMethodName((String)((Map)orderUdcMap.get("SO_DELIVER_METHOD")).get(storeReceiveDetailVO.getDeliverMethod()));
        }
        storeReceiveDetailVO.setLogisDocNo(storeOrderRpcDTO.getLogisDocNo());
        List<StoreReceiveDDO> receiveDDOS = this.storeReceiveDRepo.findAllByMasId(thisDO.getId());
        Map<Long, StoreReceiveDDO> ddoMap = receiveDDOS.stream().collect(Collectors.toMap(i -> i.getDid(), i -> i));
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        for (StoreReceiveDDetailVO item : storeReceiveDetailVO.getItems()) {
            StoreReceiveDDO storeReceiveDDO = ddoMap.get(item.getId());
            if (storeReceiveDDO != null) {
                BigDecimal price = storeReceiveDDO.getPrice() == null ? BigDecimal.ZERO : storeReceiveDDO.getPrice();
                item.setPrice(price);
                item.setOrderQty(storeReceiveDDO.getQty());
            }
            if (item.getOrderQty() == null) continue;
            totalAmt = totalAmt.add(item.getPrice().multiply(item.getOrderQty()));
            totalQty = totalQty.add(item.getOrderQty());
        }
        storeReceiveDetailVO.setTotalAmt(totalAmt);
        storeReceiveDetailVO.setTotalQty(totalQty);
        storeReceiveDetailVO.setDocStatus(thisDO.getStatus());
        if (thisDO.getRtType().equals("T")) {
            storeReceiveDetailVO.setDocStatusName(rtnStatusMap.get(storeReceiveDetailVO.getDocStatus()));
        } else {
            storeReceiveDetailVO.setDocStatusName(receiveStatusMap.get(storeReceiveDetailVO.getDocStatus()));
        }
        return storeReceiveDetailVO;
    }

    @Override
    public StoreReceiveDetailVO findByReceiveDocNo(String purGrNo) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByReceiveDocNo(purGrNo);
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        return this.find(thisDO.getDocId());
    }

    private void assignAddress(StoreReceiveDetailVO storeReceiveDetailVO, Long addrNo) {
        if (addrNo == null || addrNo <= 0L) {
            return;
        }
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        orgAddressRpcDtoParam.setAddrNos(List.of(addrNo));
        List addrAddressRpcDtoByParam = this.orgAddrRpcService.findAddrAddressRpcDtoByParam(orgAddressRpcDtoParam);
        if (CollectionUtil.isEmpty((Collection)addrAddressRpcDtoByParam)) {
            return;
        }
        OrgAddressRpcDTO orgAddressRpcDTO = addrAddressRpcDtoByParam.stream().filter(i -> i.getDefaultFlag() != null && i.getDefaultFlag() != false).findFirst().orElseGet(() -> null);
        if (orgAddressRpcDTO == null) {
            return;
        }
        storeReceiveDetailVO.setCountry(orgAddressRpcDTO.getCountry());
        storeReceiveDetailVO.setCountryName(orgAddressRpcDTO.getCountryName());
        storeReceiveDetailVO.setProvince(orgAddressRpcDTO.getProvince());
        storeReceiveDetailVO.setProvinceName(orgAddressRpcDTO.getProvinceName());
        storeReceiveDetailVO.setCity(orgAddressRpcDTO.getCity());
        storeReceiveDetailVO.setCityName(orgAddressRpcDTO.getCityName());
        storeReceiveDetailVO.setCounty(orgAddressRpcDTO.getCounty());
        storeReceiveDetailVO.setCountyName(orgAddressRpcDTO.getCountyName());
        storeReceiveDetailVO.setDetailaddr(orgAddressRpcDTO.getDetailAddr());
        storeReceiveDetailVO.setContPerson(orgAddressRpcDTO.getContPerson());
        storeReceiveDetailVO.setTel(orgAddressRpcDTO.getTel());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void receiveConfirm(StoreReceiveConfirmParam confirmParam) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(confirmParam.getDocId());
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        String recvKey = "RECEIVE" + confirmParam.getDocId().toString();
        if (this.redisTemplate.hasKey((Object)recvKey).booleanValue()) {
            throw new BusinessException("\u6b63\u5728\u6536\u8d27\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        boolean isPoSet = this.redisTemplate.opsForValue().setIfAbsent((Object)recvKey, (Object)"1", 60L, TimeUnit.SECONDS);
        if (!isPoSet) {
            throw new BusinessException("\u6b63\u5728\u6536\u8d27\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        Assert.isTrue((Objects.equals(thisDO.getStatus(), "CE") && Objects.equals(thisDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5f85\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
        StoreReceiveRpcDTO storeReceiveRpcDTO = new StoreReceiveRpcDTO();
        storeReceiveRpcDTO.setDocId(thisDO.getDocId());
        storeReceiveRpcDTO.setDocNo(thisDO.getDocNo());
        storeReceiveRpcDTO.setDocType(thisDO.getDocType());
        storeReceiveRpcDTO.setAttachmentsList(confirmParam.getAttachments());
        storeReceiveRpcDTO.setReturnReason(confirmParam.getReturnReason());
        ArrayList<StoreReceiveRpcDTO.StoreReceiveRpcDTODetail> details = new ArrayList<StoreReceiveRpcDTO.StoreReceiveRpcDTODetail>();
        for (StoreReceiveConfirmParam.StoreReceiveConfirmDetail detail : confirmParam.getDetails()) {
            StoreReceiveRpcDTO.StoreReceiveRpcDTODetail rpcDetail = new StoreReceiveRpcDTO.StoreReceiveRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setItemId(detail.getItemId());
            rpcDetail.setManuDate(detail.getManuDate());
            rpcDetail.setLimit1(detail.getLimit1());
            rpcDetail.setLotNo(detail.getLotNo());
            details.add(rpcDetail);
        }
        storeReceiveRpcDTO.setDetails(details);
        try {
            StoreReceiveSubmitMqParam orderSubmitMqParam = new StoreReceiveSubmitMqParam();
            orderSubmitMqParam.setReceiveRpcDTO(storeReceiveRpcDTO);
            orderSubmitMqParam.setDocId(confirmParam.getDocId());
            orderSubmitMqParam.setBusinessKey("store_receive_submit");
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "store_receive_submit", (Serializable)orderSubmitMqParam);
        }
        catch (Exception e) {
            log.info("\u95e8\u5e97\u6536\u8d27\u63d0\u4ea4\uff1a{},\u53d1\u9001mq\u6d88\u606f\u5931\u8d25\uff1a{}", (Object)confirmParam.getDocId(), (Object)e.toString());
            this.redisTemplate.delete((Object)recvKey);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rtnConfirm(StoreRtnConfirmParam confirmParam) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(confirmParam.getDocId());
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue((Objects.equals(thisDO.getStatus(), "CE") && Objects.equals(thisDO.getRtType(), "T") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5f85\u9000\u8d27\u72b6\u6001", (Object[])new Object[0]);
        StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
        storeRtnRpcDTO.setDocId(thisDO.getDocId());
        storeRtnRpcDTO.setDeliveryMethod(confirmParam.getDeliveryMethod());
        storeRtnRpcDTO.setDocType(thisDO.getDocType());
        storeRtnRpcDTO.setLogisDocNo(confirmParam.getLogisDocNo());
        storeRtnRpcDTO.setLogisCarrierId(confirmParam.getLogisCarrierId());
        storeRtnRpcDTO.setLogisCarrierCode(confirmParam.getLogisCarrierCode());
        storeRtnRpcDTO.setLogisCarrierName(confirmParam.getLogisCarrierName());
        storeRtnRpcDTO.setNote(confirmParam.getNote());
        storeRtnRpcDTO.setLogisContactTel(confirmParam.getLogisContactTel());
        storeRtnRpcDTO.setLogisContactName(confirmParam.getLogisContactName());
        List<StoreReceiveDDO> receiveDDOS = this.storeReceiveDRepo.findAllByMasId(thisDO.getId());
        Map<Long, StoreReceiveDDO> ddoMap = receiveDDOS.stream().collect(Collectors.toMap(i -> i.getDid(), i -> i));
        ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail>();
        for (StoreRtnConfirmParam.StoreRtnConfirmDetail detail : confirmParam.getDetails()) {
            StoreReceiveDDO storeReceiveDDO = ddoMap.get(detail.getId());
            if (storeReceiveDDO == null) {
                throw new BusinessException("\u5546\u54c1" + detail.getItemCode() + "\u4e0d\u5728\u9000\u8d27\u7533\u8bf7\u5355\u5185");
            }
            if (storeReceiveDDO.getQty().compareTo(detail.getQty()) < 0) {
                throw new BusinessException("\u5546\u54c1" + detail.getItemCode() + "\u9000\u8d27\u6570\u91cf" + detail.getQty() + "\u5927\u4e8e\u7533\u8bf7\u6570\u91cf" + storeReceiveDDO.getQty());
            }
            StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setItemId(detail.getItemId());
            details.add(rpcDetail);
        }
        storeRtnRpcDTO.setDetails(details);
        this.storeOrderTrnProvider.rtn(storeRtnRpcDTO).computeData();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rtnApply(StoreRtnApplyParam applyParam) {
        StoreReceiveDO thisDO = new StoreReceiveDO();
        if (!applyParam.getReturnType().equals("COMPENSATION")) {
            List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(applyParam.getDocId());
            Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            thisDO = receiveDOS.get(0);
            Assert.isTrue((Objects.equals(thisDO.getStatus(), "CF") && Objects.equals(thisDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5df2\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
        }
        StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
        storeRtnRpcDTO.setDocId(thisDO.getDocId());
        storeRtnRpcDTO.setDocType(thisDO.getDocType() != null ? thisDO.getDocType() : "TRN");
        storeRtnRpcDTO.setNote(applyParam.getNote());
        storeRtnRpcDTO.setPicList(applyParam.getPicList());
        storeRtnRpcDTO.setDeliveryMethod(applyParam.getDeliveryMethod());
        storeRtnRpcDTO.setDemandWhStCode(applyParam.getDemandWhStCode());
        storeRtnRpcDTO.setReturnType(applyParam.getReturnType());
        storeRtnRpcDTO.setRefundMethod(applyParam.getRefundMethod());
        storeRtnRpcDTO.setReturnReason(applyParam.getReturnReason());
        ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail>();
        for (StoreRtnApplyParam.StoreRtnApplyDetail detail : applyParam.getDetails()) {
            StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemId(detail.getItemId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setCompensationAmount(detail.getCompensationAmount());
            rpcDetail.setTaxRate(detail.getTaxRate());
            details.add(rpcDetail);
        }
        storeRtnRpcDTO.setDetails(details);
        StoreRtnApplyResult result = (StoreRtnApplyResult)this.storeOrderTrnProvider.rtnApply(storeRtnRpcDTO).computeData();
        StoreReceiveDO receiveDO = new StoreReceiveDO();
        receiveDO.setDocCreateDate(LocalDateTime.now());
        receiveDO.setStatus("DR");
        receiveDO.setDocId(result.getDocId());
        receiveDO.setDocNo(result.getDocNo());
        receiveDO.setOrderId(thisDO.getOrderId() != null ? thisDO.getOrderId() : -1L);
        receiveDO.setOrderNo(thisDO.getOrderNo());
        receiveDO.setOrderDate(thisDO.getOrderDate());
        receiveDO.setReceiveDate(thisDO.getReceiveDate());
        receiveDO.setStoreId(thisDO.getStoreId() != null ? thisDO.getStoreId() : applyParam.getDemandWhStId());
        receiveDO.setOrderSetId(thisDO.getOrderSetId() != null ? thisDO.getOrderSetId() : -1L);
        String docType = "GR".equals(thisDO.getDocType()) ? "GR" : "TRO";
        receiveDO.setDocType(docType);
        receiveDO.setReceiveDocId(thisDO.getDocId());
        receiveDO.setReceiveDocNo(thisDO.getDocNo());
        receiveDO.setTotalAmt(applyParam.getDetails().stream().filter(i -> i.getQty() != null && i.getPrice() != null).map(i -> i.getQty().multiply(i.getPrice())).reduce(BigDecimal.ZERO, BigDecimal::add));
        receiveDO.setTotalQty(applyParam.getDetails().stream().map(i -> i.getQty()).reduce(BigDecimal.ZERO, BigDecimal::add));
        receiveDO.setRtType("T");
        StoreReceiveDO saved = (StoreReceiveDO)this.storeReceiveRepo.save(receiveDO);
        Map<Long, BigDecimal> priceMap = applyParam.getDetails().stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(i -> i.getId(), i -> i.getPrice()));
        ArrayList<StoreReceiveDDO> receiveDDOS = new ArrayList<StoreReceiveDDO>();
        for (StoreRtnApplyResult.OrderItem item : result.getItems()) {
            StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
            storeReceiveDDO.setDid(item.getDid());
            storeReceiveDDO.setId(IdFactory.generateLong());
            storeReceiveDDO.setItemId(item.getItemId());
            storeReceiveDDO.setMasId(saved.getId());
            storeReceiveDDO.setQty(item.getQty());
            storeReceiveDDO.setPrice(priceMap.get(item.getRelateDocDid()));
            receiveDDOS.add(storeReceiveDDO);
        }
        this.storeReceiveDRepo.saveAll(receiveDDOS);
    }

    @Override
    public List<StoreCanRtnQtyRpcDTO> canRtn(Long docId) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue((Objects.equals(thisDO.getStatus(), "CF") && Objects.equals(thisDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5df2\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
        List rpcDTOS = (List)this.storeOrderTrnProvider.canRtn(docId, thisDO.getDocType()).computeData();
        rpcDTOS.forEach(row -> {
            if ("GR".equals(thisDO.getDocType())) {
                row.setCanRtnQty(row.getCanRtnQty());
            } else if (row.getCanRtnQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                row.setCanRtnQty(row.getCanRtnQty().divide(row.getUomRatio(), (int)row.getPlaces(), 4));
            }
            if (row.getStkQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                row.setStkQty(row.getStkQty().divide(row.getUomRatio(), (int)row.getPlaces(), 4));
            }
        });
        return rpcDTOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void abort(Long docId) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue((boolean)thisDO.getStatus().equals("DR"), (String)"\u9000\u8d27\u7533\u8bf7\u4e0d\u53ef\u4f5c\u5e9f", (Object[])new Object[0]);
        if (thisDO.getDocType().equals("TRN")) {
            this.storeOrderTrnProvider.abort(docId).computeData();
        } else {
            this.purRnsProvider.abort(docId).computeData();
        }
        thisDO.setStatus("CL");
        this.storeReceiveRepo.save(thisDO);
    }

    @Override
    public Long countStoreReceive(StoreReceivePageParam param) {
        PagingVO<StoreReceivePageVO> page = this.storeReceiveRepoProc.page(param);
        return page.getTotal();
    }

    @Override
    public Map<String, Object> getCompItem() {
        String itemCode = SysUtils.getCompItemSetting();
        String compImgUrlSetting = SysUtils.getCompImgUrlSetting();
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
        List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = this.rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
            throw new BusinessException("\u8d54\u4ed8\u5546\u54c1\u7f16\u7801\uff1a" + itemCode + "\u4e0d\u5b58\u5728");
        }
        ItmItemBaseRpcDTO itmItemBaseRpcDTO = itemBaseRpcDTOList.get(0);
        Map<String, Object> stringObjectMap = BeanUtils.beanToMap(itmItemBaseRpcDTO, new String[0]);
        stringObjectMap.put("imgUrl", compImgUrlSetting);
        String defaultInStoreCode = SysUtils.getDefaultInStore();
        InvWhRpcDtoParam param = new InvWhRpcDtoParam();
        param.setWhCode(defaultInStoreCode);
        List invWhRpcDTOS = (List)this.rmiInvStkRpcService.findWhDTOByParam(param).computeData();
        if (!CollectionUtils.isEmpty((Collection)invWhRpcDTOS)) {
            stringObjectMap.put("invWhRpcDTO", invWhRpcDTOS.get(0));
        }
        return stringObjectMap;
    }

    private Map<Long, List<DemandOrderDtl>> getItemImgUrlMap(Long orderId) {
        List<DemandOrderDtl> orderDtl = this.storeReceiveRepoProc.findOrderDtl(orderId);
        if (CollUtil.isNotEmpty(orderDtl)) {
            return orderDtl.stream().collect(Collectors.groupingBy(DemandOrderDtl::getItemId));
        }
        return new HashMap<Long, List<DemandOrderDtl>>();
    }

    @Override
    public AccountAmtFlowRpcVO pageWithAccountFlow(AccountAppRpcParam accountAppRpcParam) {
        OrgStoreDetailRpcDTO orgStoreByStoreCode = this.rmiOrgStoreRpcService.findOrgStoreByStoreCode(accountAppRpcParam.getStoreCode());
        ApiResult accountAmtFlowRpcVOApiResult = this.accountRpcService.selectAccountAmt(accountAppRpcParam);
        AccountAmtFlowRpcVO data = (AccountAmtFlowRpcVO)accountAmtFlowRpcVOApiResult.getData();
        if (data != null) {
            StoreReceivePageParam paramVO = new StoreReceivePageParam();
            paramVO.setStoreIds(Arrays.asList(orgStoreByStoreCode.getId()));
            paramVO.setStatusList(Arrays.asList("CF", "APPROVED"));
            paramVO.setDocTypeList(Arrays.asList("TRO", "GR"));
            PagingVO<StoreReceivePageVO> page = this.page(paramVO);
            PagingVO<StoreReceivePageRpcVO> pageRpc = StoreReceiveConvert.INSTANCE.pageToRpcPage(page);
            if (!CollUtil.isEmpty((Collection)pageRpc.getRecords())) {
                List records = pageRpc.getRecords();
                List rtDocNos = records.stream().filter(e -> e.getRtType().equals("T")).collect(Collectors.toList()).stream().map(e -> e.getDocNo()).collect(Collectors.toList());
                List docNos = records.stream().filter(e -> e.getRtType().equals("R")).collect(Collectors.toList()).stream().map(e -> e.getOrderNo()).collect(Collectors.toList());
                docNos.addAll(rtDocNos);
                ApiResult listApiResult = this.accountRpcService.selectAccountFlow(docNos);
                List flowList = (List)listApiResult.getData();
                Map<String, List<AccountFlowAppRpcVO>> groupedMap = flowList.stream().collect(Collectors.groupingBy(AccountFlowAppRpcVO::getRootDocNo));
                for (StoreReceivePageRpcVO record : records) {
                    String keyCode = "";
                    if (record.getRtType().equals("R")) {
                        keyCode = record.getOrderNo();
                    } else if (record.getRtType().equals("T")) {
                        keyCode = record.getDocNo();
                    }
                    List<AccountFlowAppRpcVO> accountFlowAppRpcVOS = groupedMap.get(keyCode);
                    record.setFlowList(accountFlowAppRpcVOS);
                }
                List filtered = records.stream().filter(r -> !CollUtil.isEmpty((Collection)r.getFlowList())).collect(Collectors.toList());
                pageRpc.setRecords(filtered);
            }
            data.setStoreReceivePageVO(pageRpc);
        }
        return data;
    }

    public StoreReceiveServiceImpl(StoreReceiveRepo storeReceiveRepo, StoreReceiveDRepo storeReceiveDRepo, StoreReceiveRepoProc storeReceiveRepoProc, OrgOuRpcService orgOuRpcService, ItmItemRpcService itmItemRpcService, UdcProvider udcProvider, OrgAddrRpcService orgAddrRpcService, StoreOrderTrnProvider storeOrderTrnProvider, PurRnsProvider purRnsProvider, TaskExecutor taskExecutor, MessageQueueTemplate messageQueueTemplate, RedisTemplate redisTemplate, RmiItemService rmiItemService, RmiInvStkRpcService rmiInvStkRpcService, AccountRpcService accountRpcService, RmiOrgStoreRpcService rmiOrgStoreRpcService) {
        this.storeReceiveRepo = storeReceiveRepo;
        this.storeReceiveDRepo = storeReceiveDRepo;
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.orgOuRpcService = orgOuRpcService;
        this.itmItemRpcService = itmItemRpcService;
        this.udcProvider = udcProvider;
        this.orgAddrRpcService = orgAddrRpcService;
        this.storeOrderTrnProvider = storeOrderTrnProvider;
        this.purRnsProvider = purRnsProvider;
        this.taskExecutor = taskExecutor;
        this.messageQueueTemplate = messageQueueTemplate;
        this.redisTemplate = redisTemplate;
        this.rmiItemService = rmiItemService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.accountRpcService = accountRpcService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
    }

    static {
        rtnStatusMap.put("DR", "\u9000\u8d27\u5f85\u5ba1");
        rtnStatusMap.put("CE", "\u5f85\u9000\u8d27");
        rtnStatusMap.put("CF", "\u5df2\u9000\u8d27");
        rtnStatusMap.put("CL", "\u5df2\u53d6\u6d88");
        receiveStatusMap.put("CE", "\u5f85\u6536\u8d27");
        receiveStatusMap.put("CF", "\u5df2\u6536\u8d27");
        receiveStatusMap.put("CL", "\u5df2\u53d6\u6d88");
    }
}

