/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderReplyConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderReplyDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderReplyDomainService;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderReplyDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderReplyRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderReplyRepoProc;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpDemandOrderReplyDomainServiceImpl
implements ScpDemandOrderReplyDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderReplyDomainServiceImpl.class);
    private final ScpDemandOrderReplyRepo scpDemandOrderReplyRepo;
    private final ScpDemandOrderReplyRepoProc scpDemandOrderReplyRepoProc;

    @Override
    public Long save(ScpDemandOrderReplySaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpDemandOrderReplyDO replyDO = ScpDemandOrderReplyConvert.INSTANCE.saveVoToDO(saveVO);
            return ((ScpDemandOrderReplyDO)this.scpDemandOrderReplyRepo.save(replyDO)).getId();
        }
        Optional option = this.scpDemandOrderReplyRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u5355\u8bc4\u4ef7ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderReplyConvert.INSTANCE.copySaveParamToDo(saveVO, (ScpDemandOrderReplyDO)option.get());
        Long masId = ((ScpDemandOrderReplyDO)this.scpDemandOrderReplyRepo.save((ScpDemandOrderReplyDO)option.get())).getId();
        return masId;
    }

    @Override
    public Optional<ScpDemandOrderReplyDTO> findReplyByOrderId(Long orderId) {
        List<ScpDemandOrderReplyDO> orderReplyDOS = this.scpDemandOrderReplyRepo.findByOrderId(orderId);
        if (CollUtil.isEmpty(orderReplyDOS)) {
            throw new BusinessException("\u8ba2\u5355\u8bc4\u4ef7ID\uff1a" + orderId + "\u4e0d\u5b58\u5728");
        }
        return Optional.of(orderReplyDOS.get(0)).map(ScpDemandOrderReplyConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderReplyPageRespVO> page(ScpDemandOrderReplyPageParamVO paramVO) {
        long count = this.scpDemandOrderReplyRepoProc.countOrderReply(paramVO);
        if (count > 0L) {
            List<ScpDemandOrderReplyPageRespVO> demandOrder = this.scpDemandOrderReplyRepoProc.queryOrderReply(paramVO);
            demandOrder.forEach(row -> {
                row.setPicList(StrUtil.split((CharSequence)row.getPics(), (CharSequence)";"));
                String orderScoreStr = row.getOrderScore() == null ? "" : row.getOrderScore().toString() + "/5";
                String expressScoreStr = row.getExpressScore() == null ? "" : row.getExpressScore().toString() + "/5";
                row.setOrderScoreStr(orderScoreStr);
                row.setExpressScoreStr(expressScoreStr);
            });
            return new PagingVO(count, demandOrder);
        }
        return new PagingVO();
    }

    public ScpDemandOrderReplyDomainServiceImpl(ScpDemandOrderReplyRepo scpDemandOrderReplyRepo, ScpDemandOrderReplyRepoProc scpDemandOrderReplyRepoProc) {
        this.scpDemandOrderReplyRepo = scpDemandOrderReplyRepo;
        this.scpDemandOrderReplyRepoProc = scpDemandOrderReplyRepoProc;
    }
}

