/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetComputeParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalendarBuilder {
    private static final Map<Integer, List<ScpStoreCalendarSetLineRespVO>> DAY_MAP = new HashMap<Integer, List<ScpStoreCalendarSetLineRespVO>>();
    private static final Map<Integer, List<ScpStoreCalendarSetLineRespVO>> NO_DAY_MAP = new HashMap<Integer, List<ScpStoreCalendarSetLineRespVO>>();

    public static List<ScpStoreDemandCalendarDO> buildCalendarSetList(LocalDate startOfYear, LocalDate endOfYear, ScpStoreCalendarSetComputeParamVO param) {
        try {
            DAY_MAP.put(1, param.getMonList());
            DAY_MAP.put(2, param.getTuesList());
            DAY_MAP.put(3, param.getWendsList());
            DAY_MAP.put(4, param.getThursList());
            DAY_MAP.put(5, param.getFriList());
            DAY_MAP.put(6, param.getSaturList());
            DAY_MAP.put(7, param.getSunList());
            NO_DAY_MAP.put(1, param.getNonMonList());
            NO_DAY_MAP.put(2, param.getNonTuesList());
            NO_DAY_MAP.put(3, param.getNonWendsList());
            NO_DAY_MAP.put(4, param.getNonThursList());
            NO_DAY_MAP.put(5, param.getNonFriList());
            NO_DAY_MAP.put(6, param.getNonSaturList());
            NO_DAY_MAP.put(7, param.getNonSunList());
            ArrayList<ScpStoreDemandCalendarDO> saveList = new ArrayList<ScpStoreDemandCalendarDO>();
            while (!startOfYear.isAfter(endOfYear)) {
                int dayOfWeekValue = startOfYear.getDayOfWeek().getValue();
                List<ScpStoreCalendarSetLineRespVO> dayList = DAY_MAP.get(dayOfWeekValue);
                List<ScpStoreCalendarSetLineRespVO> nonDayList = NO_DAY_MAP.get(dayOfWeekValue);
                if (CollUtil.isNotEmpty(dayList)) {
                    for (ScpStoreCalendarSetLineRespVO line : dayList) {
                        saveList.add(CalendarBuilder.buildCalendarSet(line, startOfYear, "W"));
                    }
                }
                if (CollUtil.isNotEmpty(nonDayList)) {
                    for (ScpStoreCalendarSetLineRespVO line : nonDayList) {
                        saveList.add(CalendarBuilder.buildCalendarSet(line, startOfYear, "E"));
                    }
                }
                startOfYear = startOfYear.plusDays(1L);
            }
            return saveList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<ScpStoreDemandCalendarDO>();
        }
    }

    private static ScpStoreDemandCalendarDO buildCalendarSet(ScpStoreCalendarSetLineRespVO line, LocalDate date, String workStatus) {
        ScpStoreDemandCalendarDO saveDO = new ScpStoreDemandCalendarDO();
        saveDO.setStoreId(line.getStoreId());
        saveDO.setStoreCode(line.getStoreCode());
        saveDO.setStoreName(line.getStoreName());
        saveDO.setYear(String.valueOf(date.getYear()));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
        String month = date.format(formatter);
        saveDO.setMonth(month);
        saveDO.setDay(String.valueOf(date.getDayOfMonth()));
        saveDO.setWorkStatus(workStatus);
        return saveDO;
    }

    static {
        DAY_MAP.put(1, new ArrayList());
        DAY_MAP.put(2, new ArrayList());
        DAY_MAP.put(3, new ArrayList());
        DAY_MAP.put(4, new ArrayList());
        DAY_MAP.put(5, new ArrayList());
        DAY_MAP.put(6, new ArrayList());
        DAY_MAP.put(7, new ArrayList());
        NO_DAY_MAP.put(1, new ArrayList());
        NO_DAY_MAP.put(2, new ArrayList());
        NO_DAY_MAP.put(3, new ArrayList());
        NO_DAY_MAP.put(4, new ArrayList());
        NO_DAY_MAP.put(5, new ArrayList());
        NO_DAY_MAP.put(6, new ArrayList());
        NO_DAY_MAP.put(7, new ArrayList());
    }
}

