package com.elitesland.scp.application.facade.vo.boh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class StoreReceiveDetailVO implements Serializable {
    @ApiModelProperty("收/退货id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long docId;

    @ApiModelProperty("收/退货单号")
    private String docNo;

    @ApiModelProperty("国家")
    String country;
    String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailaddr;

    @ApiModelProperty("联系人")
    private String contPerson;

    @ApiModelProperty("联系人电话")
    private String tel;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("配送方式")
    @SysCode(sys = "yst-order", mod = "SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;

    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;

    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;

    @ApiModelProperty("物流配送人")
    private String logisContactName;

    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("状态")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("门店")
    private String storeName;

    @ApiModelProperty("收货仓库")
    private String receWhName;
    private Long recvWhId;

    @ApiModelProperty("收货公司")
    private String receiveOuName;

    @ApiModelProperty("发货公司")
    private String deliveyOuName;

    @ApiModelProperty("发货仓库id")
    private Long deliveryWhId;

    @ApiModelProperty("发货仓库")
    private String deliveryWhName;

    @ApiModelProperty("来源单据")
    private String relateDocClsName;

    @ApiModelProperty("来源单据单号")
    private String relateDocNo;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("收货日期")
    private LocalDateTime receiveDate;

    @ApiModelProperty("备注")
    private String note;

    @ApiModelProperty(value = "退货图片")
    private String pics;

    @ApiModelProperty(value = "退货图片")
    private List<String> picList;

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发，采购收货单")
    private String docType;

    private String docTypeName;

    @ApiModelProperty("是否对接出入库单，false：不对接，true：对接，不对接时可不展示承运商、物流单号等信息")
    private boolean ioDO;

    @ApiModelProperty("合计数量")
    private BigDecimal totalQty;

    @ApiModelProperty("计划金额（收货时已发货金额）")
    private BigDecimal totalAmt;

    @ApiModelProperty("实际收退货金额")
    private BigDecimal realAmt;

    @ApiModelProperty(value = "差异收货图片")
    private String attachments;

    private String remark;

    @ApiModelProperty(value = "差异收货图片")
    private List<String> attachmentsList;

    private List<StoreReceiveDDetailVO> items;
    private List<StoreReceiveAttachmentVO> attachmentVOS;
}
