package com.elitesland.scp.application.facade.vo.resp.mrp;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("物料需求计划明细采购计划")
public class ScpMrpDPlanRespVO extends BaseViewModel implements Serializable {
    
    private static final long serialVersionUID = -7666697678545938140L;

    @ApiModelProperty("MRP计划Id")
    private Long mrpId;

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("采购公司id")
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty("供应商id")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("采购计划数量")
    private BigDecimal qty;

    @ApiModelProperty("采购订单号")
    private String poNo;

    @ApiModelProperty("采购订单明细ID")
    private Long poDId;

    @ApiModelProperty("采购订单行号")
    private Integer poLineNo;

    @ApiModelProperty("推送状态")
    @SysCode(sys = "yst-suplan", mod = "MRP_D_PUSH_STATUS")
    private String pushStatus;
    private String pushStatusName;

    @ApiModelProperty("推送失败原因")
    private String pushFailReason;
}
