package com.elitesland.scp.domain.service.msg;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.query.msg.CommonPublishedMessagePageQueryVO;
import com.elitesland.scp.application.facade.vo.resp.msg.CommonPublishedScpMessagePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.CommonPublishedScpMessageRespVO;
import com.elitesland.scp.common.ScpMessageReceiverType;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/29
 */
public interface ScpMessageQueryService {

    /**
     * 统计未读消息数量
     *
     * @param receiverType 接收者类型
     * @param receiverId   接收者标识
     * @return 未读消息数量
     */
    ApiResult<Long> countUnView(@NotNull ScpMessageReceiverType receiverType, @NotBlank String receiverId);

    /**
     * 分页查询已发布的消息
     *
     * @param receiverType 接收人类型
     * @param queryVO      查询参数
     * @return 消息结果
     */
    ApiResult<PagingVO<CommonPublishedScpMessagePageRespVO>> pagePublished(@NotNull ScpMessageReceiverType receiverType,
                                                                           @NotNull CommonPublishedMessagePageQueryVO queryVO);

    /**
     * 获取发布的消息
     *
     * @param id 消息ID
     * @return 消息详情
     */
    ApiResult<CommonPublishedScpMessageRespVO> viewPublished(@NotNull Long id,
                                                             @NotNull ScpMessageReceiverType receiverType,
                                                             @NotBlank String receiverId);
}
