package com.elitesland.scp.application.web.alloc;


import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingStoreSaveVO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@Api(tags = "订货强配门店接口")
@RestController
@RequestMapping(value = "/alloc/setting/store", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpAllocSettingStoreController {

    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;

    @ApiOperation(value = "订货强配门店 -  门店分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpAllocSettingStoreRespVO>> queryAllocSettingStore(@RequestBody @Validated ScpAllocSettingStorePageParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] queryAllocSettingStore  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpAllocSettingStoreDomainService.page(paramVO));
    }

    @PostMapping("/batchSave")
    @ApiOperation("订货强配门店 - 批量新增")
    public ApiResult<Long> batchSaveAllocSettingStore(@RequestBody @Validated List<ScpAllocSettingStoreSaveVO> saveVOS) {
        log.info("[SCP-ALLOC-SETTING-STORE] batchSaveAllocSettingStore  saveVO ={}", JSONUtil.toJsonStr(saveVOS));
        scpAllocSettingStoreDomainService.batchSaveAllocSettingStore(saveVOS);
        return ApiResult.ok();
    }

    @PostMapping("/update")
    @ApiOperation("订货强配门店 - 修改")
    public ApiResult<Long> saveAllocSettingStore(@RequestBody @Validated ScpAllocSettingStoreSaveVO saveVO) {
        log.info("[SCP-ALLOC-SETTING-STORE] saveAllocSettingStore  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        scpAllocSettingStoreDomainService.updateAllocSettingStore(saveVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货强配门店 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-ALLOC-SETTING-STORE] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpAllocSettingStoreDomainService.deleteByIds(ids);
        return ApiResult.ok();
    }

}
