package com.elitesland.scp.infr.repo.storereceive;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.facade.vo.boh.*;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.domain.entity.storereceive.QStoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.QStoreReceiveDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.mq.DemandOrderSimpleDTO;
import com.elitesland.scp.utils.PartitionJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Component
public class StoreReceiveRepoProc extends BaseRepoProc<StoreReceiveDO> {

    private static final QStoreReceiveDO qdo = QStoreReceiveDO.storeReceiveDO;

    public StoreReceiveRepoProc() {
        super(qdo);
    }

    public List<StoreReceivePageVO> subRecvOrderList(List<String> orderNos){
        JPAQuery<StoreReceivePageVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(StoreReceivePageVO.class,
                        qdo.id,
                        qdo.docId,
                        qdo.docNo,
                        qdo.orderId,
                        qdo.orderNo,
                        qdo.orderSetId,
                        qdo.totalRealQty,
                        qdo.realAmt,
                        qdo.totalQty,
                        qdo.docCreateDate,
                        qdo.deliveryDate,
                        qdo.receiveDate,
                        qdo.orderDate,
                        qdo.totalAmt,
                        qdo.docType,
                        qdo.status,
                        qdo.rtType))
                .from(qdo);
        jpaQuery.where(qdo.orderNo.in(orderNos));
        jpaQuery.orderBy(qdo.docCreateDate.desc());
        return jpaQuery.fetch();
    }

    public PagingVO<StoreReceivePageVO> page(StoreReceivePageParam param) {
        JPAQuery<StoreReceivePageVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(StoreReceivePageVO.class,
                        qdo.id,
                        qdo.docId,
                        qdo.docNo,
                        qdo.orderId,
                        qdo.orderNo,
                        qdo.orderSetId,
                        qdo.totalRealQty,
                        qdo.realAmt,
                        qdo.totalQty,
                        qdo.docCreateDate,
                        qdo.deliveryDate,
                        qdo.receiveDate,
                        qdo.orderDate,
                        qdo.totalAmt,
                        qdo.docType,
                        qdo.status,
                        qdo.rtType))
                .from(qdo);
        if (param != null) {
            where(param, jpaQuery);
        }
        //分区查询字段
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, StoreReceiveDO.class, param);
        jpaQuery.orderBy(qdo.docCreateDate.desc());
        param.setPaging(jpaQuery);
        return PagingVO.<StoreReceivePageVO>builder()
                .records(jpaQuery.fetch())
                .total(jpaQuery.fetchCount()).build();
    }


    public PagingVO<StoreReceiveGroupPageVO> selectGroupPage(StoreReceivePageParam param){
        JPAQuery<StoreReceiveGroupPageVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(StoreReceiveGroupPageVO.class,
                        qdo.orderId,
                        qdo.orderNo,
                        qdo.orderSetId
                )).from(qdo);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, StoreReceiveDO.class, param);
        jpaQuery.groupBy( qdo.orderId, qdo.orderNo, qdo.orderSetId);
        jpaQuery.orderBy(qdo.docCreateDate.desc());
        param.setPaging(jpaQuery);
        JPAQuery<?> subQuery = jpaQueryFactory.selectDistinct(
                        qdo.orderId, qdo.orderNo, qdo.orderSetId)
                .from(qdo);
        if (param != null) {
            subQuery.where(this.where(param));
        }
        PartitionJpaUtil.appendYmConditionToPredicate(subQuery, StoreReceiveDO.class, param);
        long count = subQuery.fetch().size();
        return PagingVO.<StoreReceiveGroupPageVO>builder()
                .records(jpaQuery.fetch())
                .total(count).build();
    }

    private Predicate where(StoreReceivePageParam param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StrUtil.isNotBlank(param.getDocType())) {
            predicate = ExpressionUtils.and(predicate, qdo.docType.eq(param.getDocType()));
        }
        if (CollectionUtil.isNotEmpty(param.getDocTypeList())) {
            predicate = ExpressionUtils.and(predicate, qdo.docType.in(param.getDocTypeList()));
        }
        if (StrUtil.isNotBlank(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, qdo.docNo.like("%" + param.getDocNo() + "%"));
        }
        if (StrUtil.isNotBlank(param.getRtType())) {
            predicate = ExpressionUtils.and(predicate, qdo.rtType.eq(param.getRtType()));
        }
        if (StrUtil.isNotBlank(param.getOrderNo())) {
            predicate = ExpressionUtils.and(predicate, qdo.orderNo.eq(param.getOrderNo()));
        }
        if (param.getOrderId() != null) {
            predicate = ExpressionUtils.and(predicate, qdo.orderId.eq(param.getOrderId()));
        }
        if (param.getOrderSetId() != null) {
            predicate = ExpressionUtils.and(predicate, qdo.orderSetId.eq(param.getOrderSetId()));
        }
        if (param.getCreateDateFrom() != null) {
            predicate = ExpressionUtils.and(predicate, qdo.docCreateDate.goe(param.getCreateDateFrom()));
        }
        if (param.getCreateDateTo() != null) {
            predicate = ExpressionUtils.and(predicate, qdo.docCreateDate.loe(param.getCreateDateTo()));
        }
        if (CollectionUtil.isNotEmpty(param.getStatusList())) {
            predicate = ExpressionUtils.and(predicate, qdo.status.in(param.getStatusList()));
        }
        if (CollectionUtil.isNotEmpty(param.getOrderIds())) {
            predicate = ExpressionUtils.and(predicate, qdo.orderId.in(param.getOrderIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getStoreIds())) {
            predicate = ExpressionUtils.and(predicate, qdo.storeId.in(param.getStoreIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            predicate = ExpressionUtils.and(predicate, qdo.id.in(param.getIds()));
        }
        return predicate;
    }


    private void where(StoreReceivePageParam param, JPAQuery<StoreReceivePageVO> jpaQuery) {
        if (StrUtil.isNotBlank(param.getDocType())) {
            jpaQuery.where(qdo.docType.eq(param.getDocType()));
        }
        if (CollectionUtil.isNotEmpty(param.getDocTypeList())) {
            jpaQuery.where(qdo.docType.in(param.getDocTypeList()));
        }
        if (StrUtil.isNotBlank(param.getDocNo())) {
            jpaQuery.where(qdo.docNo.like("%" + param.getDocNo() + "%"));
        }
        if (StrUtil.isNotBlank(param.getRtType())) {
            jpaQuery.where(qdo.rtType.eq(param.getRtType()));
        }
        if (StrUtil.isNotBlank(param.getOrderNo())) {
            jpaQuery.where(qdo.orderNo.eq(param.getOrderNo()));
        }
        if (param.getOrderId() != null) {
            jpaQuery.where(qdo.orderId.eq(param.getOrderId()));
        }
        if (param.getOrderSetId() != null) {
            jpaQuery.where(qdo.orderSetId.eq(param.getOrderSetId()));
        }
        if (param.getCreateDateFrom() != null) {
            jpaQuery.where(qdo.docCreateDate.goe(param.getCreateDateFrom()));
        }
        if (param.getCreateDateTo() != null) {
            jpaQuery.where(qdo.docCreateDate.loe(param.getCreateDateTo()));
        }
        if (CollectionUtil.isNotEmpty(param.getStatusList())) {
            jpaQuery.where(qdo.status.in(param.getStatusList()));
        }
        if (CollectionUtil.isNotEmpty(param.getOrderIds())) {
            jpaQuery.where(qdo.orderId.in(param.getOrderIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getStoreIds())) {
            jpaQuery.where(qdo.storeId.in(param.getStoreIds()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            jpaQuery.where(qdo.id.in(param.getIds()));
        }
    }

    public List<Long> findOrderId(String itemKeyword) {
        QScpDemandOrderDDO demandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
        JPAQuery<Long> query = jpaQueryFactory.select(demandOrderDDO.masId).from(demandOrderDDO).where(demandOrderDDO.itemCode.like("%" + itemKeyword + "%")
                        .or(demandOrderDDO.itemName.like("%" + itemKeyword + "%")))
                .where(demandOrderDDO.planQuantity.isNotNull().and(demandOrderDDO.planQuantity.goe(BigDecimal.ZERO)));
        return query.fetch();
    }

    public List<DemandOrderSimpleDTO> findOrderSimple(List<Long> orderIds) {
        QScpDemandOrderDO demandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
        JPAQuery<DemandOrderSimpleDTO> query = jpaQueryFactory.select(Projections.bean(DemandOrderSimpleDTO.class, demandOrderDO.docCls,
                        demandOrderDO.type, demandOrderDO.createTime,
                        demandOrderDO.id, demandOrderDO.demandId.as("orderSetId"), demandOrderDO.demandWhStId.as("storeId")))
                .from(demandOrderDO).where(demandOrderDO.id.in(orderIds));
        return query.fetch();
    }

    public int findStoreCount(Long scpsmanId) {
        QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;
        QScpsmanAuthorityDO scpsmanAuthorityDO = QScpsmanAuthorityDO.scpsmanAuthorityDO;
        JPAQuery<Long> query = jpaQueryFactory.select(scpsmanAuthorityDDO.stWhId.count()).from(scpsmanAuthorityDDO).leftJoin(scpsmanAuthorityDO).on(scpsmanAuthorityDDO.masId.eq(scpsmanAuthorityDO.id))
                .where(scpsmanAuthorityDO.scpsmanId.eq(scpsmanId)).where(scpsmanAuthorityDDO.type.eq(0))
                .where(scpsmanAuthorityDDO.deleteFlag.eq(0));
        List<Long> fetch = query.fetch();
        if (CollectionUtil.isEmpty(fetch)) {
            return 0;
        }
        return fetch.get(0).intValue();
    }

    public int findNeedDo(Long storeId, LocalDateTime startDate) {
        JPAQuery<Long> query = jpaQueryFactory.select(qdo.id.count()).from(qdo)
                .where(qdo.storeId.eq(storeId)).where(qdo.status.eq("CE")).where(qdo.docCreateDate.goe(startDate));
        List<Long> fetch = query.fetch();
        if (CollectionUtil.isEmpty(fetch)) {
            return 0;
        }
        return fetch.get(0).intValue();
    }

    public int findReceive(Long storeId, LocalDateTime startDate) {
        JPAQuery<Long> query = jpaQueryFactory.select(qdo.id.count()).from(qdo)
                .where(qdo.storeId.eq(storeId)).where(qdo.status.in("CE")).where(qdo.rtType.eq("R")).where(qdo.docCreateDate.goe(startDate));
        List<Long> fetch = query.fetch();
        if (CollectionUtil.isEmpty(fetch)) {
            return 0;
        }
        return fetch.get(0).intValue();
    }

    public int findRtn(Long storeId, LocalDateTime startDate) {
        JPAQuery<Long> query = jpaQueryFactory.select(qdo.id.count()).from(qdo)
                .where(qdo.storeId.eq(storeId)).where(qdo.status.in("CE")).where(qdo.rtType.eq("T")).where(qdo.docCreateDate.goe(startDate));
        List<Long> fetch = query.fetch();
        if (CollectionUtil.isEmpty(fetch)) {
            return 0;
        }
        return fetch.get(0).intValue();
    }

    public int findRtnApply(Long storeId, LocalDateTime startDate) {
        JPAQuery<Long> query = jpaQueryFactory.select(qdo.id.count()).from(qdo)
                .where(qdo.storeId.eq(storeId)).where(qdo.status.eq("DR")).where(qdo.rtType.eq("T")).where(qdo.docCreateDate.goe(startDate));
        List<Long> fetch = query.fetch();
        if (CollectionUtil.isEmpty(fetch)) {
            return 0;
        }
        return fetch.get(0).intValue();
    }

    public Long findOrderCount(Long storeId, LocalDateTime startDate) {
        QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
        QScpDemandOrderDDO scpDemandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        List<String> payStatus = List.of(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
        jpaQuery.where(scpDemandOrderDDO.payStatus.in(payStatus));
        jpaQuery.where(scpDemandOrderDO.demandWhStId.eq(storeId));
        jpaQuery.where(scpDemandOrderDO.createTime.goe(startDate));
        jpaQuery.where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where(scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo);
        return jpaQuery.fetchCount();
    }

    public Long findScpsmanId() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Assert.notNull(userDetails, "登录信息不能为空");
        Assert.notNull(userDetails.getUser(), "登录人不能为空");

        QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;
        JPAQuery<Long> query = jpaQueryFactory.select(scpsmanInfoDO.id).from(scpsmanInfoDO).where(scpsmanInfoDO.loginAccount.eq(userDetails.getUsername()));
        List<Long> ids = query.fetch();
        Assert.notEmpty(ids, "未找到关联的计划员");
        return ids.get(0);
    }

    public String findStoreName(Long orderId) {
        QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
        List<String> storeNames = jpaQueryFactory.select(scpDemandOrderDO.demandWhStName).from(scpDemandOrderDO).where(scpDemandOrderDO.id.eq(orderId)).fetch();
        return CollectionUtil.isEmpty(storeNames) ? null : storeNames.get(0);
    }

    public List<DemandOrderDtl> findOrderDtl(List<Long> orderDidList) {
        QScpDemandOrderDDO ddo = QScpDemandOrderDDO.scpDemandOrderDDO;
        JPAQuery<DemandOrderDtl> where = jpaQueryFactory.select(Projections.bean(DemandOrderDtl.class, ddo.id, ddo.itemId, ddo.price)).from(ddo).where(ddo.id.in(orderDidList));
        return where.fetch();
    }

    public List<DemandOrderDtl> findOrderDtl(Long orderId) {
        QScpDemandOrderDDO ddo = QScpDemandOrderDDO.scpDemandOrderDDO;
        JPAQuery<DemandOrderDtl> where = jpaQueryFactory.select(Projections.bean(DemandOrderDtl.class, ddo.id, ddo.itemId, ddo.price,ddo.imgUrl)).from(ddo)
                .where(ddo.masId.eq(orderId));
        return where.fetch();
    }

    public String storeCalendar(Long storeId) {
        LocalDateTime now = LocalDateTime.now();
        String nonth = String.valueOf(now.getMonthValue());
        if (nonth.length() == 1) {
            nonth = "0" + nonth;
        }
        QScpStoreDemandCalendarDO scpStoreDemandCalendarDO = QScpStoreDemandCalendarDO.scpStoreDemandCalendarDO;
        List<String> fetch = jpaQueryFactory.select(scpStoreDemandCalendarDO.workStatus).from(scpStoreDemandCalendarDO)
                .where(scpStoreDemandCalendarDO.year.eq(String.valueOf(now.getYear())))
                .where(scpStoreDemandCalendarDO.month.eq(nonth))
                .where(scpStoreDemandCalendarDO.day.eq(String.valueOf(now.getDayOfMonth())))
                .where(scpStoreDemandCalendarDO.storeId.eq(storeId)).fetch();
        return CollectionUtil.isNotEmpty(fetch) ? fetch.get(0) : null;
    }

    public List<StoreReceiveDO> findAllByStoreIdInAndByCreateTime(List<Long> storeIds, LocalDateTime fromTime, LocalDateTime toTime) {
        JPAQuery<StoreReceiveDO> jpaQuery = jpaQueryFactory.select(qdo)
                .from(qdo);

        if (CollectionUtil.isNotEmpty(storeIds)) {
            jpaQuery.where(qdo.storeId.in(storeIds));
        }
        if (fromTime != null) {
            jpaQuery.where(qdo.createTime.goe(fromTime));
        }
        if (toTime != null) {
            jpaQuery.where(qdo.createTime.loe(toTime));
        }
        List<StoreReceiveDO> fetch = jpaQuery.fetch();
        return fetch;
    }

    public StoreTodoVO findTodo(StoreReceivePageParam param) {
        JPAQuery<StoreTodoVO> query = jpaQueryFactory.select(Projections.bean(StoreTodoVO.class,
                        qdo.id.count().nullif(0L).as("all"),
                        qdo.rtType.when("T").then(1L).otherwise(0L).sum().nullif(0L).as("rtn"),
                        qdo.rtType.when("R").then(1L).otherwise(0L).sum().nullif(0L).as("receive"))).from(qdo)
                .where(qdo.storeId.in(param.getStoreIds()).and(qdo.status.eq("CE")));
        if (param.getCreateDateFrom() != null) {
            query.where(qdo.docCreateDate.goe(param.getCreateDateFrom()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            query.where(qdo.id.in(param.getIds()));
        }
        List<StoreTodoVO> fetch = query.fetch();
        return CollectionUtil.isNotEmpty(fetch) ? fetch.get(0) : null;
    }

    public StoreRtnTotalVO findRtnTotal(StoreReceivePageParam param) {
        JPAQuery<StoreRtnTotalVO> query = jpaQueryFactory.select(Projections.bean(StoreRtnTotalVO.class,
                        qdo.id.count().nullif(0L).as("all"),
                        qdo.status.when("CE").then(1L).otherwise(0L).sum().nullif(0L).as("ce"),
                        qdo.status.when("CF").then(1L).otherwise(0L).sum().nullif(0L).as("cf"),
                        qdo.status.when("DR").then(1L).otherwise(0L).sum().nullif(0L).as("dr"))).from(qdo)
                .where(qdo.storeId.in(param.getStoreIds()).and(qdo.rtType.eq("T")));
        if (param.getCreateDateFrom() != null) {
            query.where(qdo.docCreateDate.goe(param.getCreateDateFrom()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            query.where(qdo.id.in(param.getIds()));
        }
        List<StoreRtnTotalVO> fetch = query.fetch();
        return CollectionUtil.isNotEmpty(fetch) ? fetch.get(0) : null;
    }

    public StoreReceiveTotalVO findReceiveTotal(StoreReceivePageParam param) {
        JPAQuery<StoreReceiveTotalVO> query = jpaQueryFactory.select(Projections.bean(StoreReceiveTotalVO.class,
                        qdo.id.count().nullif(0L).as("all"),
                        qdo.status.when("CE").then(1L).otherwise(0L).sum().nullif(0L).as("ce"),
                        qdo.status.when("CF").then(1L).otherwise(0L).sum().nullif(0L).as("cf"))).from(qdo)
                .where(qdo.storeId.in(param.getStoreIds()).and(qdo.rtType.eq("R")));
        if (param.getCreateDateFrom() != null) {
            query.where(qdo.docCreateDate.goe(param.getCreateDateFrom()));
        }
        if (CollectionUtil.isNotEmpty(param.getIds())) {
            query.where(qdo.id.in(param.getIds()));
        }
        List<StoreReceiveTotalVO> fetch = query.fetch();
        return CollectionUtil.isNotEmpty(fetch) ? fetch.get(0) : null;
    }

    public List<Long> findItemIdsByCate(List<Long> cateIds) {
        QScpCateItemDO cateItemDO = QScpCateItemDO.scpCateItemDO;
        JPAQuery<Long> query = jpaQueryFactory.select(cateItemDO.itemId).from(cateItemDO).where(cateItemDO.cateId.in(cateIds));
        return query.fetch();
    }

    public List<Long> findDocId(List<Long> itemIds) {
        QStoreReceiveDDO ddo = QStoreReceiveDDO.storeReceiveDDO;
        JPAQuery<Long> query = jpaQueryFactory.select(ddo.masId).from(ddo).where(ddo.itemId.in(itemIds));
        return query.fetch();
    }
}