/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.zhxu.bs.util.StringUtils;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.param.AppItemRpcParamVO;
import com.elitesland.scp.param.CateItemRpcParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ScpCateItemRepoProc {
    private static final Logger log = LoggerFactory.getLogger(ScpCateItemRepoProc.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpCateItemDO scpCateItemDO = QScpCateItemDO.scpCateItemDO;

    public List<String> queryByItemCodes(List<String> itemCodes) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO)).where((Predicate)this.scpCateItemDO.itemCode.in(itemCodes));
        return jpaQuery.fetch();
    }

    public List<String> queryItemCode(CateItemRpcParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateCodes())) {
            predicates.add(this.scpCateItemDO.cateCode.in((Collection)paramVO.getCateCodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateIds())) {
            predicates.add(this.scpCateItemDO.cateId.in((Collection)paramVO.getCateIds()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public List<ScpCateItemDTO> queryDto(CateItemRpcParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpCateItemDTO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateId, this.scpCateItemDO.cateCode, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemName, this.scpCateItemDO.itemId, this.scpCateItemDO.hotFlag, this.scpCateItemDO.combineItemFlag})).from((EntityPath)this.scpCateItemDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateCodes())) {
            predicates.add(this.scpCateItemDO.cateCode.in((Collection)paramVO.getCateCodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateIds())) {
            predicates.add(this.scpCateItemDO.cateId.in((Collection)paramVO.getCateIds()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public Long countAppItemSpu(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        jpaQuery.groupBy(this.scpCateItemDO.spuId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageAppItemSpu(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppItmItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateCode.as("itemCateCode"), this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.sortNo})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        jpaQuery.groupBy(new Expression[]{this.scpCateItemDO.cateCode, this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.sortNo});
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(this.scpCateItemDO.sortNo.desc());
        return jpaQuery.fetch();
    }

    public List<AppItmItemPageVO> getByDocType(AppItemRpcParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppItmItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateCode.as("itemCateCode"), this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.sortNo})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        jpaQuery.orderBy(this.scpCateItemDO.sortNo.desc());
        jpaQuery.groupBy(new Expression[]{this.scpCateItemDO.cateCode, this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.sortNo});
        return jpaQuery.fetch();
    }

    public List<String> pageItemCodesByParam(List<Long> spuIds) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO);
        jpaQuery.where((Predicate)this.scpCateItemDO.spuId.in(spuIds));
        return jpaQuery.fetch();
    }

    public long countItem(ScpCateItemPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO);
        jpaQuery.where(this.whereItemPage(paramVO));
        return jpaQuery.fetchCount();
    }

    private Predicate whereItemPage(ScpCateItemPageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (paramVO.getHotFlag() != null) {
            predicates.add(this.scpCateItemDO.hotFlag.eq(paramVO.getHotFlag()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemType())) {
            predicates.add(this.scpCateItemDO.itemType2.eq((Object)paramVO.getItemType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemType2())) {
            predicates.add(this.scpCateItemDO.itemType.eq((Object)paramVO.getItemType2()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemName())) {
            predicates.add(this.scpCateItemDO.itemName.like("%" + paramVO.getItemName() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemCode())) {
            predicates.add(this.scpCateItemDO.itemCode.like("%" + paramVO.getItemCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getScpCateCodes())) {
            predicates.add(this.scpCateItemDO.cateCode.in(paramVO.getScpCateCodes()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpCateItemRespVO> queryItemList(ScpCateItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpCateItemRespVO.class, (Expression[])new Expression[]{this.scpCateItemDO.id, this.scpCateItemDO.itemId, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemName, this.scpCateItemDO.itemType, this.scpCateItemDO.combineItemFlag})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.whereItemPage(param));
        }
        return jpaQuery.fetch();
    }

    public List<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpCateItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.id, this.scpCateItemDO.id.as("scpCateItemId"), this.scpCateItemDO.itemId, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemName, this.scpCateItemDO.cateCode.as("scpCateCode"), this.scpCateItemDO.cateId.as("scpCateId"), this.scpCateItemDO.hotFlag, this.scpCateItemDO.sortNo, this.scpCateItemDO.combineItemFlag})).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.whereItemPage(param));
        }
        jpaQuery.orderBy(this.scpCateItemDO.sortNo.desc());
        return jpaQuery.fetch();
    }

    public Predicate getPredicates(AppItemPageParamVO paramVO) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.scpCateItemDO.deleteFlag.eq((Object)0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(this.scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank((String)paramVO.getKeyword())) {
            list.add(this.scpCateItemDO.itemCode.contains(paramVO.getKeyword()).or((Predicate)this.scpCateItemDO.itemName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuCode.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.anotherName.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(this.scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty((Object)paramVO.getSpuId())) {
            list.add(this.scpCateItemDO.spuId.eq((Object)paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(this.scpCateItemDO.itemType2.in(paramVO.getItemTypes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
            list.add(this.scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public Predicate getPredicates(AppItemRpcParamVO paramVO) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.scpCateItemDO.deleteFlag.eq((Object)0));
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getItemCateCodes())) {
            list.add(this.scpCateItemDO.cateCode.in((Collection)paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank((String)paramVO.getKeyword())) {
            list.add(this.scpCateItemDO.itemCode.contains(paramVO.getKeyword()).or((Predicate)this.scpCateItemDO.itemName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuCode.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.anotherName.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getItemIds())) {
            list.add(this.scpCateItemDO.itemId.in((Collection)paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty((Object)paramVO.getSpuId())) {
            list.add(this.scpCateItemDO.spuId.eq((Object)paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty((Collection)paramVO.getItemTypes())) {
            list.add(this.scpCateItemDO.itemType2.in((Collection)paramVO.getItemTypes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
            list.add(this.scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public Long changeHotFlag(ScpCateItemHotParamVO paramVO) {
        return this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO).set((Path)this.scpCateItemDO.hotFlag, (Object)paramVO.getHotFlag()).where(new Predicate[]{this.scpCateItemDO.id.in(paramVO.getItemIds())}).execute();
    }

    public void updateItemSpuInfo(String itemType2, String anotherName, Long spuId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        update.set((Path)this.scpCateItemDO.itemType, (Object)itemType2);
        update.set((Path)this.scpCateItemDO.anotherName, (Object)anotherName);
        update.where(new Predicate[]{this.scpCateItemDO.spuId.eq((Object)spuId)});
        update.execute();
    }

    public void updateItemBrand(String brand, Long rootCateId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        if (StrUtil.isNotBlank((CharSequence)brand)) {
            update.set((Path)this.scpCateItemDO.brand, (Object)brand);
        }
        update.where(new Predicate[]{this.scpCateItemDO.rootCateId.eq((Object)rootCateId)});
        update.execute();
    }

    public List<String> getFirstCateByType(List<String> itemTypes, List<String> brands) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.cateCode).from((EntityPath)this.scpCateItemDO)).where((Predicate)this.scpCateItemDO.itemType.in(itemTypes).and((Predicate)this.scpCateItemDO.brand.in(brands)));
        return jpaQuery.fetch();
    }

    public Long countCommonItemSpu(CommonItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getCommonPredicates(param));
        }
        jpaQuery.orderBy(this.scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(this.scpCateItemDO.spuId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageCommonItemSpu(CommonItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppItmItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateCode.as("itemCateCode"), this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.combineItemFlag})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getCommonPredicates(param));
        }
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(this.scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(new Expression[]{this.scpCateItemDO.cateCode, this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.combineItemFlag});
        return jpaQuery.fetch();
    }

    public Predicate getCommonPredicates(CommonItemPageParamVO paramVO) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.scpCateItemDO.deleteFlag.eq((Object)0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(this.scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank((String)paramVO.getKeyword())) {
            list.add(this.scpCateItemDO.itemCode.contains(paramVO.getKeyword()).or((Predicate)this.scpCateItemDO.itemName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuCode.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.anotherName.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(this.scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty((Object)paramVO.getSpuId())) {
            list.add(this.scpCateItemDO.spuId.eq((Object)paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(this.scpCateItemDO.itemType.in(paramVO.getItemTypes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
            list.add(this.scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<Long> appItemSku(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scpCateItemDO.itemId).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        return jpaQuery.fetch();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateItemNameByItemId(String itemName, Long itemId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        update.set((Path)this.scpCateItemDO.itemName, (Object)itemName);
        update.where(new Predicate[]{this.scpCateItemDO.itemId.eq((Object)itemId)});
        update.execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSortNoById(Integer sortNo, Long id) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        update.set(this.scpCateItemDO.sortNo, (Object)sortNo);
        update.where(new Predicate[]{this.scpCateItemDO.id.eq((Object)id)});
        update.execute();
    }

    public ScpCateItemRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

